/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractOptimizationLauncher;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.opt.MaxSatDecorator;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.opt.WeightedMaxSatDecorator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class GenericOptLauncher
extends AbstractOptimizationLauncher {
    private static final long serialVersionUID = 1L;

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of the solver to use");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("k", "kind", true, "kind of problem: minone, maxsat, etc.");
        return options;
    }

    protected void usage() {
        System.out.println("java -jar sat4jmax instance-name");
    }

    protected Reader createReader(ISolver solver, String problemname) {
        if (problemname.endsWith(".wcnf")) {
            return new DimacsReader(solver, "wcnf");
        }
        return new DimacsReader(solver);
    }

    protected String getInstanceName(String[] args) {
        return args[args.length - 1];
    }

    protected ISolver configureSolver(String[] args) {
        Options options = this.createCLIOptions();
        if (args.length == 0) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4jopt.jar", options, true);
            return null;
        }
        try {
            CommandLine cmd = new PosixParser().parse(options, args);
            String kind = cmd.getOptionValue("k");
            if (kind == null) {
                kind = "maxsat";
            }
            if ("minone".equalsIgnoreCase(kind)) {
                return new MinOneDecorator(SolverFactory.newDefault());
            }
            assert ("maxsat".equalsIgnoreCase(kind));
            int problemindex = args.length - 1;
            if (args[problemindex].endsWith(".wcnf")) {
                return new WeightedMaxSatDecorator(SolverFactory.newMiniOPBClauseCardConstrMax());
            }
            return new MaxSatDecorator(SolverFactory.newDefault());
        }
        catch (ParseException e1) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4jopt.jar", options, true);
            return null;
        }
    }

    public static void main(String[] args) {
        GenericOptLauncher lanceur = new GenericOptLauncher();
        lanceur.run(args);
    }
}

