/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Locale;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.Messages;
import org.sat4j.ResultCode;
import org.sat4j.ResultsManager;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.core.DotSearchListener;
import org.sat4j.minisat.core.Solver;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public class Lanceur
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    protected ASolverFactory factory;
    private String filename;
    private String resultsfile;
    private boolean update;
    private boolean replay;

    public static void main(String[] args) {
        Lanceur lanceur = new Lanceur();
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of the solver to use");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("d", "dot", true, "create a sat4j.dot file in current directory representing the search");
        options.addOption("f", "filename", true, "specifies the file to use (in conjunction with -d for instance)");
        options.addOption("r", "replay", true, "replay stored results");
        options.addOption("b", "backup", true, "backup results in specified file");
        options.addOption("u", "update", false, "update results file if needed");
        options.addOption("m", "mute", false, "Set launcher in silent mode");
        Option op = options.getOption("l");
        op.setArgName("libname");
        op = options.getOption("s");
        op.setArgName("solvername");
        op = options.getOption("t");
        op.setArgName("delay");
        op = options.getOption("d");
        return options;
    }

    protected ISolver configureSolver(String[] args) {
        Options options = this.createCLIOptions();
        if (args.length == 0) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4j.jar", options, true);
            return null;
        }
        try {
            CommandLine cmd = new PosixParser().parse(options, args);
            String framework = cmd.getOptionValue("l");
            if (framework == null) {
                framework = "minisat";
            }
            assert (framework.equals("minisat") || framework.equals("ubcsat"));
            try {
                Class<?> clazz = Class.forName("org.sat4j." + framework + ".SolverFactory");
                Class[] params = new Class[]{};
                Method m = clazz.getMethod("instance", params);
                this.factory = (ASolverFactory)m.invoke(null, null);
            }
            catch (Exception e) {
                System.err.println(Messages.getString("Lanceur.wrong.framework"));
                e.printStackTrace();
            }
            String solvername = cmd.getOptionValue("s");
            ISolver asolver = solvername == null ? this.factory.defaultSolver() : this.factory.createSolverByName(solvername);
            String timeout = cmd.getOptionValue("t");
            if (timeout != null) {
                asolver.setTimeout(Integer.parseInt(timeout));
            }
            this.filename = cmd.getOptionValue("f");
            if (cmd.hasOption("d")) {
                String dotfilename = null;
                if (this.filename != null) {
                    dotfilename = cmd.getOptionValue("d");
                }
                if (dotfilename == null) {
                    dotfilename = "sat4j.dot";
                }
                ((Solver)asolver).setSearchListener(new DotSearchListener(dotfilename));
            }
            if (cmd.hasOption("m")) {
                this.setSilent(true);
            }
            int others = 0;
            String[] rargs = cmd.getArgs();
            if (this.filename == null) {
                this.filename = rargs[others++];
            }
            this.update = cmd.hasOption("u");
            this.resultsfile = cmd.getOptionValue("r");
            if (this.resultsfile == null) {
                this.replay = false;
                this.resultsfile = cmd.getOptionValue("b");
            } else {
                this.replay = true;
            }
            while (others < rargs.length) {
                String[] param = rargs[others].split("=");
                assert (param.length == 2);
                this.log("setting " + param[0] + " to " + param[1]);
                try {
                    BeanUtils.setProperty((Object)asolver, (String)param[0], (Object)param[1]);
                }
                catch (Exception e) {
                    this.log("Cannot set parameter : " + args[others]);
                }
                ++others;
            }
            this.log(asolver.toString("c "));
            this.log("timeout: " + asolver.getTimeout() + "s");
            return asolver;
        }
        catch (ParseException e1) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            return null;
        }
    }

    protected Reader createReader(ISolver solver, String problemname) {
        return new InstanceReader(solver);
    }

    public void run(String[] args) {
        if (this.replay) {
            try {
                this.displayHeader();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.solver = this.configureSolver(args);
            if (this.solver == null) {
                return;
            }
            this.runValidationFile(this.solver, this.resultsfile, this.update);
        } else {
            super.run(args);
        }
    }

    void showAvailableSolvers() {
        if (this.factory != null) {
            this.log("Available solvers: ");
            String[] names = this.factory.solverNames();
            int i = 0;
            while (i < names.length) {
                this.log(names[i]);
                ++i;
            }
        }
    }

    protected void usage() {
        this.showAvailableSolvers();
    }

    protected String getInstanceName(String[] args) {
        return this.filename;
    }

    private final void stockValidationFile(ISolver solver, String filename, String wxpFileName, boolean tosave) {
        try {
            if (tosave) {
                new FileWriter(wxpFileName, true).close();
            }
            ResultsManager unitTest = new ResultsManager(wxpFileName, tosave);
            ExitCode exitCode = ExitCode.UNKNOWN;
            Reader reader = this.createReader(solver, filename);
            IProblem problem = reader.parseInstance(filename);
            exitCode = problem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
            ResultCode resultCode = unitTest.compare(filename, exitCode);
            this.getLogWriter().println(ResultsManager.printLine(filename, exitCode, resultCode));
            if (tosave && resultCode != ResultCode.KO && resultCode != ResultCode.WARNING) {
                unitTest.save(wxpFileName);
                System.out.println("File Saved As <" + wxpFileName + ">");
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ParseFormatException e) {
            e.printStackTrace();
        }
        catch (ContradictionException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }

    private void runValidationFile(ISolver solver, String filename, boolean tosave) {
        try {
            ResultsManager unitTest = new ResultsManager(filename, tosave);
            int[] results = new int[ResultCode.values().length + 1];
            String[] stringArray = unitTest.getFiles();
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String file = stringArray[n];
                ExitCode exitCode = ExitCode.UNKNOWN;
                Reader reader = this.createReader(solver, file);
                try {
                    IProblem problem = reader.parseInstance(file);
                    exitCode = problem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
                }
                catch (FileNotFoundException e) {
                    this.log(e.getMessage());
                }
                catch (ParseFormatException e) {
                    this.log(e.getMessage());
                }
                catch (IOException e) {
                    this.log(e.getMessage());
                }
                catch (ContradictionException e) {
                    this.log(e.getMessage());
                }
                catch (TimeoutException e) {
                    this.log(e.getMessage());
                }
                ResultCode resultCode = unitTest.compare(file, exitCode);
                int n3 = resultCode.getValue();
                results[n3] = results[n3] + 1;
                this.getLogWriter().println(ResultsManager.printLine(file, exitCode, resultCode));
                ++n;
            }
            this.getLogWriter().println(Lanceur.getSummary(results));
            if (tosave && Lanceur.getSuccess(results)) {
                String path = String.valueOf(ResultsManager.createPath()) + "." + "WXP".toLowerCase(Locale.getDefault());
                unitTest.save(path);
                System.out.println("File Saved As <" + new File(path).getCanonicalPath() + ">");
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static final boolean getSuccess(int[] results) {
        return results[ResultCode.KO.getValue()] <= 0 && results[ResultCode.WARNING.getValue()] <= 0;
    }

    private static final String getSummary(int[] results) {
        StringBuffer sb = new StringBuffer("\n\nValidation Tests ");
        if (Lanceur.getSuccess(results)) {
            sb.append("Success");
        } else {
            sb.append("Failed");
        }
        sb.append("\nsummary : number of OKs ");
        sb.append(results[ResultCode.OK.getValue()]);
        sb.append("\n          number of KOs ");
        sb.append(results[ResultCode.KO.getValue()]);
        sb.append("\n          number of WARNINGs ");
        sb.append(results[ResultCode.WARNING.getValue()]);
        sb.append("\n          number of UPDATEDs ");
        sb.append(results[ResultCode.UPDATED.getValue()]);
        sb.append("\n          number of UNKNOWNs ");
        sb.append(results[ResultCode.UNKNOWN.getValue()]);
        sb.append('\n');
        return sb.toString();
    }
}

