/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.sat4j.ExitCode;
import org.sat4j.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsManager {
    public static final String SEPARATOR = "=";
    public static final String EXT_JU = "WXP";
    public static final String COMMENT = "#";
    private final String wxpFileName;
    private final Map<String, ExitCode> files;
    private final transient boolean save;

    public ResultsManager(String wxpFileName, boolean save) throws MalformedURLException, IOException {
        this.wxpFileName = wxpFileName;
        this.save = save;
        this.files = ResultsManager.getInformations(wxpFileName);
    }

    public final ResultCode compare(String fileName, ExitCode newCode) {
        ExitCode tmp = this.files.get(fileName);
        ExitCode oldCode = tmp == null ? ExitCode.UNKNOWN : tmp;
        ResultCode resultCode = this.computeResultCode(oldCode, newCode);
        if (this.save && resultCode.equals((Object)ResultCode.UPDATED)) {
            this.files.put(fileName, newCode);
        }
        return resultCode;
    }

    public final void save() throws IOException {
        this.save(this.wxpFileName);
    }

    public String[] getFiles() {
        return this.files.keySet().toArray(new String[0]);
    }

    public final void save(String wxpFileName) throws IOException {
        FileWriter fw = new FileWriter(wxpFileName);
        fw.write(this.getFileDescription());
        fw.close();
    }

    private final String getFileDescription() {
        StringBuffer sb = new StringBuffer("#Evaluation : ");
        sb.append("\n\n");
        for (String file : this.files.keySet()) {
            sb.append(file);
            sb.append(SEPARATOR);
            sb.append((Object)this.files.get(file));
            sb.append('\n');
        }
        sb.append("\n\n#Evaluation END");
        return sb.toString();
    }

    private final ResultCode computeResultCode(ExitCode oldS, ExitCode newS) {
        if (oldS.equals((Object)newS)) {
            return ResultCode.OK;
        }
        if (ExitCode.UNKNOWN.equals((Object)oldS) && (ExitCode.UNSATISFIABLE.equals((Object)newS) || ExitCode.SATISFIABLE.equals((Object)newS))) {
            return ResultCode.UPDATED;
        }
        if ((ExitCode.UNSATISFIABLE.equals((Object)oldS) || ExitCode.SATISFIABLE.equals((Object)oldS)) && ExitCode.UNKNOWN.equals((Object)newS)) {
            return ResultCode.WARNING;
        }
        if (ExitCode.SATISFIABLE.equals((Object)oldS) && ExitCode.UNSATISFIABLE.equals((Object)newS) || ExitCode.UNSATISFIABLE.equals((Object)oldS) && ExitCode.SATISFIABLE.equals((Object)newS)) {
            return ResultCode.KO;
        }
        return ResultCode.UNKNOWN;
    }

    public static final Map<String, ExitCode> getInformations(URL path) throws IOException {
        return ResultsManager.getInformations(new InputStreamReader(path.openStream()));
    }

    public static final Map<String, ExitCode> getInformations(String path) throws MalformedURLException, IOException {
        if (path.startsWith("http://")) {
            return ResultsManager.getInformations(new URL(path));
        }
        return ResultsManager.getInformations(new FileReader(path));
    }

    public static final Map<String, ExitCode> getInformations(Reader in) {
        BufferedReader br = new BufferedReader(in);
        HashMap<String, ExitCode> ci = new HashMap<String, ExitCode>();
        String line = null;
        int cpt = 1;
        try {
            line = br.readLine();
            while (line != null) {
                if (!"".equals(line.trim()) && !line.trim().startsWith(COMMENT)) {
                    StringTokenizer tokens = new StringTokenizer(line, SEPARATOR);
                    if (tokens.countTokens() == 2) {
                        ci.put(tokens.nextToken(), ExitCode.valueOf(tokens.nextToken()));
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                line = br.readLine();
                ++cpt;
            }
        }
        catch (IllegalArgumentException i) {
            System.err.println("File Parsing Error in line " + cpt + "\nError caused by : " + line);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return ci;
    }

    public static final String printLine(String fileName, ExitCode exitCode, ResultCode resultCode) {
        return String.valueOf(fileName) + SEPARATOR + exitCode.toString() + " [" + resultCode.toString() + "]";
    }

    public static final String createPath() {
        StringBuffer sb = new StringBuffer("Eval_");
        sb.append(Calendar.getInstance().getTime().toString().replace(" ", "_").replace(":", "_"));
        return sb.toString();
    }
}

