/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.sat4j.apps.sudoku.CellStatus;
import org.sat4j.apps.sudoku.GUIInput;
import org.sat4j.apps.sudoku.OneCell;
import org.sat4j.apps.sudoku.SDSize;
import org.sat4j.apps.sudoku.SuDokuResources;

class CellGrid
extends JPanel
implements Printable {
    OneCell[][] cells;
    SDSize sdSize;
    GUIInput guiInput;

    CellGrid(SDSize sdSize, GUIInput guiInput) {
        this.sdSize = sdSize;
        this.guiInput = guiInput;
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(new Dimension(1000, 1000));
        Box all = Box.createVerticalBox();
        this.cells = new OneCell[sdSize.getLargeSide()][sdSize.getLargeSide()];
        int r = 0;
        while (r < sdSize.getLargeSide()) {
            if (r > 0 && r % sdSize.getSmallSide() == 0) {
                all.add(Box.createRigidArea(new Dimension(22 * sdSize.getLargeSide(), 3)));
            }
            Box row = Box.createHorizontalBox();
            int c = 0;
            while (c < sdSize.getLargeSide()) {
                if (c > 0 && c % sdSize.getSmallSide() == 0) {
                    row.add(Box.createRigidArea(new Dimension(3, 22)));
                }
                this.cells[r][c] = new OneCell(sdSize.getLargeSide(), guiInput, this.cellColors(r, c));
                this.cells[r][c].addMouseListener(new CellClicked(r, c));
                row.add(this.cells[r][c]);
                ++c;
            }
            all.add(row);
            ++r;
        }
        this.add(Box.createVerticalGlue());
        all.setMinimumSize(new Dimension(22 * sdSize.getLargeSide(), 22 * sdSize.getLargeSide()));
        this.add(all);
        this.add(Box.createVerticalGlue());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "SuDoku Puzzle"));
    }

    Color[] cellColors(int r, int c) {
        int r1 = r / this.sdSize.getSmallSide();
        int c1 = c / this.sdSize.getSmallSide();
        if (this.guiInput.getUseXSudoku() && (r == c || r + c == this.sdSize.getLargeSide() - 1)) {
            return this.guiInput.getDiagonalColors();
        }
        return r1 % 2 == c1 % 2 ? this.guiInput.getBlueColors() : this.guiInput.getWhiteColors();
    }

    public OneCell getCell(int r, int c) {
        return this.cells[r - 1][c - 1];
    }

    public int getIntValue(int r, int c) {
        return this.cells[r - 1][c - 1].getIntValue();
    }

    public CellStatus getStatus(int r, int c) {
        return this.cells[r - 1][c - 1].getStatus();
    }

    public void setIntValue(int r, int c, int v) {
        if (1 <= r && r <= this.sdSize.getLargeSide() && 1 <= c && c <= this.sdSize.getLargeSide()) {
            this.cells[r - 1][c - 1].setIntValue(v);
        }
    }

    public void solverSetIntValue(int r, int c, int v) {
        if (1 <= r && r <= this.sdSize.getLargeSide() && 1 <= c && c <= this.sdSize.getLargeSide()) {
            this.cells[r - 1][c - 1].solverSetIntValue(v);
        }
    }

    public void clear() {
        int r = 0;
        while (r < this.sdSize.getLargeSide()) {
            int c = 0;
            while (c < this.sdSize.getLargeSide()) {
                this.cells[r][c].clear();
                ++c;
            }
            ++r;
        }
    }

    public void refreshCells() {
        int r = 0;
        while (r < this.sdSize.getLargeSide()) {
            int c = 0;
            while (c < this.sdSize.getLargeSide()) {
                this.cells[r][c].refresh();
                ++c;
            }
            ++r;
        }
    }

    public void clearComputers() {
        int r = 0;
        while (r < this.sdSize.getLargeSide()) {
            int c = 0;
            while (c < this.sdSize.getLargeSide()) {
                this.cells[r][c].clearComputers();
                ++c;
            }
            ++r;
        }
    }

    public void protect() {
        int r = 0;
        while (r < this.sdSize.getLargeSide()) {
            int c = 0;
            while (c < this.sdSize.getLargeSide()) {
                this.cells[r][c].protectIfNotClear();
                ++c;
            }
            ++r;
        }
    }

    public void clearProtection() {
        int r = 0;
        while (r < this.sdSize.getLargeSide()) {
            int c = 0;
            while (c < this.sdSize.getLargeSide()) {
                this.cells[r][c].clearProtection();
                ++c;
            }
            ++r;
        }
    }

    public void clearAll() {
        int r = 0;
        while (r < this.sdSize.getLargeSide()) {
            int c = 0;
            while (c < this.sdSize.getLargeSide()) {
                this.cells[r][c].clearProtection();
                this.cells[r][c].clear();
                ++c;
            }
            ++r;
        }
    }

    public void unHighlightAll() {
        int r = 0;
        while (r < this.sdSize.getLargeSide()) {
            int c = 0;
            while (c < this.sdSize.getLargeSide()) {
                this.cells[r][c].unHighlight();
                ++c;
            }
            ++r;
        }
    }

    public void highlight(int r, int c) {
        this.cells[r - 1][c - 1].highlight();
    }

    public String exportString() {
        StringBuffer result = new StringBuffer();
        String separator = System.getProperty("line.separator");
        int r = 0;
        while (r < this.sdSize.getLargeSide()) {
            int c = 0;
            while (c < this.sdSize.getLargeSide()) {
                int v = this.cells[r][c].getIntValue();
                if (c != 0) {
                    result.append(" ");
                }
                if (v < 10) {
                    result.append(" ");
                }
                result.append(v);
                ++c;
            }
            result.append(separator);
            ++r;
        }
        return result.toString();
    }

    public void importString(String s) {
        ImportParser parser = new ImportParser(s);
        int r = 0;
        while (r < this.sdSize.getLargeSide()) {
            int c = 0;
            while (c < this.sdSize.getLargeSide()) {
                int v = parser.nextValue();
                if (v != 0) {
                    this.cells[r][c].setIntValue(v);
                }
                ++c;
            }
            ++r;
        }
    }

    int scaleWidthToHeight(int iconWidth, ImageIcon icon) {
        return iconWidth * icon.getIconHeight() / icon.getIconWidth();
    }

    void drawCell(Graphics2D the2DGraphics, int leftx, int topy, int cellSize, int r, int c) {
        the2DGraphics.drawLine(leftx + c * cellSize, topy + r * cellSize, leftx + (c + 1) * cellSize, topy + r * cellSize);
        the2DGraphics.drawLine(leftx + (c + 1) * cellSize, topy + r * cellSize, leftx + (c + 1) * cellSize, topy + (r + 1) * cellSize);
        the2DGraphics.drawLine(leftx + (c + 1) * cellSize, topy + (r + 1) * cellSize, leftx + c * cellSize, topy + (r + 1) * cellSize);
        the2DGraphics.drawLine(leftx + c * cellSize, topy + (r + 1) * cellSize, leftx + c * cellSize, topy + r * cellSize);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex == 0) {
            String[] allFooters;
            int cellSize = 60;
            int leftx = (int)pageFormat.getImageableX() + 5;
            int topy = (int)pageFormat.getImageableY() + 5;
            int minSide = (int)pageFormat.getImageableWidth() - 10;
            double theScaleFactor = 0.5;
            if (minSide > (int)pageFormat.getImageableHeight() - 10) {
                minSide = (int)pageFormat.getImageableHeight() - 10;
            }
            if (theScaleFactor * (double)cellSize * (double)this.sdSize.getLargeSide() > (double)minSide) {
                cellSize = (int)((double)minSide / (theScaleFactor * (double)this.sdSize.getLargeSide()));
            }
            Graphics2D the2DGraphics = (Graphics2D)graphics;
            the2DGraphics.scale(theScaleFactor, theScaleFactor);
            leftx = (int)((double)leftx / theScaleFactor);
            topy = (int)((double)topy / theScaleFactor);
            the2DGraphics.setColor(Color.BLACK);
            BasicStroke basicStroke = new BasicStroke();
            BasicStroke heavyStroke = new BasicStroke(3.0f);
            BasicStroke veryHeavyStroke = new BasicStroke(5.0f);
            int r = 0;
            while (r <= this.sdSize.getLargeSide()) {
                if (r % this.sdSize.getSmallSide() == 0) {
                    the2DGraphics.setStroke(heavyStroke);
                } else {
                    the2DGraphics.setStroke(basicStroke);
                }
                the2DGraphics.drawLine(leftx, topy + r * cellSize, leftx + this.sdSize.getLargeSide() * cellSize, topy + r * cellSize);
                ++r;
            }
            int c = 0;
            while (c <= this.sdSize.getLargeSide()) {
                if (c % this.sdSize.getSmallSide() == 0) {
                    the2DGraphics.setStroke(heavyStroke);
                } else {
                    the2DGraphics.setStroke(basicStroke);
                }
                the2DGraphics.drawLine(leftx + c * cellSize, topy, leftx + c * cellSize, topy + this.sdSize.getLargeSide() * cellSize);
                ++c;
            }
            the2DGraphics.setStroke(basicStroke);
            Font theFont = the2DGraphics.getFont().deriveFont((float)((double)cellSize / 2.0));
            the2DGraphics.setFont(theFont);
            FontMetrics fontMetrics = the2DGraphics.getFontMetrics();
            int maxDescent = fontMetrics.getMaxDescent();
            int r2 = 0;
            while (r2 < this.sdSize.getLargeSide()) {
                int c2 = 0;
                while (c2 < this.sdSize.getLargeSide()) {
                    int v = this.cells[r2][c2].getIntValue();
                    if (v != 0) {
                        Rectangle2D rect = theFont.getStringBounds("" + v, the2DGraphics.getFontRenderContext());
                        the2DGraphics.setColor(this.cells[r2][c2].getForeground());
                        the2DGraphics.drawString("" + v, (int)((double)(leftx + c2 * cellSize) + ((double)cellSize - rect.getWidth()) / 2.0), (int)((double)(topy + r2 * cellSize) + ((double)cellSize + rect.getHeight()) / 2.0) - maxDescent);
                    }
                    ++c2;
                }
                ++r2;
            }
            the2DGraphics.setColor(Color.BLACK);
            if (this.guiInput.getUseXSudoku()) {
                the2DGraphics.setStroke(veryHeavyStroke);
                r2 = 0;
                while (r2 < this.sdSize.getLargeSide()) {
                    this.drawCell(the2DGraphics, leftx, topy, cellSize, r2, r2);
                    this.drawCell(the2DGraphics, leftx, topy, cellSize, r2, this.sdSize.getLargeSide() - (r2 + 1));
                    ++r2;
                }
                the2DGraphics.setStroke(basicStroke);
            }
            int fontSize = 18;
            Font smallFont = theFont.deriveFont((float)fontSize);
            the2DGraphics.setFont(smallFont);
            StringBuilder footer = new StringBuilder();
            if (this.guiInput.getUseExtra()) {
                footer.append("Complete ");
            }
            if (this.guiInput.getUseXSudoku()) {
                footer.append("X-SuDoku ");
            } else {
                footer.append("SuDoku ");
            }
            int newy = topy + (this.sdSize.getLargeSide() + 1) * cellSize;
            String footerProperty = this.guiInput.getSuDoku().getSuDokuResources().getParsedProperty("printout.footer");
            if (footerProperty == null || footerProperty.length() == 0) {
                footerProperty = this.guiInput.getSuDoku().getSuDokuResources().getStringFromKey("DEFAULT_PRINTER_FOOTER");
            }
            if ((allFooters = footerProperty.split("\n")).length >= 1) {
                footer.append(allFooters[0]);
                the2DGraphics.drawString(footer.toString(), leftx, newy);
            }
            int row = 1;
            while (row < allFooters.length) {
                the2DGraphics.drawString(allFooters[row], leftx, newy + row * fontSize);
                ++row;
            }
            newy += fontSize * allFooters.length;
            SuDokuResources suDokuResources = this.guiInput.getSuDoku().getSuDokuResources();
            ImageIcon sat4jIcon = suDokuResources.getSat4jIcon();
            ImageIcon ecitIcon = suDokuResources.getECITIcon();
            ImageIcon crilIcon = suDokuResources.getCRILIcon();
            ImageIcon objectWebIcon = suDokuResources.getObjectWebIcon();
            ImageIcon scienceFestIcon = suDokuResources.getScienceFestIcon();
            int icony = topy;
            if (this.sdSize.getLargeSide() <= 9) {
                int iconWidth = 250;
                int iconx = leftx + (this.sdSize.getLargeSide() + 1) * cellSize;
                int iconHeight = this.scaleWidthToHeight(iconWidth, sat4jIcon);
                the2DGraphics.drawImage(sat4jIcon.getImage(), iconx, icony, iconWidth, iconHeight, sat4jIcon.getImageObserver());
                icony += iconHeight + 20;
                iconHeight = this.scaleWidthToHeight(iconWidth, ecitIcon);
                the2DGraphics.drawImage(ecitIcon.getImage(), iconx, icony, iconWidth, iconHeight, ecitIcon.getImageObserver());
                icony += iconHeight + 20;
                iconHeight = this.scaleWidthToHeight(iconWidth, crilIcon);
                the2DGraphics.drawImage(crilIcon.getImage(), iconx, icony, iconWidth, iconHeight, crilIcon.getImageObserver());
                icony += iconHeight + 20;
                iconHeight = this.scaleWidthToHeight(iconWidth, objectWebIcon);
                the2DGraphics.drawImage(objectWebIcon.getImage(), iconx, icony, iconWidth, iconHeight, objectWebIcon.getImageObserver());
                icony += iconHeight + 20;
                iconHeight = this.scaleWidthToHeight(iconWidth, scienceFestIcon);
                the2DGraphics.drawImage(scienceFestIcon.getImage(), iconx + 10, icony, iconWidth, iconHeight, scienceFestIcon.getImageObserver());
            } else {
                int iconx = leftx;
                icony = newy + 20;
                int iconWidth = 200;
                iconx = leftx;
                int iconHeight = this.scaleWidthToHeight(iconWidth, sat4jIcon);
                the2DGraphics.drawImage(sat4jIcon.getImage(), iconx, icony, iconWidth, iconHeight, sat4jIcon.getImageObserver());
                iconHeight = this.scaleWidthToHeight(iconWidth, ecitIcon);
                the2DGraphics.drawImage(ecitIcon.getImage(), iconx += iconWidth + 20, icony, iconWidth, iconHeight, ecitIcon.getImageObserver());
                iconHeight = this.scaleWidthToHeight(iconWidth, crilIcon);
                the2DGraphics.drawImage(crilIcon.getImage(), iconx += iconWidth + 20, icony, iconWidth, iconHeight, crilIcon.getImageObserver());
                iconHeight = this.scaleWidthToHeight(iconWidth, objectWebIcon);
                the2DGraphics.drawImage(objectWebIcon.getImage(), iconx += iconWidth + 20, icony, iconWidth, iconHeight, objectWebIcon.getImageObserver());
                iconHeight = this.scaleWidthToHeight(iconWidth, scienceFestIcon);
                the2DGraphics.drawImage(scienceFestIcon.getImage(), iconx += iconWidth + 15, icony - 75, iconWidth, iconHeight, scienceFestIcon.getImageObserver());
            }
            return 0;
        }
        return 1;
    }

    class ImportParser {
        char[] line;
        int p;

        ImportParser(String s) {
            this.line = s.toCharArray();
            this.p = 0;
        }

        /*
         * Unable to fully structure code
         */
        public int nextValue() {
            block4: {
                block5: {
                    finished = false;
                    result = 0;
                    if (this.p >= this.line.length) break block4;
                    while (this.p < this.line.length && this.line[this.p] != '.' && (this.line[this.p] < '0' || this.line[this.p] > '9')) {
                        ++this.p;
                    }
                    if (this.p >= this.line.length || this.line[this.p] != '.') ** GOTO lbl18
                    ++this.p;
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        ch = this.line[this.p];
                        thisValue = ch - 48;
                        result = result * 10 + thisValue;
                        ++this.p;
                        if (this.p < this.line.length) {
                            ch = this.line[this.p];
                        }
                        if (CellGrid.this.sdSize.getLargeSide() >= 10) continue;
                        finished = true;
lbl18:
                        // 3 sources

                        ** while (this.p < this.line.length && !finished && '0' <= this.line[this.p] && this.line[this.p] <= '9')
                    }
                }
                while (this.p < this.line.length && this.line[this.p] != '.' && (this.line[this.p] < '0' || this.line[this.p] > '9')) {
                    ++this.p;
                }
            }
            return result;
        }
    }

    class CellClicked
    extends MouseAdapter {
        int row;
        int column;

        CellClicked(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public void mouseClicked(MouseEvent e) {
            if (CellGrid.this.guiInput.getHintForCell()) {
                try {
                    CellGrid.this.guiInput.getSuDoku().graphicalSolveOneCell(CellGrid.this, this.row + 1, this.column + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CellGrid.this.guiInput.clearHintForCell();
            }
        }
    }
}

