/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.sat4j.apps.sudoku.Coordinate;
import org.sat4j.apps.sudoku.RandomPermutation;

public class CoordinateSet {
    List<Coordinate> coordinates = new ArrayList<Coordinate>();
    Random random = new Random();
    int rows;
    int columns;

    CoordinateSet(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        int r = 1;
        while (r <= rows) {
            int c = 1;
            while (c <= columns) {
                this.coordinates.add(new Coordinate(r, c));
                ++c;
            }
            ++r;
        }
    }

    public Coordinate[] getGroup() {
        Coordinate centre = null;
        if (this.rows % 2 == 1) {
            centre = new Coordinate((this.rows + 1) / 2, (this.columns + 1) / 2);
            this.remove(centre);
        }
        Coordinate[] result = new Coordinate[4];
        result[0] = this.getCoordinate();
        if (result[0].getRow() * 2 == this.rows + 1) {
            result[1] = new Coordinate(result[0].getRow(), this.columns + 1 - result[0].getColumn());
            result[2] = new Coordinate(result[0].getColumn(), result[0].getRow());
            result[3] = new Coordinate(this.columns + 1 - result[0].getColumn(), result[0].getRow());
        } else if (result[0].getColumn() * 2 == this.columns + 1) {
            result[1] = new Coordinate(result[0].getColumn(), result[0].getRow());
            result[2] = new Coordinate(this.rows + 1 - result[0].getRow(), result[0].getColumn());
            result[3] = new Coordinate(result[0].getColumn(), this.rows + 1 - result[0].getRow());
        } else {
            result[1] = new Coordinate(result[0].getRow(), this.columns + 1 - result[0].getColumn());
            result[2] = new Coordinate(this.rows + 1 - result[0].getRow(), result[0].getColumn());
            result[3] = new Coordinate(this.rows + 1 - result[0].getRow(), this.columns + 1 - result[0].getColumn());
        }
        int i = 1;
        while (i <= 3) {
            this.remove(result[i]);
            ++i;
        }
        if (this.rows % 2 == 1) {
            this.coordinates.add(centre);
        }
        return result;
    }

    void remove(Coordinate coord) {
        int row = coord.getRow();
        int column = coord.getColumn();
        boolean finished = false;
        int index = 0;
        while (!finished && index < this.coordinates.size()) {
            Coordinate c = this.coordinates.get(index);
            if (c.getRow() == row && c.getColumn() == column) {
                this.coordinates.remove(index);
                finished = true;
            }
            ++index;
        }
    }

    public Coordinate[] getRandomArray() {
        Coordinate[] result = new Coordinate[this.coordinates.size()];
        int pos = 0;
        while (this.coordinates.size() > 0) {
            if (this.coordinates.size() >= 400) {
                Coordinate[] group = this.getGroup();
                int i = 0;
                while (i < group.length) {
                    result[pos++] = group[i];
                    ++i;
                }
                continue;
            }
            result[pos++] = this.getCoordinate();
        }
        return result;
    }

    public Coordinate[] getSpreadArray() {
        RandomPermutation rpr = new RandomPermutation(this.rows);
        RandomPermutation rpc = new RandomPermutation(this.columns);
        Coordinate[] result = new Coordinate[this.rows];
        int i = 1;
        while (i <= this.rows) {
            result[i - 1] = new Coordinate(rpr.permute(i), rpc.permute(i));
            ++i;
        }
        return result;
    }

    public Coordinate getCoordinate() {
        int index = this.random.nextInt(this.coordinates.size());
        Coordinate result = this.coordinates.get(index);
        this.coordinates.remove(index);
        return result;
    }
}

