/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import org.sat4j.apps.sudoku.CellGrid;
import org.sat4j.apps.sudoku.CommandHandler;
import org.sat4j.apps.sudoku.EditCommand;
import org.sat4j.apps.sudoku.SuDoku;

public class EditCommandHandler
extends CommandHandler {
    public EditCommandHandler(SuDoku sudoku) {
        super(sudoku);
    }

    void writeToClipboard(String writeMe) {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferableText = new StringSelection(writeMe);
        systemClipboard.setContents(transferableText, null);
    }

    String readFromClipboard() {
        String str = "";
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            str = (String)c.getContents(this).getTransferData(DataFlavor.stringFlavor);
            if (str == null) {
                str = "";
            }
        }
        catch (Exception e) {
            str = "";
        }
        return str;
    }

    public void execute(Enum command) {
        switch ((EditCommand)command) {
            case COPY_PUZZLE: {
                String toCopy = this.sudoku.getGui().getCellGrid().exportString();
                if (this.sudoku.getMainProgramWindow().isApplication()) {
                    this.writeToClipboard(toCopy);
                    break;
                }
                this.sudoku.getGui().setPuzzlePaste(toCopy);
                break;
            }
            case PASTE_PUZZLE: {
                String toPaste = this.sudoku.getMainProgramWindow().isApplication() ? this.readFromClipboard() : this.sudoku.getGui().getPuzzlePaste();
                CellGrid cellGrid = this.sudoku.getGui().getCellGrid();
                cellGrid.clearProtection();
                cellGrid.clearAll();
                this.sudoku.getGui().getCellGrid().importString(toPaste);
                this.sudoku.getGui().setProtection(true);
            }
        }
    }
}

