/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.sat4j.apps.sudoku.CellGrid;
import org.sat4j.apps.sudoku.EditCommandHandler;
import org.sat4j.apps.sudoku.EditMenu;
import org.sat4j.apps.sudoku.FileCommandHandler;
import org.sat4j.apps.sudoku.FileMenu;
import org.sat4j.apps.sudoku.HelpCommandHandler;
import org.sat4j.apps.sudoku.HelpMenu;
import org.sat4j.apps.sudoku.MainProgramWindow;
import org.sat4j.apps.sudoku.OneCell;
import org.sat4j.apps.sudoku.SDSize;
import org.sat4j.apps.sudoku.ShowVersions;
import org.sat4j.apps.sudoku.SuDoku;
import org.sat4j.apps.sudoku.SuDokuResources;

class GUIInput
extends JTabbedPane {
    Color[] blueColors;
    Color[] whiteColors;
    Color[] diagonalColors;
    static Color userColor = Color.WHITE;
    static Color solverColor = new Color(255, 230, 230);
    static Color highlightColor = Color.RED;
    SDSize sdSize;
    boolean protectionSet = false;
    CellGrid cellGrid;
    JCheckBox hintForCell;
    JButton check;
    JButton solve;
    JButton exit;
    JButton clear;
    JButton clearComputers;
    JButton protect;
    JButton clearAll;
    JButton twoSize;
    JButton threeSize;
    JButton fourSize;
    JButton fiveSize;
    JButton sixSize;
    JButton randomCellHint;
    JButton protectedColor;
    JButton saveCNF;
    JButton readModel;
    JButton create;
    OneCell fillCount;
    JSpinner.DefaultEditor fillCountEditor;
    JCheckBox onlyCreateUnique;
    JCheckBox useExtra;
    JCheckBox useXSudoku;
    JTextField result;
    JTextArea cnfFile;
    JTextArea cnfModel;
    JTextArea puzzlePasteArea;
    JScrollPane cnfScroll;
    JScrollPane modelScroll;
    JButton fullCNF;
    JButton simplerCNF;
    JButton showModel;
    JButton interpretModel;
    JComponent gridAndControls;
    MainProgramWindow mainProgramWindow;
    SuDoku sudoku;
    SuDokuResources suDokuResources;

    GUIInput(MainProgramWindow mainProgramWindow, SDSize sdSize, SuDoku sudoku, int maxSide) {
        this.mainProgramWindow = mainProgramWindow;
        this.sdSize = sdSize;
        this.sudoku = sudoku;
        this.suDokuResources = sudoku.getSuDokuResources();
        this.createMenuBar(mainProgramWindow.getJMenuBar());
        this.useXSudoku = new JCheckBox("X-SuDoku");
        this.blueColors = new Color[OneCell.getNumberOfColours()];
        this.blueColors[0] = new Color(0, 0, 0);
        this.blueColors[5] = new Color(230, 230, 255);
        this.blueColors[1] = new Color(255, 0, 0);
        this.blueColors[2] = new Color(100, 100, 255);
        this.blueColors[4] = new Color(51, 51, 255);
        this.whiteColors = new Color[OneCell.getNumberOfColours()];
        this.whiteColors[0] = new Color(0, 0, 0);
        this.whiteColors[1] = new Color(255, 0, 0);
        this.whiteColors[5] = new Color(255, 255, 255);
        this.whiteColors[2] = new Color(100, 100, 255);
        this.whiteColors[4] = new Color(51, 51, 255);
        this.diagonalColors = new Color[OneCell.getNumberOfColours()];
        this.diagonalColors[0] = new Color(0, 0, 0);
        this.diagonalColors[1] = new Color(255, 0, 0);
        this.diagonalColors[5] = new Color(170, 170, 170);
        this.diagonalColors[2] = new Color(100, 100, 255);
        this.diagonalColors[4] = new Color(51, 51, 255);
        this.cellGrid = new CellGrid(sdSize, this);
        this.gridAndControls = new JPanel();
        this.gridAndControls.setLayout(new BorderLayout());
        this.add((Component)this.gridAndControls, "Puzzle");
        this.gridAndControls.add((Component)this.cellGrid, "Center");
        Box gridControls = Box.createVerticalBox();
        JPanel genpanel = new JPanel();
        genpanel.setBorder(new TitledBorder(this.suDokuResources.getStringFromKey("LABEL_GENERATION")));
        genpanel.setLayout(new BoxLayout(genpanel, 1));
        JPanel up = new JPanel();
        JPanel down = new JPanel();
        this.create = new JButton(this.suDokuResources.getStringFromKey("BUTTON_CREATE"));
        this.create.addActionListener(new CreateActionListener());
        up.add(this.create);
        this.fillCount = new OneCell(sdSize.getLargeSide() * sdSize.getLargeSide(), this, this.whiteColors);
        this.fillCount.clear();
        this.fillCount.setColumns(3);
        this.fillCount.setMaximumSize(new Dimension(50, 25));
        down.add(new JLabel(this.suDokuResources.getStringFromKey("BUTTON_FILLED_CELLS")));
        down.add(this.fillCount);
        this.useXSudoku.addActionListener(new UseXSudokuActionListener());
        up.add(this.useXSudoku);
        genpanel.add(up);
        genpanel.add(down);
        this.onlyCreateUnique = new JCheckBox(this.suDokuResources.getStringFromKey("BUTTON_UNIQUE"));
        this.onlyCreateUnique.addActionListener(new OnlyCreateUniqueActionListener());
        this.onlyCreateUnique.setSelected(true);
        this.fillCount.protect();
        this.useExtra = new JCheckBox(this.suDokuResources.getStringFromKey("BUTTON_COMPLETE"));
        JPanel extraFeatures = new JPanel();
        extraFeatures.setBorder(new TitledBorder(this.suDokuResources.getStringFromKey("LABEL_UNUSUAL_FEATURES")));
        extraFeatures.add(this.onlyCreateUnique);
        extraFeatures.add(this.useExtra);
        genpanel.add(extraFeatures);
        JPanel sizepanel = new JPanel();
        sizepanel.setBorder(new TitledBorder(this.suDokuResources.getStringFromKey("LABEL_SET_SIZE")));
        sizepanel.setLayout(new GridLayout(2, 1));
        JPanel p1 = new JPanel();
        this.twoSize = new JButton("4 x 4");
        this.twoSize.addActionListener(new GridSizeListener(2));
        p1.add(this.twoSize);
        this.threeSize = new JButton("9 x 9");
        this.threeSize.addActionListener(new GridSizeListener(3));
        p1.add(this.threeSize);
        this.fourSize = new JButton("16 x 16");
        this.fourSize.addActionListener(new GridSizeListener(4));
        p1.add(this.fourSize);
        sizepanel.add(p1);
        if (maxSide >= 25) {
            JPanel p2 = new JPanel();
            this.fiveSize = new JButton("25 x 25");
            this.fiveSize.addActionListener(new GridSizeListener(5));
            p2.add(this.fiveSize);
            if (maxSide >= 36) {
                this.sixSize = new JButton("36 x 36");
                this.sixSize.addActionListener(new GridSizeListener(6));
                p2.add(this.sixSize);
            }
            sizepanel.add(p2);
        }
        genpanel.add(sizepanel);
        gridControls.add(genpanel);
        gridControls.add(Box.createVerticalGlue());
        JPanel userpanel = new JPanel();
        userpanel.setLayout(new GridLayout(3, 1));
        JPanel pu1 = new JPanel();
        this.protect = new JButton(this.suDokuResources.getStringFromKey("BUTTON_PROTECT"));
        this.protect.addActionListener(new ProtectActionListener());
        pu1.add(this.protect);
        this.check = new JButton(this.suDokuResources.getStringFromKey("BUTTON_CHECK"));
        this.check.addActionListener(new CheckActionListener());
        pu1.add(this.check);
        this.solve = new JButton(this.suDokuResources.getStringFromKey("BUTTON_SOLVE"));
        this.solve.addActionListener(new SolveActionListener());
        pu1.add(this.solve);
        userpanel.add(pu1);
        JPanel pu2 = new JPanel();
        this.randomCellHint = new JButton(this.suDokuResources.getStringFromKey("BUTTON_RANDOM"));
        this.randomCellHint.addActionListener(new RandomCellHintActionListener());
        pu2.add(this.randomCellHint);
        this.hintForCell = new JCheckBox(this.suDokuResources.getStringFromKey("BUTTON_CHOSEN"));
        pu2.add(this.hintForCell);
        userpanel.add(pu2);
        JPanel pu3 = new JPanel();
        this.clearComputers = new JButton(this.suDokuResources.getStringFromKey("BUTTON_CLEAR_SOLVERS"));
        this.clearComputers.addActionListener(new ClearComputersActionListener());
        pu3.add(this.clearComputers);
        this.clear = new JButton(this.suDokuResources.getStringFromKey("BUTTON_CLEAR_MINE"));
        this.clear.addActionListener(new ClearActionListener());
        pu3.add(this.clear);
        userpanel.add(pu3);
        gridControls.add(userpanel);
        gridControls.add(Box.createVerticalGlue());
        JPanel colorpanel = new JPanel();
        colorpanel.setBorder(new TitledBorder(this.suDokuResources.getStringFromKey("LABEL_SET_COLOURS")));
        colorpanel.add(new ColorButton(4, this.suDokuResources.getStringFromKey("COLOURS_PROTECTED")));
        colorpanel.add(new ColorButton(1, this.suDokuResources.getStringFromKey("COLOURS_COMPUTERS")));
        colorpanel.add(new ColorButton(0, this.suDokuResources.getStringFromKey("COLOURS_MINE")));
        gridControls.add(Box.createVerticalGlue());
        gridControls.add(colorpanel);
        if (!mainProgramWindow.isApplication()) {
            gridControls.add(Box.createVerticalGlue());
            this.puzzlePasteArea = new JTextArea(1, 5);
            Box hBox10 = Box.createHorizontalBox();
            hBox10.add(new JLabel("Paste area"));
            hBox10.add(new JScrollPane(this.puzzlePasteArea));
            gridControls.add(hBox10);
        }
        gridControls.add(Box.createVerticalGlue());
        this.result = new JTextField(20);
        this.result.setEditable(false);
        this.gridAndControls.add((Component)this.result, "South");
        Box hBox9 = Box.createHorizontalBox();
        hBox9.add(new ShowVersions());
        gridControls.add(hBox9);
        this.gridAndControls.add((Component)gridControls, "East");
        Box cnfTab = Box.createHorizontalBox();
        Box cnfBox = Box.createVerticalBox();
        cnfBox.add(new JLabel("cnf problem"));
        this.cnfFile = new JTextArea(20, 20);
        this.cnfFile.setEditable(false);
        this.cnfScroll = new JScrollPane(this.cnfFile);
        cnfBox.add(this.cnfScroll);
        cnfTab.add(cnfBox);
        Box modelBox = Box.createVerticalBox();
        modelBox.add(new JLabel("solution"));
        this.cnfModel = new JTextArea(10, 10);
        this.modelScroll = new JScrollPane(this.cnfModel);
        modelBox.add(this.modelScroll);
        cnfTab.add(Box.createHorizontalStrut(4));
        cnfTab.add(modelBox);
        Box cnfControls = Box.createVerticalBox();
        Box hBox3 = Box.createHorizontalBox();
        this.fullCNF = new JButton("Full cnf");
        this.fullCNF.addActionListener(new FullCNFActionListener());
        hBox3.add(this.fullCNF);
        this.simplerCNF = new JButton("Simpler cnf");
        this.simplerCNF.addActionListener(new SimplerCNFActionListener());
        hBox3.add(this.simplerCNF);
        cnfControls.add(hBox3);
        Box hBox5 = Box.createHorizontalBox();
        this.showModel = new JButton("Show Model");
        this.showModel.addActionListener(new ShowModelActionListener());
        this.showModel.setEnabled(true);
        hBox5.add(this.showModel);
        this.interpretModel = new JButton("Interpret Model");
        this.interpretModel.addActionListener(new InterpretModelActionListener());
        hBox5.add(this.interpretModel);
        cnfControls.add(hBox5);
        if (mainProgramWindow.fileAccess()) {
            Box fileControls = Box.createHorizontalBox();
            this.saveCNF = new JButton("Save cnf to file");
            this.saveCNF.addActionListener(new SaveCNFActionListener());
            fileControls.add(this.saveCNF);
            this.readModel = new JButton("Read model from file");
            this.readModel.addActionListener(new ReadModelActionListener());
            fileControls.add(this.readModel);
            cnfControls.add(fileControls);
        }
        cnfTab.add(Box.createRigidArea(new Dimension(4, 400)));
        cnfTab.add(cnfControls);
        this.add((Component)cnfTab, "CNF");
        this.setLocalToolTipText(this.create, "TOOLTIP_CREATE");
        this.setLocalToolTipText(this.fillCount, "TOOLTIP_FILLED_CELLS");
        this.setLocalToolTipText(this.useXSudoku, "TOOLTIP_XSUDOKU");
        this.setLocalToolTipText(this.onlyCreateUnique, "TOOLTIP_UNIQUE");
        this.setLocalToolTipText(this.useExtra, "TOOLTIP_COMPLETE");
        this.setLocalToolTipText(this.protect, "TOOLTIP_PROTECT");
        this.setLocalToolTipText(this.check, "TOOLTIP_CHECK");
        this.setLocalToolTipText(this.solve, "TOOLTIP_SOLVE");
        this.setLocalToolTipText(this.randomCellHint, "TOOLTIP_RANDOM");
        this.setLocalToolTipText(this.hintForCell, "TOOLTIP_CHOSEN");
        this.setLocalToolTipText(this.clearComputers, "TOOLTIP_CLEARSOL");
        this.setLocalToolTipText(this.clear, "TOOLTIP_CLEARMINE");
        this.setLocalToolTipText(this.twoSize, "TOOLTIP_SIZE_4_4");
        this.setLocalToolTipText(this.threeSize, "TOOLTIP_SIZE_9_9");
        this.setLocalToolTipText(this.fourSize, "TOOLTIP_SIZE_16_16");
        this.setVisible(true);
    }

    void createMenuBar(JMenuBar menuBar) {
        if (this.mainProgramWindow.fileAccess()) {
            FileCommandHandler fileCommandHandler = new FileCommandHandler(this.sudoku);
            FileMenu fileMenu = new FileMenu(fileCommandHandler, this.sudoku);
            menuBar.add(fileMenu);
        }
        EditCommandHandler editCommandHandler = new EditCommandHandler(this.sudoku);
        EditMenu editMenu = new EditMenu(editCommandHandler, this.sudoku);
        menuBar.add(editMenu);
        HelpCommandHandler helpCommandHandler = new HelpCommandHandler(this.sudoku);
        HelpMenu helpMenu = new HelpMenu(helpCommandHandler, this.sudoku);
        menuBar.add(helpMenu);
    }

    void setLocalToolTipText(JComponent component, String text) {
        component.setToolTipText(this.suDokuResources.getStringFromKey(text));
    }

    public void puzzleChanged() {
        this.cnfModel.setText("");
        this.cnfFile.setText("");
        this.showModel.setEnabled(false);
    }

    public String getPuzzlePaste() {
        return this.puzzlePasteArea.getText();
    }

    public void setPuzzlePaste(String s) {
        this.puzzlePasteArea.setText(s);
    }

    public boolean getUseExtra() {
        return this.useExtra.isSelected();
    }

    public boolean getUseXSudoku() {
        return this.useXSudoku.isSelected();
    }

    public void setResult(String r) {
        this.result.setText(r);
    }

    public void setCNFFile(String s) {
        this.cnfFile.setText(s);
    }

    public String getCNFFile() {
        return this.cnfFile.getText();
    }

    public void setCNFModel(String s) {
        this.cnfModel.setText(s);
    }

    public String getCNFModel() {
        return this.cnfModel.getText();
    }

    public void clearCNF() {
        this.setCNFFile("");
        this.setCNFModel("");
    }

    public CellGrid getCellGrid() {
        return this.cellGrid;
    }

    public void setColor(int id, Color c) {
        this.blueColors[id] = c;
        this.whiteColors[id] = c;
        this.cellGrid.refreshCells();
    }

    public void setSize(int width, int height) {
        this.mainProgramWindow.setMainWindowSize(width, height);
        super.setSize(width, height);
    }

    public void setFillCount(int count) {
        this.fillCount.clearProtection();
        this.fillCount.setText("" + count);
        if (this.onlyCreateUnique.isSelected()) {
            this.fillCount.protect();
        }
    }

    public Color[] getBlueColors() {
        return this.blueColors;
    }

    public Color[] getWhiteColors() {
        return this.whiteColors;
    }

    public Color[] getDiagonalColors() {
        return this.diagonalColors;
    }

    long memoryNeeded() {
        long result = 0L;
        switch (this.sdSize.getLargeSide()) {
            case 4: {
                result = 20000000L;
                break;
            }
            case 9: {
                result = 50000000L;
                break;
            }
            case 16: {
                result = 50000000L;
                break;
            }
            case 25: {
                result = 50000000L;
            }
        }
        return result;
    }

    boolean enoughMemory() {
        Runtime runtime = Runtime.getRuntime();
        long memory = runtime.maxMemory();
        boolean result = memory > this.memoryNeeded();
        return result;
    }

    void solve(boolean showModel) {
        this.setResult("");
        if (this.enoughMemory()) {
            try {
                this.sudoku.graphicalSolve(this.cellGrid, showModel);
            }
            catch (Exception excpt) {
                excpt.printStackTrace();
            }
        } else {
            this.notEnoughMemory();
        }
    }

    void notEnoughMemory() {
        this.setResult("For this grid, java memory of " + this.memoryNeeded() + " needed");
    }

    void setProtection(boolean state) {
        if (state) {
            this.cellGrid.protect();
            this.protect.setText(this.suDokuResources.getStringFromKey("BUTTON_UNPROTECT"));
            this.protectionSet = true;
        } else {
            this.cellGrid.clearProtection();
            this.protect.setText(this.suDokuResources.getStringFromKey("BUTTON_PROTECT"));
            this.protectionSet = false;
        }
    }

    public boolean getHintForCell() {
        return this.hintForCell.isSelected();
    }

    public void clearHintForCell() {
        this.hintForCell.setSelected(false);
    }

    public SuDoku getSuDoku() {
        return this.sudoku;
    }

    class CheckActionListener
    implements ActionListener {
        CheckActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.checkSolution(GUIInput.this.cellGrid);
        }
    }

    class RandomCellHintActionListener
    implements ActionListener {
        RandomCellHintActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.randomCellHint(GUIInput.this.cellGrid);
        }
    }

    class CreateActionListener
    implements ActionListener {
        CreateActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setCursor(Cursor.getPredefinedCursor(3));
            GUIInput.this.setResult("");
            GUIInput.this.clearCNF();
            if (GUIInput.this.enoughMemory()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ((CreateActionListener)CreateActionListener.this).GUIInput.this.sudoku.createPuzzle(((CreateActionListener)CreateActionListener.this).GUIInput.this.fillCount.getIntValue(), ((CreateActionListener)CreateActionListener.this).GUIInput.this.cellGrid, ((CreateActionListener)CreateActionListener.this).GUIInput.this.onlyCreateUnique.isSelected());
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            } else {
                GUIInput.this.notEnoughMemory();
            }
            GUIInput.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class SolveActionListener
    implements ActionListener {
        SolveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.solve(false);
        }
    }

    class UseXSudokuActionListener
    implements ActionListener {
        UseXSudokuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (GUIInput.this.getUseXSudoku()) {
                GUIInput.this.cellGrid.clearProtection();
                GUIInput.this.cellGrid.clear();
                int r = 1;
                while (r <= GUIInput.this.sdSize.getLargeSide()) {
                    GUIInput.this.cellGrid.getCell(r, r).setColors(GUIInput.this.diagonalColors);
                    GUIInput.this.cellGrid.getCell(r, GUIInput.this.sdSize.getLargeSide() + 1 - r).setColors(GUIInput.this.diagonalColors);
                    ++r;
                }
            } else {
                int r = 1;
                while (r <= GUIInput.this.sdSize.getLargeSide()) {
                    GUIInput.this.cellGrid.getCell(r, r).setColors(GUIInput.this.cellGrid.cellColors(r - 1, r - 1));
                    GUIInput.this.cellGrid.getCell(r, GUIInput.this.sdSize.getLargeSide() + 1 - r).setColors(GUIInput.this.cellGrid.cellColors(r - 1, GUIInput.this.sdSize.getLargeSide() - r));
                    ++r;
                }
            }
        }
    }

    class SimplerCNFActionListener
    implements ActionListener {
        SimplerCNFActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.simplerCNF(GUIInput.this.cellGrid);
        }
    }

    class FullCNFActionListener
    implements ActionListener {
        FullCNFActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.sudoku.fullCNF(GUIInput.this.cellGrid);
        }
    }

    class ShowModelActionListener
    implements ActionListener {
        ShowModelActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.setCNFModel("");
            GUIInput.this.solve(true);
        }
    }

    class InterpretModelActionListener
    implements ActionListener {
        InterpretModelActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.cellGrid.clearComputers();
            GUIInput.this.sudoku.interpretModel(GUIInput.this.cellGrid);
        }
    }

    class OnlyCreateUniqueActionListener
    implements ActionListener {
        OnlyCreateUniqueActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (GUIInput.this.onlyCreateUnique.isSelected()) {
                GUIInput.this.fillCount.clearProtection();
                GUIInput.this.fillCount.clear();
                GUIInput.this.fillCount.protect();
            } else {
                GUIInput.this.fillCount.clearProtection();
                GUIInput.this.fillCount.clear();
            }
        }
    }

    class ColorButton
    extends JButton {
        ColorButton(int id, String title) {
            super(title);
            this.setBackground(Color.WHITE);
            this.setForeground(GUIInput.this.whiteColors[id]);
            this.addActionListener(new ColorActionListener(this, id, "Set " + title + " colour"));
        }
    }

    class ColorActionListener
    implements ActionListener {
        int id;
        String title;
        ColorButton owner;

        public ColorActionListener(ColorButton owner, int id, String title) {
            this.id = id;
            this.title = title;
            this.owner = owner;
        }

        public void actionPerformed(ActionEvent e) {
            Color newColor = JColorChooser.showDialog(GUIInput.this, this.title, GUIInput.this.whiteColors[this.id]);
            if (newColor != null) {
                GUIInput.this.setColor(this.id, newColor);
                GUIInput.this.fillCount.refresh();
                this.owner.setForeground(newColor);
            }
        }
    }

    class GridSizeListener
    implements ActionListener {
        int side;

        GridSizeListener(int side) {
            this.side = side;
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.sdSize.setSide(this.side);
            CellGrid newCellGrid = new CellGrid(GUIInput.this.sdSize, GUIInput.this);
            GUIInput.this.fillCount.clearProtection();
            GUIInput.this.fillCount.setMax(GUIInput.this.sdSize.getLargeSide() * GUIInput.this.sdSize.getLargeSide());
            GUIInput.this.fillCount.clear();
            GUIInput.this.gridAndControls.remove(GUIInput.this.cellGrid);
            GUIInput.this.cellGrid = newCellGrid;
            GUIInput.this.gridAndControls.add((Component)GUIInput.this.cellGrid, 0);
            GUIInput.this.onlyCreateUnique.setSelected(true);
            GUIInput.this.fillCount.protect();
            if (this.side > 4) {
                if (!GUIInput.this.sudoku.getCreateUniqueAllowed()) {
                    GUIInput.this.onlyCreateUnique.setEnabled(false);
                    GUIInput.this.fillCount.clearProtection();
                }
                GUIInput.this.mainProgramWindow.maximize();
            } else {
                GUIInput.this.onlyCreateUnique.setEnabled(true);
            }
            GUIInput.this.setProtection(false);
            GUIInput.this.gridAndControls.validate();
            GUIInput.this.gridAndControls.repaint();
            GUIInput.this.mainProgramWindow.pack();
        }
    }

    class ClearActionListener
    implements ActionListener {
        ClearActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.clearCNF();
            GUIInput.this.cellGrid.clear();
        }
    }

    class ClearComputersActionListener
    implements ActionListener {
        ClearComputersActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.cellGrid.clearComputers();
        }
    }

    class ProtectActionListener
    implements ActionListener {
        ProtectActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.setProtection(!GUIInput.this.protectionSet);
        }
    }

    class ClearAllActionListener
    implements ActionListener {
        ClearAllActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            GUIInput.this.clearCNF();
            GUIInput.this.cellGrid.clearAll();
        }
    }

    class ExitActionListener
    implements ActionListener {
        ExitActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setResult("");
            System.exit(1);
        }
    }

    class SaveCNFActionListener
    implements ActionListener {
        SaveCNFActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.mainProgramWindow.writeFile(GUIInput.this.getCNFFile());
        }
    }

    class ReadModelActionListener
    implements ActionListener {
        ReadModelActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIInput.this.setCNFModel(GUIInput.this.mainProgramWindow.readFile());
        }
    }
}

