/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.sat4j.apps.sudoku.CommandHandler;
import org.sat4j.apps.sudoku.HelpCommand;
import org.sat4j.apps.sudoku.ShowVersions;
import org.sat4j.apps.sudoku.SuDoku;
import org.sat4j.apps.sudoku.SuDokuResources;

public class HelpCommandHandler
extends CommandHandler {
    static String sudokuURL = "http://www.cs.qub.ac.uk/~i.spence/SuDoku/SuDoku.html";
    static String completeSudokuURL = "http://www.cs.qub.ac.uk/~i.spence/SuDoku/Complete.html";
    static String sat4jURL = "http://www.sat4j.org/";

    public HelpCommandHandler(SuDoku sudoku) {
        super(sudoku);
    }

    void processWebPage(String url) {
        try {
            if (this.sudoku.getMainProgramWindow().isApplet()) {
                ((JApplet)((Object)this.sudoku.getMainProgramWindow())).getAppletContext().showDocument(new URL(url), "SD_HELP_WINDOW");
            } else {
                WebPage webPage = new WebPage(url);
                webPage.setVisible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sudoku.getGui().setResult(e.toString());
        }
    }

    void processAboutPage() {
        ShowVersions showVersions = new ShowVersions();
        String aboutMessage = "<html>SuDoku " + showVersions.getVersion("sudoku") + " at " + sudokuURL + "<p>" + "satj4 " + showVersions.getVersion("sat4j") + " at " + sat4jURL + " (includes source code)";
        JPanel panelall = new JPanel();
        panelall.setLayout(new GridLayout(2, 1));
        JPanel logos = new JPanel();
        logos.setLayout(new GridLayout(1, 3));
        logos.setBackground(Color.WHITE);
        logos.setOpaque(true);
        SuDokuResources suDokuResources = this.sudoku.getSuDokuResources();
        ImageIcon sat4jIcon = suDokuResources.getSat4jIcon();
        ImageIcon ecitIcon = suDokuResources.getECITIcon();
        ImageIcon crilIcon = suDokuResources.getCRILIcon();
        ImageIcon objectWebIcon = suDokuResources.getObjectWebIcon();
        int imageWidth = 150;
        ImageIcon smallSat4jIcon = new ImageIcon(sat4jIcon.getImage().getScaledInstance(imageWidth, -1, 0));
        ImageIcon smallEcitIcon = new ImageIcon(ecitIcon.getImage().getScaledInstance(imageWidth, -1, 0));
        ImageIcon smallCrilIcon = new ImageIcon(crilIcon.getImage().getScaledInstance(imageWidth, -1, 0));
        ImageIcon smallObjectWebIcon = new ImageIcon(objectWebIcon.getImage().getScaledInstance(imageWidth, -1, 0));
        logos.add(new JLabel(smallEcitIcon));
        logos.add(new JLabel(smallCrilIcon));
        logos.add(new JLabel(smallObjectWebIcon));
        panelall.add(logos);
        panelall.add(new JLabel(aboutMessage));
        JOptionPane.showMessageDialog(null, panelall, this.sudoku.getSuDokuResources().getStringFromKey("HELP_ABOUT"), 1, smallSat4jIcon);
    }

    public void execute(Enum command) {
        switch ((HelpCommand)command) {
            case ABOUT: {
                this.processAboutPage();
                break;
            }
            case SUDOKU: {
                this.processWebPage(sudokuURL);
                break;
            }
            case COMPLETE_SUDOKU: {
                this.processWebPage(completeSudokuURL);
                break;
            }
            case SAT4J: {
                this.processWebPage(sat4jURL);
            }
        }
    }

    class WebPage
    extends JFrame {
        WebPage(String url) throws Exception {
            super("Help");
            this.setDefaultCloseOperation(2);
            Box panel = Box.createVerticalBox();
            Box heading = Box.createHorizontalBox();
            heading.add(new JLabel("Contents of web page "));
            JTextField address = new JTextField(url);
            address.setEditable(false);
            address.setColumns(url.length());
            heading.add(address);
            panel.add(heading);
            Box heading2 = Box.createHorizontalBox();
            heading2.add(new JLabel("Note that this window does not support hyperlinks - you can copy the above address to paste into a browser with <Ctrl-A><Ctrl-C>"));
            heading2.add(Box.createHorizontalGlue());
            panel.add(heading2);
            panel.add(Box.createVerticalStrut(4));
            JEditorPane pane = null;
            this.setSize(new Dimension(800, 600));
            pane = new JEditorPane(url);
            pane.setEditable(false);
            pane.setPreferredSize(new Dimension(200, 10000));
            panel.add(pane);
            this.getContentPane().add(new JScrollPane(panel, 20, 30));
        }
    }
}

