/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.util.List;
import java.util.Vector;

public class LineScanner {
    private List<String> markers;
    private String text;
    private String line;
    int thisLineStart;
    int thisLineEnd;
    int nextLineStart;

    LineScanner(String text) {
        this.text = text;
        this.thisLineStart = 0;
        this.markers = new Vector<String>();
        this.markers.add("\n");
        this.markers.add("\r");
        this.markers.add("\r\n");
        this.readNextLine();
    }

    private void readNextLine() {
        if (this.thisLineStart >= this.text.length()) {
            this.line = null;
        } else {
            this.nextLineStart = this.thisLineEnd = this.text.length();
            int i = 0;
            while (i < this.markers.size()) {
                String terminator = this.markers.get(i);
                int index = this.text.indexOf(terminator, this.thisLineStart);
                if (index != -1 && (index < this.thisLineEnd || index == this.thisLineEnd && index + terminator.length() > this.nextLineStart)) {
                    this.thisLineEnd = index;
                    this.nextLineStart = this.thisLineEnd + terminator.length();
                }
                ++i;
            }
            this.line = this.text.substring(this.thisLineStart, this.thisLineEnd);
            this.thisLineStart = this.nextLineStart;
        }
    }

    public boolean hasNext() {
        return this.line != null;
    }

    public String next() {
        String result = this.line;
        this.readNextLine();
        return result;
    }

    public void close() {
    }
}

