/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.sat4j.apps.sudoku.CellStatus;
import org.sat4j.apps.sudoku.GUIInput;

public class OneCell
extends JTextField {
    int max;
    boolean protcted;
    GUIInput guiInput;
    CellStatus status;
    Color[] colors;
    static Color[] nullColors = new Color[]{Color.BLACK, Color.WHITE, Color.RED, Color.WHITE, Color.RED, Color.WHITE};
    public static final int USER_COLOR_ID = 0;
    public static final int SOLVER_COLOR_ID = 1;
    public static final int HIGHLIGHT_COLOR_ID = 2;
    public static final int DISABLED_COLOR_ID = 3;
    public static final int PROTECTED_COLOR_ID = 4;
    public static final int BACKGROUND_COLOR_ID = 5;
    public static final int UNUSED_COLOR_ID = 6;

    public OneCell(GUIInput guiInput, Color[] colors) {
        super(2);
        this.guiInput = guiInput;
        this.status = CellStatus.USER_ENTERED;
        this.colors = colors;
        this.setFont(this.getFont().deriveFont(1, 18.0f));
        this.setHorizontalAlignment(0);
        this.unHighlight();
    }

    public OneCell() {
        this(null, nullColors);
    }

    public void protect() {
        this.protcted = true;
        this.setStatus(CellStatus.PROTECTED);
    }

    public void protectIfNotClear() {
        if (this.getText().length() > 0) {
            this.protect();
        }
    }

    public boolean getProtected() {
        return this.protcted;
    }

    public void clearProtection() {
        this.protcted = false;
        this.setEditable(true);
        this.setStatus(CellStatus.USER_ENTERED);
    }

    public OneCell(int max, GUIInput guiInput, Color[] colors) {
        this(guiInput, colors);
        this.max = max;
        this.protcted = false;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
        this.refresh();
    }

    public OneCell(int max) {
        this(max, null, nullColors);
    }

    public void setMax(int max) {
        this.max = max;
    }

    public String getaText() {
        return this.getText();
    }

    public int getIntValue() {
        int result = 0;
        if (this.getText().length() != 0) {
            try {
                result = Integer.parseInt(this.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public void setIntValue(int v) {
        if (!this.protcted) {
            this.setText("" + v);
        }
    }

    public void solverSetIntValue(int v) {
        if (!this.protcted && this.getText().equals("")) {
            this.setText("" + v);
            this.setStatus(CellStatus.SOLVER_ENTERED);
        }
    }

    public void clear() {
        this.unHighlight();
        if (!this.protcted) {
            this.setText("");
            this.setStatus(CellStatus.USER_ENTERED);
        }
    }

    public void clearComputers() {
        this.unHighlight();
        if (!this.protcted && this.status == CellStatus.SOLVER_ENTERED) {
            this.setText("");
            this.setStatus(CellStatus.USER_ENTERED);
        }
    }

    public void highlight() {
        this.setBackground(this.colors[2]);
    }

    public void unHighlight() {
        this.setStatus(this.status);
    }

    public void refresh() {
        this.setStatus(this.status);
    }

    public void setStatus(CellStatus status) {
        this.status = status;
        switch (status) {
            case PROTECTED: {
                this.setBackground(this.colors[5]);
                this.setForeground(this.colors[4]);
                break;
            }
            case USER_ENTERED: {
                this.setForeground(this.colors[0]);
                this.setBackground(this.colors[5]);
                break;
            }
            case SOLVER_ENTERED: {
                this.setForeground(this.colors[1]);
                this.setBackground(this.colors[5]);
            }
        }
    }

    public CellStatus getStatus() {
        return this.status;
    }

    public static int getNumberOfColours() {
        return 6;
    }

    protected Document createDefaultModel() {
        return new BoundedIntegerDocument();
    }

    public class BoundedIntegerDocument
    extends PlainDocument {
        BoundedIntegerDocument() {
        }

        public void remove(int off, int len) throws BadLocationException {
            if (OneCell.this.status != CellStatus.PROTECTED) {
                super.remove(off, len);
            }
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || OneCell.this.status == CellStatus.PROTECTED) {
                return;
            }
            OneCell.this.unHighlight();
            if (offs == 0 && str.length() == 0) {
                OneCell.this.setStatus(CellStatus.USER_ENTERED);
                super.insertString(offs, str, a);
                return;
            }
            boolean ok = false;
            try {
                int v = Integer.parseInt(String.valueOf(OneCell.this.getaText()) + str);
                boolean bl = ok = v >= 1 && v <= OneCell.this.max;
                if (ok) {
                    OneCell.this.setStatus(CellStatus.USER_ENTERED);
                    super.insertString(offs, str, a);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

