/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import org.sat4j.apps.sudoku.MainProgramWindow;
import org.sat4j.apps.sudoku.SuDoku;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.Solver;
import org.sat4j.reader.DimacsReader;

public class SDWebStart
extends JFrame
implements MainProgramWindow {
    FileSaveService fss;
    FileOpenService fos;
    SuDoku suDoku;
    static String[] extensions = new String[]{".cnf"};
    JMenuBar menuBar = new JMenuBar();

    public static void main(String[] argv) throws Exception {
        if (argv.length == 0) {
            new SDWebStart(16);
        } else {
            try {
                new SDWebStart(Integer.parseInt(argv[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setMainWindowSize(int width, int height) {
    }

    public boolean isApplet() {
        return false;
    }

    public boolean isApplication() {
        return false;
    }

    public boolean isWebStart() {
        return true;
    }

    public void maximize() {
        this.setExtendedState(6);
        this.validate();
        this.repaint();
    }

    public boolean fileAccess() {
        try {
            this.fos = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
            this.fss = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
        }
        catch (UnavailableServiceException e) {
            this.fss = null;
            this.fos = null;
        }
        return this.fos != null && this.fss != null;
    }

    public String readFile() {
        StringBuffer result = new StringBuffer();
        try {
            FileContents fc = this.fos.openFileDialog(null, null);
            InputStream is = fc.getInputStream();
            int ch = is.read();
            while (ch >= 0) {
                result.append((char)ch);
                ch = is.read();
            }
        }
        catch (Exception e) {
            result = new StringBuffer("File not read");
        }
        return result.toString();
    }

    public void writeFile(String s) {
        try {
            StringInputStream is = new StringInputStream(s);
            FileContents newfc = this.fss.saveFileDialog(null, extensions, (InputStream)is, "newFileName.cnf");
        }
        catch (IOException e) {
            this.suDoku.getGui().setResult("File not written");
        }
    }

    SDWebStart(int maxSide) {
        this.setJMenuBar(this.menuBar);
        this.suDoku = new SuDoku(this, maxSide, false);
        this.getContentPane().add(new JScrollPane(this.suDoku.getGui()));
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        this.setVisible(true);
    }

    static void solve(String filename) throws Exception {
        Solver solver = (Solver)SolverFactory.newMiniLearning();
        DimacsReader reader = new DimacsReader(solver);
        reader.parseInstance(filename);
        if (solver.isSatisfiable()) {
            System.out.println("yes");
        } else {
            System.out.println("no");
        }
        System.out.println("starts = " + solver.getStats().starts + "\n");
        System.out.println("conflicts = " + solver.getStats().conflicts + "\n");
    }

    public class StringInputStream
    extends InputStream {
        StringReader sr;

        StringInputStream(String s) {
            this.sr = new StringReader(s);
        }

        public int read() throws IOException {
            return this.sr.read();
        }
    }
}

