/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.sat4j.apps.sudoku.Coordinate;

public class SortedCoordinateSet {
    private List<Coordinate> coordinates = new Vector<Coordinate>();
    private int rows;
    private int columns;
    private int smallSide;
    private int[][] score;
    private int[][] values;

    SortedCoordinateSet(int rows, int columns, int smallSide, int[][] v) {
        this.rows = rows;
        this.columns = columns;
        this.smallSide = smallSide;
        this.score = new int[rows + 1][columns + 1];
        int r = 1;
        while (r <= rows) {
            int c = 1;
            while (c <= columns) {
                this.coordinates.add(new Coordinate(r, c));
                this.score[rows][columns] = 0;
                ++c;
            }
            ++r;
        }
        this.values = v;
        Collections.sort(this.coordinates, new CompareCoords());
    }

    public void note(Coordinate c) {
        int c1 = 1;
        while (c1 <= this.columns) {
            int[] nArray = this.score[c.getRow()];
            int n = c1++;
            nArray[n] = nArray[n] + 1;
        }
        int r1 = 1;
        while (r1 <= this.columns) {
            int[] nArray = this.score[r1];
            int n = c.getColumn();
            nArray[n] = nArray[n] + 1;
            ++r1;
        }
        int a = (c.getRow() - 1) / this.smallSide + 1;
        a = (a - 1) * this.smallSide + 1;
        int b = (c.getColumn() - 1) / this.smallSide + 1;
        b = (b - 1) * this.smallSide + 1;
        int r12 = a;
        while (r12 < a + this.smallSide) {
            int c12 = b;
            while (c12 < b + this.smallSide) {
                int[] nArray = this.score[r12];
                int n = c12++;
                nArray[n] = nArray[n] + 1;
            }
            ++r12;
        }
        int val = this.values[c.getRow()][c.getColumn()];
        int r13 = 1;
        while (r13 <= this.rows) {
            int c13 = 1;
            while (c13 <= this.columns) {
                if (this.values[r13][c13] == val) {
                    int[] nArray = this.score[r13];
                    int n = c13;
                    nArray[n] = nArray[n] + 1;
                }
                ++c13;
            }
            ++r13;
        }
        Collections.sort(this.coordinates, new CompareCoords());
    }

    public Coordinate[] getAll() {
        Coordinate[] result = new Coordinate[this.rows * this.columns];
        int i = 0;
        while (i < this.rows * this.columns) {
            result[i] = this.coordinates.get(i);
            ++i;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CompareCoords
    implements Comparator<Coordinate> {
        CompareCoords() {
        }

        @Override
        public int compare(Coordinate c1, Coordinate c2) {
            if (SortedCoordinateSet.this.score[c1.getRow()][c1.getColumn()] < SortedCoordinateSet.this.score[c2.getRow()][c2.getColumn()]) {
                return -1;
            }
            if (SortedCoordinateSet.this.score[c1.getRow()][c1.getColumn()] == SortedCoordinateSet.this.score[c2.getRow()][c2.getColumn()]) {
                return 0;
            }
            return 1;
        }
    }
}

