/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.util.Random;
import javax.swing.ProgressMonitor;
import org.sat4j.apps.sudoku.CellGrid;
import org.sat4j.apps.sudoku.CellStatus;
import org.sat4j.apps.sudoku.Coordinate;
import org.sat4j.apps.sudoku.CoordinateSet;
import org.sat4j.apps.sudoku.GUIInput;
import org.sat4j.apps.sudoku.LineScanner;
import org.sat4j.apps.sudoku.MainProgramWindow;
import org.sat4j.apps.sudoku.RandomPermutation;
import org.sat4j.apps.sudoku.SDSize;
import org.sat4j.apps.sudoku.SortedCoordinateSet;
import org.sat4j.apps.sudoku.SuDokuResources;
import org.sat4j.apps.sudoku.WordScanner;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;

public class SuDoku {
    SDSize sdSize;
    int clauses;
    GUIInput gui;
    boolean fullCNF;
    boolean createUniqueAllowed;
    SuDokuResources suDokuResources;
    MainProgramWindow mainProgramWindow;
    VecInt vi = new VecInt();
    VecInt vi1 = new VecInt();
    VecInt vi2 = new VecInt();
    ISolver solver;
    Random randomCellChooser;
    boolean passesCheck;
    boolean completed;

    int variable(int row, int column, int v) {
        return row * this.sdSize.getBase() * this.sdSize.getBase() + column * this.sdSize.getBase() + v;
    }

    public MainProgramWindow getMainProgramWindow() {
        return this.mainProgramWindow;
    }

    public SuDokuResources getSuDokuResources() {
        return this.suDokuResources;
    }

    void addOneSquareSolver(int row, int column, ClauseHandler ch) {
        if (this.fullCNF) {
            this.vi.clear();
            int v = 1;
            while (v <= this.sdSize.getLargeSide()) {
                this.vi.push(this.variable(row, column, v));
                ++v;
            }
            ch.addClause(this.vi);
        }
        int v1 = 1;
        while (v1 <= this.sdSize.getLargeSide() - 1) {
            int v2 = v1 + 1;
            while (v2 <= this.sdSize.getLargeSide()) {
                this.vi.clear();
                this.vi.push(-this.variable(row, column, v1));
                this.vi.push(-this.variable(row, column, v2));
                ch.addClause(this.vi);
                ++v2;
            }
            ++v1;
        }
    }

    int numOfVariables() {
        int b = this.sdSize.getBase() + 1;
        switch (this.sdSize.getLargeSide()) {
            case 4: {
                return 444;
            }
            case 9: {
                return 999;
            }
        }
        return b * b * b;
    }

    void readPuzzleSolver(CellGrid cellGrid, ClauseHandler ch) {
        int r = 1;
        while (r <= this.sdSize.getLargeSide()) {
            int c = 1;
            while (c <= this.sdSize.getLargeSide()) {
                int v;
                if (cellGrid.getStatus(r, c) != CellStatus.SOLVER_ENTERED && (v = cellGrid.getIntValue(r, c)) > 0) {
                    this.setSquareSolver(r, c, v, ch);
                }
                ++c;
            }
            ++r;
        }
    }

    void addOneSquaresSolver(ClauseHandler ch) {
        int r = 1;
        while (r <= this.sdSize.getLargeSide()) {
            int c = 1;
            while (c <= this.sdSize.getLargeSide()) {
                this.addOneSquareSolver(r, c, ch);
                ++c;
            }
            ++r;
        }
    }

    int blockVariable(int br, int bc, int r, int c, int v) {
        return this.variable((br - 1) * this.sdSize.getSmallSide() + r, (bc - 1) * this.sdSize.getSmallSide() + c, v);
    }

    int blockVariable1(int br, int bv, int r, int c, int v) {
        return this.variable((br - 1) * this.sdSize.getSmallSide() + r, c, (bv - 1) * this.sdSize.getSmallSide() + v);
    }

    int blockVariable2(int bv, int bc, int r, int c, int v) {
        return this.variable(r, (bc - 1) * this.sdSize.getSmallSide() + c, (bv - 1) * this.sdSize.getSmallSide() + v);
    }

    void addOneBlockSolver(int br, int bc, ClauseHandler ch) {
        int v = 1;
        while (v <= this.sdSize.getLargeSide()) {
            this.vi.clear();
            if (this.gui.getUseExtra()) {
                this.vi1.clear();
                this.vi2.clear();
            }
            int r = 1;
            while (r <= this.sdSize.getSmallSide()) {
                int c = 1;
                while (c <= this.sdSize.getSmallSide()) {
                    this.vi.push(this.blockVariable(br, bc, r, c, v));
                    if (this.gui.getUseExtra()) {
                        this.vi1.push(this.blockVariable1(br, bc, r, v, c));
                        this.vi2.push(this.blockVariable2(br, bc, v, c, r));
                    }
                    ++c;
                }
                ++r;
            }
            ch.addClause(this.vi);
            if (this.gui.getUseExtra()) {
                ch.addClause(this.vi1);
                ch.addClause(this.vi2);
            }
            if (this.fullCNF) {
                int i1 = 1;
                while (i1 <= this.sdSize.getLargeSide() - 1) {
                    int i2 = i1 + 1;
                    while (i2 <= this.sdSize.getLargeSide()) {
                        int r1 = (i1 - 1) / this.sdSize.getSmallSide() + 1;
                        int c1 = (i1 - 1) % this.sdSize.getSmallSide() + 1;
                        int r2 = (i2 - 1) / this.sdSize.getSmallSide() + 1;
                        int c2 = (i2 - 1) % this.sdSize.getSmallSide() + 1;
                        this.vi.clear();
                        this.vi.push(-this.blockVariable(br, bc, r1, c1, v));
                        this.vi.push(-this.blockVariable(br, bc, r2, c2, v));
                        ch.addClause(this.vi);
                        if (this.gui.getUseExtra()) {
                            this.vi1.clear();
                            this.vi1.push(-this.blockVariable1(br, bc, r1, v, c1));
                            this.vi1.push(-this.blockVariable1(br, bc, r2, v, c2));
                            ch.addClause(this.vi1);
                            this.vi2.clear();
                            this.vi2.push(-this.blockVariable2(br, bc, v, c1, r1));
                            this.vi2.push(-this.blockVariable2(br, bc, v, c2, r2));
                            ch.addClause(this.vi2);
                        }
                        ++i2;
                    }
                    ++i1;
                }
            }
            ++v;
        }
    }

    void addOneRowSolver(int row, ClauseHandler ch) {
        int v = 1;
        while (v <= this.sdSize.getLargeSide()) {
            this.vi.clear();
            int c = 1;
            while (c <= this.sdSize.getLargeSide()) {
                this.vi.push(this.variable(row, c, v));
                ++c;
            }
            ch.addClause(this.vi);
            if (this.fullCNF) {
                int c1 = 1;
                while (c1 <= this.sdSize.getLargeSide() - 1) {
                    int c2 = c1 + 1;
                    while (c2 <= this.sdSize.getLargeSide()) {
                        this.vi.clear();
                        this.vi.push(-this.variable(row, c1, v));
                        this.vi.push(-this.variable(row, c2, v));
                        ch.addClause(this.vi);
                        ++c2;
                    }
                    ++c1;
                }
            }
            ++v;
        }
    }

    void addOneRowsSolver(ClauseHandler ch) {
        int r = 1;
        while (r <= this.sdSize.getLargeSide()) {
            this.addOneRowSolver(r, ch);
            ++r;
        }
    }

    void addOneColumnSolver(int column, ClauseHandler ch) {
        int v = 1;
        while (v <= this.sdSize.getLargeSide()) {
            this.vi.clear();
            int r = 1;
            while (r <= this.sdSize.getLargeSide()) {
                this.vi.push(this.variable(r, column, v));
                ++r;
            }
            ch.addClause(this.vi);
            if (this.fullCNF) {
                int r1 = 1;
                while (r1 <= this.sdSize.getLargeSide() - 1) {
                    int r2 = r1 + 1;
                    while (r2 <= this.sdSize.getLargeSide()) {
                        this.vi.clear();
                        this.vi.push(-this.variable(r1, column, v));
                        this.vi.push(-this.variable(r2, column, v));
                        ch.addClause(this.vi);
                        ++r2;
                    }
                    ++r1;
                }
            }
            ++v;
        }
    }

    void addFallingDiagonalSolver(ClauseHandler ch) {
        int v = 1;
        while (v <= this.sdSize.getLargeSide()) {
            this.vi.clear();
            int r = 1;
            while (r <= this.sdSize.getLargeSide()) {
                this.vi.push(this.variable(r, r, v));
                ++r;
            }
            ch.addClause(this.vi);
            if (this.fullCNF) {
                int r1 = 1;
                while (r1 <= this.sdSize.getLargeSide() - 1) {
                    int r2 = r1 + 1;
                    while (r2 <= this.sdSize.getLargeSide()) {
                        this.vi.clear();
                        this.vi.push(-this.variable(r1, r1, v));
                        this.vi.push(-this.variable(r2, r2, v));
                        ch.addClause(this.vi);
                        ++r2;
                    }
                    ++r1;
                }
            }
            ++v;
        }
    }

    void addRisingDiagonalSolver(ClauseHandler ch) {
        int v = 1;
        while (v <= this.sdSize.getLargeSide()) {
            this.vi.clear();
            int r = 1;
            while (r <= this.sdSize.getLargeSide()) {
                this.vi.push(this.variable(r, this.sdSize.getLargeSide() + 1 - r, v));
                ++r;
            }
            ch.addClause(this.vi);
            if (this.fullCNF) {
                int r1 = 1;
                while (r1 <= this.sdSize.getLargeSide() - 1) {
                    int r2 = r1 + 1;
                    while (r2 <= this.sdSize.getLargeSide()) {
                        this.vi.clear();
                        this.vi.push(-this.variable(r1, this.sdSize.getLargeSide() + 1 - r1, v));
                        this.vi.push(-this.variable(r2, this.sdSize.getLargeSide() + 1 - r2, v));
                        ch.addClause(this.vi);
                        ++r2;
                    }
                    ++r1;
                }
            }
            ++v;
        }
    }

    void addOneColumnsSolver(ClauseHandler ch) {
        int c = 1;
        while (c <= this.sdSize.getLargeSide()) {
            this.addOneColumnSolver(c, ch);
            ++c;
        }
    }

    void addOneBlocksSolver(ClauseHandler ch) {
        int r = 1;
        while (r <= this.sdSize.getSmallSide()) {
            int c = 1;
            while (c <= this.sdSize.getSmallSide()) {
                this.addOneBlockSolver(r, c, ch);
                ++c;
            }
            ++r;
        }
    }

    void setSquareSolver(int r, int c, int v, ClauseHandler ch) {
        this.vi.clear();
        this.vi.push(this.variable(r, c, v));
        ch.addClause(this.vi);
    }

    void addSuDokuRules(ClauseHandler ch) {
        this.addOneSquaresSolver(ch);
        this.addOneBlocksSolver(ch);
        this.addOneRowsSolver(ch);
        this.addOneColumnsSolver(ch);
        if (this.gui.getUseXSudoku()) {
            this.addFallingDiagonalSolver(ch);
            this.addRisingDiagonalSolver(ch);
        }
    }

    public SuDoku(MainProgramWindow mainProgramWindow, int maxSide, boolean createUniqueAllowed) {
        this.mainProgramWindow = mainProgramWindow;
        this.createUniqueAllowed = createUniqueAllowed;
        this.suDokuResources = new SuDokuResources();
        this.sdSize = new SDSize();
        this.gui = new GUIInput(mainProgramWindow, this.sdSize, this, maxSide);
        this.solver = SolverFactory.newMiniLearning(20);
        this.randomCellChooser = new Random();
    }

    public GUIInput getGui() {
        return this.gui;
    }

    public boolean getCreateUniqueAllowed() {
        return this.createUniqueAllowed;
    }

    void checkSquares(CellGrid cellGrid) {
        int r = 1;
        while (r <= this.sdSize.getLargeSide() && this.passesCheck) {
            int c = 1;
            while (c <= this.sdSize.getLargeSide() && this.passesCheck) {
                int v = cellGrid.getIntValue(r, c);
                if (v < 1 || v > this.sdSize.getLargeSide()) {
                    this.completed = false;
                }
                ++c;
            }
            ++r;
        }
    }

    void checkBlock(CellGrid cellGrid, int[][] rowVal, int[][] colVal, int r, int c) {
        int i1 = 1;
        while (i1 <= this.sdSize.getLargeSide() - 1 && this.passesCheck) {
            int i2 = i1 + 1;
            while (i2 <= this.sdSize.getLargeSide() && this.passesCheck) {
                int r1 = (i1 - 1) / this.sdSize.getSmallSide() + 1;
                int c1 = (i1 - 1) % this.sdSize.getSmallSide() + 1;
                int r2 = (i2 - 1) / this.sdSize.getSmallSide() + 1;
                int c2 = (i2 - 1) % this.sdSize.getSmallSide() + 1;
                int r3 = r * this.sdSize.getSmallSide() + r1;
                int c3 = c * this.sdSize.getSmallSide() + c1;
                int r4 = r * this.sdSize.getSmallSide() + r2;
                int c4 = c * this.sdSize.getSmallSide() + c2;
                if (cellGrid.getIntValue(r3, c3) != 0 && cellGrid.getIntValue(r3, c3) == cellGrid.getIntValue(r4, c4)) {
                    cellGrid.highlight(r3, c3);
                    cellGrid.highlight(r4, c4);
                    this.passesCheck = false;
                    this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_BLOCK"));
                    break;
                }
                if (this.gui.getUseExtra()) {
                    if (rowVal[r3 - 1][c3 - 1] != 0 && rowVal[r3 - 1][c3 - 1] == rowVal[r4 - 1][c4 - 1]) {
                        cellGrid.highlight(r3, rowVal[r3 - 1][c3 - 1]);
                        cellGrid.highlight(r4, rowVal[r4 - 1][c4 - 1]);
                        this.passesCheck = false;
                        this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_RELATED_IN_COLUMN"));
                        break;
                    }
                    if (colVal[r3 - 1][c3 - 1] != 0 && colVal[r3 - 1][c3 - 1] == colVal[r4 - 1][c4 - 1]) {
                        cellGrid.highlight(colVal[r3 - 1][c3 - 1], c3);
                        cellGrid.highlight(colVal[r4 - 1][c4 - 1], c4);
                        this.passesCheck = false;
                        this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_RELATED_IN_ROW"));
                        break;
                    }
                }
                ++i2;
            }
            ++i1;
        }
    }

    void checkBlocks(CellGrid cellGrid) {
        int[][] rowVal = null;
        int[][] colVal = null;
        if (this.gui.getUseExtra()) {
            int j;
            rowVal = new int[this.sdSize.getLargeSide()][this.sdSize.getLargeSide()];
            colVal = new int[this.sdSize.getLargeSide()][this.sdSize.getLargeSide()];
            int i = 0;
            while (i < this.sdSize.getLargeSide()) {
                j = 0;
                while (j < this.sdSize.getLargeSide()) {
                    rowVal[i][j] = 0;
                    colVal[i][j] = 0;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.sdSize.getLargeSide()) {
                j = 0;
                while (j < this.sdSize.getLargeSide()) {
                    int v1 = cellGrid.getIntValue(i + 1, j + 1);
                    if (v1 > 0) {
                        rowVal[i][v1 - 1] = j + 1;
                        colVal[v1 - 1][j] = i + 1;
                    }
                    ++j;
                }
                ++i;
            }
        }
        int r = 0;
        while (r < this.sdSize.getSmallSide() && this.passesCheck) {
            int c = 0;
            while (c < this.sdSize.getSmallSide() && this.passesCheck) {
                this.checkBlock(cellGrid, rowVal, colVal, r, c);
                ++c;
            }
            ++r;
        }
    }

    void checkRow(CellGrid cellGrid, int r) {
        int c1 = 1;
        while (c1 < this.sdSize.getLargeSide() && this.passesCheck) {
            int c2 = c1 + 1;
            while (c2 <= this.sdSize.getLargeSide() && this.passesCheck) {
                if (cellGrid.getIntValue(r, c1) != 0 && cellGrid.getIntValue(r, c1) == cellGrid.getIntValue(r, c2)) {
                    cellGrid.highlight(r, c1);
                    cellGrid.highlight(r, c2);
                    this.passesCheck = false;
                    this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_ROW"));
                    break;
                }
                ++c2;
            }
            ++c1;
        }
    }

    void checkRows(CellGrid cellGrid) {
        int r = 1;
        while (r <= this.sdSize.getLargeSide() && this.passesCheck) {
            this.checkRow(cellGrid, r);
            ++r;
        }
    }

    void checkColumn(CellGrid cellGrid, int c) {
        int r1 = 1;
        while (r1 < this.sdSize.getLargeSide() && this.passesCheck) {
            int r2 = r1 + 1;
            while (r2 <= this.sdSize.getLargeSide() && this.passesCheck) {
                if (cellGrid.getIntValue(r1, c) != 0 && cellGrid.getIntValue(r1, c) == cellGrid.getIntValue(r2, c)) {
                    cellGrid.highlight(r1, c);
                    cellGrid.highlight(r2, c);
                    this.passesCheck = false;
                    this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_COLUMN"));
                    break;
                }
                ++r2;
            }
            ++r1;
        }
    }

    void checkFallingDiagonal(CellGrid cellGrid) {
        int r1 = 1;
        while (r1 < this.sdSize.getLargeSide() && this.passesCheck) {
            int r2 = r1 + 1;
            while (r2 <= this.sdSize.getLargeSide() && this.passesCheck) {
                if (cellGrid.getIntValue(r1, r1) != 0 && cellGrid.getIntValue(r1, r1) == cellGrid.getIntValue(r2, r2)) {
                    cellGrid.highlight(r1, r1);
                    cellGrid.highlight(r2, r2);
                    this.passesCheck = false;
                    this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_FALLING_DIAGONAL"));
                    break;
                }
                ++r2;
            }
            ++r1;
        }
    }

    void checkRisingDiagonal(CellGrid cellGrid) {
        int r1 = 1;
        while (r1 < this.sdSize.getLargeSide() && this.passesCheck) {
            int r2 = r1 + 1;
            while (r2 <= this.sdSize.getLargeSide() && this.passesCheck) {
                if (cellGrid.getIntValue(r1, this.sdSize.getLargeSide() + 1 - r1) != 0 && cellGrid.getIntValue(r1, this.sdSize.getLargeSide() + 1 - r1) == cellGrid.getIntValue(r2, this.sdSize.getLargeSide() + 1 - r2)) {
                    cellGrid.highlight(r1, this.sdSize.getLargeSide() + 1 - r1);
                    cellGrid.highlight(r2, this.sdSize.getLargeSide() + 1 - r2);
                    this.passesCheck = false;
                    this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_SAME_IN_RISING_DIAGONAL"));
                    break;
                }
                ++r2;
            }
            ++r1;
        }
    }

    void checkColumns(CellGrid cellGrid) {
        int c = 1;
        while (c <= this.sdSize.getLargeSide() && this.passesCheck) {
            this.checkColumn(cellGrid, c);
            ++c;
        }
    }

    public void checkSolution(CellGrid cellGrid) {
        this.passesCheck = true;
        this.completed = true;
        cellGrid.unHighlightAll();
        this.checkSquares(cellGrid);
        if (this.passesCheck) {
            this.checkBlocks(cellGrid);
        }
        if (this.passesCheck) {
            this.checkRows(cellGrid);
        }
        if (this.passesCheck) {
            this.checkColumns(cellGrid);
        }
        if (this.passesCheck && this.gui.getUseXSudoku()) {
            this.checkFallingDiagonal(cellGrid);
            this.checkRisingDiagonal(cellGrid);
        }
        if (this.passesCheck) {
            if (this.completed) {
                this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_CORRECT"));
            } else {
                this.gui.setResult(this.suDokuResources.getStringFromKey("MSG_NO_BROKEN_RULES"));
            }
        }
    }

    public void graphicalSolveOneCell(CellGrid cellGrid, int row, int column) throws Exception {
        boolean showModel = false;
        System.gc();
        this.fullCNF = true;
        StringBuffer model = new StringBuffer("s SATISFIABLE\n");
        this.clauses = 0;
        this.solver = SolverFactory.newMiniLearning();
        Sat4jClauseHandler ch = new Sat4jClauseHandler(this.numOfVariables(), this.solver);
        this.addSuDokuRules(ch);
        this.readPuzzleSolver(cellGrid, ch);
        ch.finish();
        this.gui.setResult("");
        try {
            if (this.solver.isSatisfiable()) {
                int[] m = this.solver.model();
                int i = 0;
                while (i < m.length) {
                    if (showModel) {
                        model.append("v " + m[i] + "\n");
                    }
                    if (m[i] > 0 && m[i] % this.sdSize.getBase() != 0 && m[i] / this.sdSize.getBase2() == row && m[i] % this.sdSize.getBase2() / this.sdSize.getBase() == column) {
                        this.gui.getCellGrid().solverSetIntValue(m[i] / this.sdSize.getBase2(), m[i] % this.sdSize.getBase2() / this.sdSize.getBase(), m[i] % this.sdSize.getBase());
                    }
                    ++i;
                }
                if (showModel) {
                    model.append("v 0\n");
                    this.gui.setCNFModel(model.toString());
                }
            } else {
                this.gui.setResult("Cannot be solved");
                if (showModel) {
                    this.gui.setCNFModel("s UNSATISFIABLE");
                }
            }
        }
        catch (OutOfMemoryError e) {
            System.gc();
            this.gui.setResult("Increased Java Heap size required");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void randomCellHint(CellGrid cellGrid) {
        try {
            int freeCells = this.sdSize.getLargeSide() * this.sdSize.getLargeSide();
            int r = 1;
            while (r <= this.sdSize.getLargeSide()) {
                int c = 1;
                while (c <= this.sdSize.getLargeSide()) {
                    if (cellGrid.getIntValue(r, c) != 0) {
                        --freeCells;
                    }
                    ++c;
                }
                ++r;
            }
            int cell = this.randomCellChooser.nextInt(freeCells);
            int thisCell = -1;
            int thisRow = 1;
            int thisColumn = 1;
            int r2 = 1;
            while (r2 <= this.sdSize.getLargeSide() && thisCell < cell) {
                int c = 1;
                while (c <= this.sdSize.getLargeSide() && thisCell < cell) {
                    if (cellGrid.getIntValue(r2, c) == 0 && ++thisCell == cell) {
                        thisRow = r2;
                        thisColumn = c;
                    }
                    ++c;
                }
                ++r2;
            }
            this.graphicalSolveOneCell(cellGrid, thisRow, thisColumn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void graphicalSolve(CellGrid cellGrid, boolean showModel) throws Exception {
        System.gc();
        this.fullCNF = true;
        StringBuffer model = new StringBuffer("s SATISFIABLE\n");
        this.clauses = 0;
        this.solver = SolverFactory.newMiniLearning();
        Sat4jClauseHandler ch = new Sat4jClauseHandler(this.numOfVariables(), this.solver);
        this.addSuDokuRules(ch);
        this.readPuzzleSolver(cellGrid, ch);
        ch.finish();
        this.gui.setResult("");
        try {
            if (this.solver.isSatisfiable()) {
                int[] m = this.solver.model();
                int i = 0;
                while (i < m.length) {
                    if (showModel) {
                        model.append("v " + m[i] + "\n");
                    }
                    if (m[i] > 0 && m[i] % this.sdSize.getBase() != 0) {
                        this.gui.getCellGrid().solverSetIntValue(m[i] / this.sdSize.getBase2(), m[i] % this.sdSize.getBase2() / this.sdSize.getBase(), m[i] % this.sdSize.getBase());
                    }
                    ++i;
                }
                if (showModel) {
                    model.append("v 0\n");
                    this.gui.setCNFModel(model.toString());
                }
            } else {
                this.gui.setResult("Cannot be solved");
                if (showModel) {
                    this.gui.setCNFModel("s UNSATISFIABLE");
                }
            }
        }
        catch (OutOfMemoryError e) {
            System.gc();
            this.gui.setResult("Increased Java Heap size required");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void simplerCNF(CellGrid cellGrid) {
        System.gc();
        this.fullCNF = false;
        StringClauseHandler ch = new StringClauseHandler(this.numOfVariables());
        this.addSuDokuRules(ch);
        this.readPuzzleSolver(cellGrid, ch);
        ch.finish();
        this.gui.setCNFFile(ch.toString());
        this.gui.setResult("cnf available for solving");
    }

    public void fullCNF(CellGrid cellGrid) {
        System.gc();
        this.fullCNF = true;
        StringClauseHandler ch = new StringClauseHandler(this.numOfVariables());
        this.addSuDokuRules(ch);
        this.readPuzzleSolver(cellGrid, ch);
        ch.finish();
        this.gui.setCNFFile(ch.toString());
        this.gui.setResult("cnf available for solving");
    }

    public void parseLine(String line, CellGrid cellGrid) {
        if (line.length() > 0 && line.charAt(0) == 'v') {
            WordScanner wordScanner = new WordScanner(line);
            wordScanner.next();
            while (wordScanner.hasNext()) {
                String w = wordScanner.next();
                try {
                    int v1 = Integer.parseInt(w);
                    if (v1 <= 0 || v1 % this.sdSize.getBase() <= 0) continue;
                    cellGrid.solverSetIntValue(v1 / this.sdSize.getBase2(), v1 % this.sdSize.getBase2() / this.sdSize.getBase(), v1 % this.sdSize.getBase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            wordScanner.close();
        }
    }

    public void interpretModel(CellGrid cellGrid) {
        LineScanner lineScanner = new LineScanner(this.gui.getCNFModel());
        while (lineScanner.hasNext()) {
            this.parseLine(lineScanner.next(), cellGrid);
        }
        lineScanner.close();
    }

    public void createPuzzle(int filledCells, CellGrid cellGrid, boolean onlyCreateUnique) {
        System.gc();
        int[][] v = new int[this.sdSize.getLargeSide() + 1][this.sdSize.getLargeSide() + 1];
        int[][] testv = new int[this.sdSize.getLargeSide() + 1][this.sdSize.getLargeSide() + 1];
        cellGrid.clearAll();
        boolean success = false;
        this.fullCNF = true;
        ProgressMonitor progressbar = new ProgressMonitor(null, this.suDokuResources.getStringFromKey("MGS_PROGRESS_DIALOG"), "", 0, this.sdSize.getLargeSide() * this.sdSize.getLargeSide() / 2);
        progressbar.setProgress(0);
        while (!success) {
            ISolver csolver = SolverFactory.newMiniLearning2Heap();
            Sat4jClauseHandler ch = new Sat4jClauseHandler(this.numOfVariables(), csolver);
            this.addSuDokuRules(ch);
            CoordinateSet cs1 = new CoordinateSet(this.sdSize.getLargeSide(), this.sdSize.getLargeSide());
            int toAdd = this.sdSize.getLargeSide();
            int v1 = 1;
            while (v1 <= toAdd) {
                Coordinate coord = cs1.getCoordinate();
                this.vi.clear();
                this.vi.push(this.variable(coord.getRow(), coord.getColumn(), v1));
                ch.addClause(this.vi);
                ++v1;
            }
            ch.finish();
            try {
                if (!csolver.isSatisfiable()) continue;
                success = true;
                int[] m = csolver.model();
                int i = 0;
                while (i < m.length) {
                    if (m[i] > 0 && m[i] % this.sdSize.getBase() != 0) {
                        v[m[i] / this.sdSize.getBase2()][m[i] % this.sdSize.getBase2() / this.sdSize.getBase()] = m[i] % this.sdSize.getBase();
                    }
                    ++i;
                }
            }
            catch (OutOfMemoryError e) {
                this.gui.setResult("Increased Java Heap size required");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        CoordinateSet cs = new CoordinateSet(this.sdSize.getLargeSide(), this.sdSize.getLargeSide());
        RandomPermutation rp = this.gui.getUseExtra() ? new RandomPermutation(this.sdSize.getSmallSide(), this.sdSize.getSmallSide()) : new RandomPermutation(this.sdSize.getLargeSide());
        int r = 1;
        while (r <= this.sdSize.getLargeSide()) {
            int c = 1;
            while (c <= this.sdSize.getLargeSide()) {
                v[r][c] = rp.permute(v[r][c]);
                ++c;
            }
            ++r;
        }
        int requiredCells = filledCells;
        if (onlyCreateUnique) {
            requiredCells = 0;
            try {
                ISolver solver = SolverFactory.newBackjumping();
                Sat4jClauseHandler chp = new Sat4jClauseHandler(this.numOfVariables(), solver);
                this.addSuDokuRules(chp);
                this.vi.clear();
                int r2 = 1;
                while (r2 <= this.sdSize.getLargeSide()) {
                    int c = 1;
                    while (c <= this.sdSize.getLargeSide()) {
                        this.vi.push(-this.variable(r2, c, v[r2][c]));
                        ++c;
                    }
                    ++r2;
                }
                chp.addClause(this.vi);
                boolean finished = false;
                SortedCoordinateSet s = new SortedCoordinateSet(this.sdSize.getLargeSide(), this.sdSize.getLargeSide(), this.sdSize.getSmallSide(), v);
                int addedCount = 0;
                while (!finished) {
                    if (solver.isSatisfiable()) {
                        if (progressbar.isCanceled()) break;
                        progressbar.setProgress(addedCount + 1);
                        int[] m = solver.model();
                        int i = 0;
                        while (i < m.length) {
                            if (m[i] > 0) {
                                int val;
                                int r3 = m[i] / this.sdSize.getBase2();
                                int c = m[i] % this.sdSize.getBase2() / this.sdSize.getBase();
                                testv[r3][c] = val = m[i] % this.sdSize.getBase();
                            }
                            ++i;
                        }
                        boolean differenceFound = false;
                        Coordinate[] ccs = s.getAll();
                        int i2 = 0;
                        while (!differenceFound) {
                            int c;
                            Coordinate cc = ccs[i2];
                            int r4 = cc.getRow();
                            if (v[r4][c = cc.getColumn()] != testv[r4][c]) {
                                s.note(cc);
                                cellGrid.setIntValue(r4, c, v[r4][c]);
                                ++requiredCells;
                                differenceFound = true;
                                ++addedCount;
                                this.vi.clear();
                                this.vi.push(this.variable(r4, c, v[r4][c]));
                                try {
                                    chp.addClauseUnTrapped(this.vi);
                                }
                                catch (ContradictionException ce) {
                                    finished = true;
                                }
                            }
                            ++i2;
                        }
                        continue;
                    }
                    finished = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            int i = 0;
            while (i < requiredCells / 4) {
                Coordinate[] coords = cs.getGroup();
                int j = 0;
                while (j < 4) {
                    cellGrid.setIntValue(coords[j].getRow(), coords[j].getColumn(), v[coords[j].getRow()][coords[j].getColumn()]);
                    ++j;
                }
                ++i;
            }
            int j = 0;
            while (j < requiredCells % 4) {
                Coordinate c = cs.getCoordinate();
                cellGrid.setIntValue(c.getRow(), c.getColumn(), v[c.getRow()][c.getColumn()]);
                ++j;
            }
        }
        if (progressbar.isCanceled()) {
            cellGrid.clearAll();
        } else {
            this.gui.setFillCount(requiredCells);
            this.gui.setProtection(true);
        }
        progressbar.close();
    }

    static interface ClauseHandler {
        public void addClause(VecInt var1);

        public void finish();
    }

    static class Sat4jClauseHandler
    implements ClauseHandler {
        ISolver solver;

        Sat4jClauseHandler(int numOfVariables, ISolver solver) {
            this.solver = solver;
            solver.newVar(numOfVariables);
        }

        public void addClause(VecInt vi) {
            try {
                this.solver.addClause(vi);
            }
            catch (ContradictionException contradictionException) {
                // empty catch block
            }
        }

        public void addClauseUnTrapped(VecInt vi) throws ContradictionException {
            this.solver.addClause(vi);
        }

        public void finish() {
        }
    }

    static class StringClauseHandler
    implements ClauseHandler {
        StringBuffer buffer = new StringBuffer();
        String string;
        int clauses;
        int variables;

        StringClauseHandler(int variables) {
            this.variables = variables;
            this.clauses = 0;
        }

        public void addClause(VecInt vi) {
            int i = 0;
            while (i < vi.size()) {
                this.buffer.append(String.valueOf(vi.get(i)) + " ");
                ++i;
            }
            this.buffer.append("0\n");
            ++this.clauses;
        }

        public void finish() {
            this.string = "p cnf " + this.variables + " " + this.clauses + "\n" + this.buffer.toString();
        }

        public String toString() {
            return this.string;
        }
    }
}

