/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.apps.sudoku;

import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class SuDokuResources {
    boolean iconsLoaded = false;
    ImageIcon sat4jIcon;
    ImageIcon ecitIcon;
    ImageIcon crilIcon;
    ImageIcon objectWebIcon;
    ImageIcon scienceFestIcon;
    ResourceBundle resourceBundle;

    public SuDokuResources() {
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.sat4j.apps.sudoku.sudoku");
        }
        catch (Exception e) {
            System.out.println(" Exception in ResourceBundle.getBundle() ");
            e.printStackTrace();
            System.exit(0);
        }
        this.iconsLoaded = false;
    }

    public URL getURLFromKey(String key) {
        String filename = this.resourceBundle.getString(key);
        return this.getClass().getResource(filename);
    }

    public String getStringFromKey(String key) {
        return this.resourceBundle.getString(key);
    }

    public String getParsedProperty(String key) {
        String unParsed = System.getProperties().getProperty(key);
        if (unParsed == null) {
            return "";
        }
        return this.checkForEscapes(unParsed);
    }

    boolean isHex(char ch) {
        return '0' <= ch && ch <= '9' || 'A' <= ch && ch <= 'F' || 'a' <= ch && ch <= 'f';
    }

    int hexValue(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return 10 + ch - 65;
        }
        return 10 + ch - 97;
    }

    String checkForEscapes(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (++i >= s.length()) continue;
                char tag = s.charAt(i);
                switch (tag) {
                    case 'n': {
                        result.append('\n');
                        ++i;
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        ++i;
                        break;
                    }
                    case 'u': {
                        char unicode = '\u0000';
                        boolean stillOK = true;
                        ++i;
                        int j = 0;
                        while (stillOK && j < 4) {
                            stillOK = this.isHex(s.charAt(i + j));
                            if (stillOK) {
                                unicode = (char)(16 * unicode + this.hexValue(s.charAt(i + j)));
                            }
                            ++j;
                        }
                        result.append(unicode);
                        i += j;
                        break;
                    }
                    default: {
                        result.append(tag);
                        ++i;
                        break;
                    }
                }
                continue;
            }
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    ImageIcon getSat4jIcon() {
        this.ensureIcons();
        return this.sat4jIcon;
    }

    ImageIcon getECITIcon() {
        this.ensureIcons();
        return this.ecitIcon;
    }

    ImageIcon getCRILIcon() {
        this.ensureIcons();
        return this.crilIcon;
    }

    ImageIcon getObjectWebIcon() {
        this.ensureIcons();
        return this.objectWebIcon;
    }

    ImageIcon getScienceFestIcon() {
        this.ensureIcons();
        return this.scienceFestIcon;
    }

    void ensureIcons() {
        if (!this.iconsLoaded) {
            URL sat4jIconURL = this.getURLFromKey("ICON_SAT4J");
            this.sat4jIcon = new ImageIcon(sat4jIconURL);
            URL ECITIconURL = this.getURLFromKey("ICON_ECIT");
            this.ecitIcon = new ImageIcon(ECITIconURL);
            URL CRILIconURL = this.getURLFromKey("ICON_CRIL");
            this.crilIcon = new ImageIcon(CRILIconURL);
            URL objectWebIconURL = this.getURLFromKey("ICON_OBJECT_WEB");
            this.objectWebIcon = new ImageIcon(objectWebIconURL);
            URL scienceFestIconURL = this.getURLFromKey("ICON_SCIENCE_FEST");
            this.scienceFestIcon = new ImageIcon(scienceFestIconURL);
            this.iconsLoaded = true;
        }
    }
}

