/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.sat4j.specs.ISolver;

public abstract class ASolverFactory {
    public String[] solverNames() {
        ArrayList<String> l = new ArrayList<String>();
        Method[] solvers = this.getClass().getDeclaredMethods();
        int i = 0;
        while (i < solvers.length) {
            if (solvers[i].getParameterTypes().length == 0 && solvers[i].getName().startsWith("new")) {
                l.add(solvers[i].getName().substring(3));
            }
            ++i;
        }
        String[] names = new String[l.size()];
        l.toArray(names);
        return names;
    }

    public ISolver createSolverByName(String solvername) {
        Class[] paramtypes = new Class[]{};
        try {
            Method m = this.getClass().getMethod("new" + solvername, paramtypes);
            return (ISolver)m.invoke(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract ISolver defaultSolver();

    public abstract ISolver lightSolver();
}

