/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VecInt
implements Serializable,
IVecInt {
    private static final long serialVersionUID = 1L;
    private static final int RANDOM_SEED = 91648253;
    public static final IVecInt EMPTY = new VecInt(){
        private static final long serialVersionUID = 1L;

        public int size() {
            return 0;
        }

        public void shrink(int nofelems) {
        }

        public void shrinkTo(int newsize) {
        }

        public IVecInt pop() {
            throw new UnsupportedOperationException();
        }

        public void growTo(int newsize, int pad) {
        }

        public void ensure(int nsize) {
        }

        public IVecInt push(int elem) {
            throw new UnsupportedOperationException();
        }

        public void unsafePush(int elem) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
        }

        public int last() {
            throw new UnsupportedOperationException();
        }

        public int get(int i) {
            throw new UnsupportedOperationException();
        }

        public void set(int i, int o) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(int e) {
            return false;
        }

        public void copyTo(IVecInt copy) {
            throw new UnsupportedOperationException();
        }

        public void copyTo(int[] is) {
        }

        public void moveTo(IVecInt dest) {
        }

        public void moveTo2(IVecInt dest) {
        }

        public void moveTo(int[] dest) {
        }

        public void insertFirst(int elem) {
            throw new UnsupportedOperationException();
        }

        public void remove(int elem) {
            throw new UnsupportedOperationException();
        }

        public int delete(int i) {
            throw new UnsupportedOperationException();
        }

        public void sort() {
        }

        public void sortUnique() {
        }
    };
    private int nbelem;
    private int[] myarray;
    private static Random rand = new Random(91648253L);

    public VecInt() {
        this(5);
    }

    public VecInt(int size) {
        this.myarray = new int[size];
    }

    public VecInt(int[] lits) {
        this.myarray = lits;
        this.nbelem = lits.length;
    }

    public VecInt(int size, int pad) {
        this.myarray = new int[size];
        int i = 0;
        while (i < size) {
            this.myarray[i] = pad;
            ++i;
        }
        this.nbelem = size;
    }

    @Override
    public int size() {
        return this.nbelem;
    }

    @Override
    public void shrink(int nofelems) {
        assert (nofelems >= 0);
        assert (nofelems <= this.size());
        this.nbelem -= nofelems;
    }

    @Override
    public void shrinkTo(int newsize) {
        assert (newsize >= 0);
        assert (newsize < this.nbelem);
        this.nbelem = newsize;
    }

    @Override
    public IVecInt pop() {
        assert (this.size() != 0);
        --this.nbelem;
        return this;
    }

    @Override
    public void growTo(int newsize, int pad) {
        assert (newsize > this.size());
        this.ensure(newsize);
        while (--newsize >= 0) {
            this.myarray[this.nbelem++] = pad;
        }
    }

    @Override
    public void ensure(int nsize) {
        if (nsize >= this.myarray.length) {
            int[] narray = new int[Math.max(nsize, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, narray, 0, this.nbelem);
            this.myarray = narray;
        }
    }

    @Override
    public IVecInt push(int elem) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = elem;
        return this;
    }

    @Override
    public void unsafePush(int elem) {
        this.myarray[this.nbelem++] = elem;
    }

    @Override
    public void clear() {
        this.nbelem = 0;
    }

    @Override
    public int last() {
        assert (this.nbelem > 0);
        return this.myarray[this.nbelem - 1];
    }

    @Override
    public int get(int i) {
        assert (i >= 0 && i < this.nbelem);
        return this.myarray[i];
    }

    @Override
    public int unsafeGet(int i) {
        return this.myarray[i];
    }

    @Override
    public void set(int i, int o) {
        assert (i >= 0 && i < this.nbelem);
        this.myarray[i] = o;
    }

    @Override
    public boolean contains(int e) {
        int[] workArray = this.myarray;
        int i = 0;
        while (i < this.nbelem) {
            if (workArray[i] == e) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void copyTo(IVecInt copy) {
        VecInt ncopy = (VecInt)copy;
        int nsize = this.nbelem + ncopy.nbelem;
        ncopy.ensure(nsize);
        System.arraycopy(this.myarray, 0, ncopy.myarray, ncopy.nbelem, this.nbelem);
        ncopy.nbelem = nsize;
    }

    @Override
    public void copyTo(int[] is) {
        assert (is.length >= this.nbelem);
        System.arraycopy(this.myarray, 0, is, 0, this.nbelem);
    }

    @Override
    public void moveTo(IVecInt dest) {
        this.copyTo(dest);
        this.nbelem = 0;
    }

    @Override
    public void moveTo2(IVecInt dest) {
        VecInt ndest = (VecInt)dest;
        int s = ndest.nbelem;
        int[] tmp = ndest.myarray;
        ndest.myarray = this.myarray;
        ndest.nbelem = this.nbelem;
        this.myarray = tmp;
        this.nbelem = s;
        this.nbelem = 0;
    }

    @Override
    public void moveTo(int dest, int source) {
        this.myarray[dest] = this.myarray[source];
    }

    @Override
    public void moveTo(int[] dest) {
        System.arraycopy(this.myarray, 0, dest, 0, this.nbelem);
        this.nbelem = 0;
    }

    @Override
    public void insertFirst(int elem) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = elem;
            return;
        }
        this.push(elem);
    }

    @Override
    public void remove(int elem) {
        assert (this.size() > 0);
        int j = 0;
        while (this.myarray[j] != elem) {
            assert (j < this.size());
            ++j;
        }
        while (j < this.size() - 1) {
            this.myarray[j] = this.myarray[j + 1];
            ++j;
        }
        this.pop();
    }

    @Override
    public int delete(int i) {
        assert (i >= 0 && i < this.nbelem);
        int ith = this.myarray[i];
        this.myarray[i] = this.myarray[--this.nbelem];
        return ith;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.nbelem - 1) {
            stb.append(this.myarray[i]);
            stb.append(",");
            ++i;
        }
        if (this.nbelem > 0) {
            stb.append(this.myarray[this.nbelem - 1]);
        }
        return stb.toString();
    }

    void selectionSort(int from, int to) {
        int i = from;
        while (i < to - 1) {
            int best_i = i;
            int j = i + 1;
            while (j < to) {
                if (this.myarray[j] < this.myarray[best_i]) {
                    best_i = j;
                }
                ++j;
            }
            int tmp = this.myarray[i];
            this.myarray[i] = this.myarray[best_i];
            this.myarray[best_i] = tmp;
            ++i;
        }
    }

    void sort(int from, int to) {
        int width = to - from;
        if (to - from <= 15) {
            this.selectionSort(from, to);
        } else {
            int pivot = this.myarray[rand.nextInt(width) + from];
            int i = from - 1;
            int j = to;
            while (true) {
                if (this.myarray[++i] < pivot) {
                    continue;
                }
                while (pivot < this.myarray[--j]) {
                }
                if (i >= j) break;
                int tmp = this.myarray[i];
                this.myarray[i] = this.myarray[j];
                this.myarray[j] = tmp;
            }
            this.sort(from, i);
            this.sort(i, to);
        }
    }

    @Override
    public void sort() {
        this.sort(0, this.nbelem);
    }

    @Override
    public void sortUnique() {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem);
        int i = 1;
        int last = this.myarray[0];
        int j = 1;
        while (j < this.nbelem) {
            if (last < this.myarray[j]) {
                last = this.myarray[i] = this.myarray[j];
                ++i;
            }
            ++j;
        }
        this.nbelem = i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IVecInt) {
            IVecInt v = (IVecInt)obj;
            if (v.size() != this.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (v.get(i) != this.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long sum = 0L;
        int i = 0;
        while (i < this.nbelem) {
            sum += (long)this.myarray[i];
            ++i;
        }
        return (int)sum / this.nbelem;
    }

    public void pushAll(IVecInt vec) {
        VecInt nvec = (VecInt)vec;
        int nsize = this.nbelem + nvec.nbelem;
        this.ensure(nsize);
        System.arraycopy(nvec.myarray, 0, this.myarray, this.nbelem, nvec.nbelem);
        this.nbelem = nsize;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isSubsetOf(IVecInt vec) {
        isSubSet = this.size() <= vec.size();
        i = 0;
        j = 0;
        ** GOTO lbl10
        {
            ++j;
            do {
                if (j < vec.size() && vec.get(j) < this.get(i)) continue block0;
                isSubSet = j < vec.size() ? this.get(i) == vec.get(j) : false;
                ++i;
lbl10:
                // 2 sources

            } while (isSubSet && i < this.size() && j < vec.size());
        }
        return isSubSet;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < VecInt.this.nbelem;
            }

            @Override
            public Integer next() {
                if (this.i == VecInt.this.nbelem) {
                    throw new NoSuchElementException();
                }
                return VecInt.this.myarray[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.nbelem == 0;
    }
}

