/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat;

import java.io.Serializable;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.constraints.CardinalityDataStructure;
import org.sat4j.minisat.constraints.ClausalDataStructureCB;
import org.sat4j.minisat.constraints.ClausalDataStructureCBWL;
import org.sat4j.minisat.constraints.MixedDataStructureDaniel;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinary;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinaryAndTernary;
import org.sat4j.minisat.constraints.PBMaxCBClauseCardConstrDataStructure;
import org.sat4j.minisat.constraints.PBMaxClauseAtLeastConstrDataStructure;
import org.sat4j.minisat.constraints.PBMaxClauseCardConstrDataStructure;
import org.sat4j.minisat.constraints.PBMaxDataStructure;
import org.sat4j.minisat.constraints.PBMinClauseCardConstrDataStructure;
import org.sat4j.minisat.constraints.PBMinDataStructure;
import org.sat4j.minisat.constraints.PuebloPBMinClauseAtLeastConstrDataStructure;
import org.sat4j.minisat.constraints.PuebloPBMinClauseCardConstrDataStructure;
import org.sat4j.minisat.constraints.PuebloPBMinDataStructure;
import org.sat4j.minisat.constraints.pb.PBSolver;
import org.sat4j.minisat.constraints.pb.PBSolverArrayIncrementEtParcours;
import org.sat4j.minisat.constraints.pb.PBSolverArrayIncremental;
import org.sat4j.minisat.constraints.pb.PBSolverArrayInitial;
import org.sat4j.minisat.constraints.pb.PBSolverCard;
import org.sat4j.minisat.constraints.pb.PBSolverClause;
import org.sat4j.minisat.constraints.pb.PBSolverMapIncrementEtParcours;
import org.sat4j.minisat.constraints.pb.PBSolverMapInitial;
import org.sat4j.minisat.constraints.pb.PBSolverWithImpliedClause;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.ActiveLearning;
import org.sat4j.minisat.learning.FixedLengthLearning;
import org.sat4j.minisat.learning.LimitedLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;
import org.sat4j.minisat.orders.JWOrder;
import org.sat4j.minisat.orders.MyOrder;
import org.sat4j.minisat.orders.PureOrder;
import org.sat4j.minisat.orders.VarOrder;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.orders.VarOrderHeapObjective;
import org.sat4j.minisat.uip.DecisionUIP;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DimacsOutputSolver;

public class SolverFactory
extends ASolverFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public static ISolver newMiniLearning() {
        return SolverFactory.newMiniLearning(10);
    }

    public static ISolver newMiniLearningHeap() {
        return SolverFactory.newMiniLearningHeap(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniLearningHeapEZSimp() {
        Solver solver = (Solver)SolverFactory.newMiniLearningHeap();
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearningHeapExpSimp() {
        Solver solver = (Solver)SolverFactory.newMiniLearningHeap();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearning(int n) {
        return SolverFactory.newMiniLearning((DataStructureFactory)new MixedDataStructureDaniel(), n);
    }

    public static ISolver newMiniLearning(DataStructureFactory dsf) {
        return SolverFactory.newMiniLearning(dsf, 10);
    }

    public static ISolver newMiniLearningHeap(DataStructureFactory dsf) {
        return SolverFactory.newMiniLearning(dsf, new VarOrderHeap());
    }

    public static ISolver newMiniLearning2() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniLearning2Heap() {
        return SolverFactory.newMiniLearningHeap(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniLearning23() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniLearningCB() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCB());
    }

    public static ISolver newMiniLearningCBWL() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCBWL());
    }

    public static ISolver newMiniLearning2NewOrder() {
        return SolverFactory.newMiniLearning((DataStructureFactory)new MixedDataStructureWithBinary(), new MyOrder());
    }

    public static ISolver newMiniLearningPure() {
        return SolverFactory.newMiniLearning((DataStructureFactory)new MixedDataStructureDaniel(), new PureOrder());
    }

    public static ISolver newMiniLearningCBWLPure() {
        return SolverFactory.newMiniLearning((DataStructureFactory)new ClausalDataStructureCBWL(), new PureOrder());
    }

    public static ISolver newMiniLearning(DataStructureFactory dsf, int n) {
        LimitedLearning learning = new LimitedLearning(n);
        Solver solver = new Solver(new FirstUIP(), learning, dsf, new VarOrder());
        learning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniLearning(DataStructureFactory dsf, IOrder order) {
        LimitedLearning learning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), learning, dsf, order);
        learning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniLearningEZSimp() {
        return SolverFactory.newMiniLearningEZSimp(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniLearningEZSimp(DataStructureFactory dsf) {
        LimitedLearning learning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), learning, dsf, new VarOrder());
        learning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearningHeapEZSimpNoRestarts() {
        LimitedLearning learning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), learning, new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE), new VarOrderHeap());
        learning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearningHeapEZSimpLongRestarts() {
        LimitedLearning learning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), learning, new MixedDataStructureDaniel(), new SearchParams(1000), new VarOrderHeap());
        learning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newActiveLearning() {
        ActiveLearning learning = new ActiveLearning();
        Solver s = new Solver(new FirstUIP(), learning, new MixedDataStructureDaniel(), new VarOrder());
        learning.setOrder(s.getOrder());
        learning.setSolver(s);
        return s;
    }

    public static ISolver newMiniSAT() {
        return SolverFactory.newMiniSAT(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniSATNoRestarts() {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), learning, new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE), new VarOrder());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniSAT2() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniSAT23() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniSAT(DataStructureFactory dsf) {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), learning, dsf, new VarOrder());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniSATHeap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniSATHeapEZSimp() {
        Solver solver = (Solver)SolverFactory.newMiniSATHeap();
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniSATHeapExpSimp() {
        Solver solver = (Solver)SolverFactory.newMiniSATHeap();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniSAT2Heap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniSAT23Heap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniSATHeap(DataStructureFactory dsf) {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), learning, dsf, new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniCard() {
        return SolverFactory.newMiniSAT(new CardinalityDataStructure());
    }

    public static ISolver newMinimalOPBMax() {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), learning, new PBMaxDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBMax() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PBMaxDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseCardConstrMax() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseCardConstrMaxSpecificOrder() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniLearningOPBClauseCardConstrMaxSpecificOrder() {
        NoLearningButHeuristics learning = new NoLearningButHeuristics();
        PBSolverMapInitial solver = new PBSolverMapInitial(new FirstUIP(), learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniLearningOPBClauseCardConstrMaxSpecificOrderIncremental() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMinimalOPBClauseCardConstrMaxSpecificOrder() {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseCardConstrMaxReduceToClause() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverClause solver = new PBSolverClause(new FirstUIP(), learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseCardConstrMaxReduceToCard() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCard solver = new PBSolverCard(new FirstUIP(), learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseCardConstrMaxImplied() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverWithImpliedClause solver = new PBSolverWithImpliedClause(new FirstUIP(), learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseAtLeastConstrMax() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PBMaxClauseAtLeastConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseAtLeastConstrMaxMapIP() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverMapIncrementEtParcours solver = new PBSolverMapIncrementEtParcours(new FirstUIP(), learning, new PBMaxClauseAtLeastConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseAtLeastConstrMaxMapInit() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverMapInitial solver = new PBSolverMapInitial(new FirstUIP(), learning, new PBMaxClauseAtLeastConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseAtLeastConstrMaxArray() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverArrayIncremental solver = new PBSolverArrayIncremental(new FirstUIP(), learning, new PBMaxClauseAtLeastConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseAtLeastConstrMaxArrayIP() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverArrayIncrementEtParcours solver = new PBSolverArrayIncrementEtParcours(new FirstUIP(), learning, new PBMaxClauseAtLeastConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseAtLeastConstrMaxArrayInit() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverArrayInitial solver = new PBSolverArrayInitial(new FirstUIP(), learning, new PBMaxClauseAtLeastConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBCounterBasedClauseCardConstrMax() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PBMaxCBClauseCardConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMinimalOPBMin() {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), learning, new PBMinDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBMin() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PBMinDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMinimalOPBMinPueblo() {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), learning, new PuebloPBMinDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBMinPueblo() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PuebloPBMinDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseCardMinPueblo() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PuebloPBMinClauseCardConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseCardMin() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PBMinClauseCardConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseAtLeastMinPueblo() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolver solver = new PBSolver(new FirstUIP(), learning, new PuebloPBMinClauseAtLeastConstrDataStructure(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newRelsat() {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver(new DecisionUIP(), learning, new MixedDataStructureDaniel(), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newBackjumping() {
        NoLearningButHeuristics learning = new NoLearningButHeuristics();
        Solver solver = new Solver(new FirstUIP(), learning, new MixedDataStructureDaniel(), new VarOrderHeap());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMini3SAT() {
        FixedLengthLearning learning = new FixedLengthLearning(3);
        Solver solver = new Solver(new FirstUIP(), learning, new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE), new VarOrderHeap());
        learning.setSolver(solver);
        solver.setOrder(new JWOrder());
        return solver;
    }

    public static ISolver newMini3SATb() {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), learning, new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE), new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        solver.setOrder(new JWOrder());
        return solver;
    }

    public static ISolver newDefault() {
        return SolverFactory.newMiniLearningHeapExpSimp();
    }

    public ISolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static ISolver newLight() {
        return SolverFactory.newMini3SAT();
    }

    public ISolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static ISolver newDimacsOutput() {
        return new DimacsOutputSolver();
    }
}

