/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.card.AtLeast;
import org.sat4j.minisat.core.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCardinalityDataStructure
extends AbstractDataStructureFactory {
    @Override
    public Constr createPseudoBooleanConstraint(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        BigInteger diff = this.reduceToCard(coefs, literals);
        degree = degree.add(diff);
        assert (AbstractCardinalityDataStructure.coefficientsEqualToOne(coefs));
        if (moreThan) {
            return AtLeast.atLeastNew(this.solver, this.getVocabulary(), literals, degree.intValue());
        }
        int i = 0;
        while (i < literals.size()) {
            literals.set(i, literals.get(i) ^ 1);
            ++i;
        }
        return AtLeast.atLeastNew(this.solver, this.getVocabulary(), literals, coefs.size() - degree.intValue());
    }

    public static boolean coefficientsEqualToOne(IVec<BigInteger> v) {
        int i = 0;
        while (i < v.size()) {
            if (!v.get(i).equals(BigInteger.ONE)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private BigInteger reduceToCard(IVec<BigInteger> coefs, IVecInt literals) {
        int diff = 0;
        int i = 0;
        while (i < coefs.size()) {
            assert (coefs.get(i).abs().equals(BigInteger.ONE));
            if (coefs.get(i).signum() < 0) {
                assert (coefs.get(i).equals(BigInteger.ONE.negate()));
                ++diff;
                literals.set(i, literals.get(i) ^ 1);
                coefs.set(i, BigInteger.ONE);
            }
            ++i;
        }
        return BigInteger.valueOf(diff);
    }
}

