/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.AbstractPBDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPBClauseCardConstrDataStructure
extends AbstractPBDataStructureFactory {
    private static final BigInteger MAX_INT_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);

    @Override
    protected PBConstr constraintFactory(IVecInt literals, IVecInt coefs, boolean moreThan, int degree) throws ContradictionException {
        return this.constraintFactory(literals, WatchPb.toVecBigInt(coefs), moreThan, WatchPb.toBigInt(degree));
    }

    @Override
    protected PBConstr constraintFactory(IVecInt literals, IVecInt coefs, int degree) {
        return this.constraintFactory(literals, WatchPb.toVecBigInt(coefs), WatchPb.toBigInt(degree));
    }

    @Override
    protected PBConstr constraintFactory(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        IDataStructurePB mpb = WatchPb.niceParameters(literals, coefs, moreThan, degree, this.getVocabulary());
        if (mpb == null) {
            return null;
        }
        int size = mpb.size();
        int[] lits = new int[size];
        BigInteger[] normCoefs = new BigInteger[size];
        mpb.buildConstraintFromMapPb(lits, normCoefs);
        if (mpb.getDegree().equals(BigInteger.ONE)) {
            IVecInt v = WLClause.sanityCheck(new VecInt(lits), this.getVocabulary(), this.solver);
            if (v == null) {
                return null;
            }
            return this.constructClause(v);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(new Vec<BigInteger>(normCoefs))) {
            assert (mpb.getDegree().compareTo(MAX_INT_VALUE) < 0);
            return this.constructCard(new VecInt(lits), mpb.getDegree().intValue());
        }
        return this.constructPB(mpb);
    }

    @Override
    protected PBConstr constraintFactory(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        if (degree.equals(BigInteger.ONE)) {
            return this.constructLearntClause(literals);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(coefs)) {
            return this.constructLearntCard(literals, degree.intValue());
        }
        return this.constructLearntPB(literals, coefs, degree);
    }

    private static boolean coefficientsEqualToOne(IVec<BigInteger> coeffs) {
        int i = 0;
        while (i < coeffs.size()) {
            if (!coeffs.get(i).equals(BigInteger.ONE)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract PBConstr constructClause(IVecInt var1);

    protected abstract PBConstr constructCard(IVecInt var1, int var2) throws ContradictionException;

    protected abstract PBConstr constructPB(IDataStructurePB var1) throws ContradictionException;

    protected abstract PBConstr constructLearntClause(IVecInt var1);

    protected abstract PBConstr constructLearntCard(IVecInt var1, int var2);

    protected abstract PBConstr constructLearntPB(IVecInt var1, IVec<BigInteger> var2, BigInteger var3);
}

