/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.LearntWLClause;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.constraints.pb.IInternalPBConstraintCreator;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.core.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPBDataStructureFactory
extends AbstractDataStructureFactory
implements IInternalPBConstraintCreator {
    @Override
    public Constr createClause(IVecInt literals) throws ContradictionException {
        IVecInt v = WLClause.sanityCheck(literals, this.getVocabulary(), this.solver);
        if (v == null) {
            return null;
        }
        VecInt coefs = new VecInt(v.size(), 1);
        return this.constraintFactory(v, coefs, true, 1);
    }

    @Override
    public Constr createUnregisteredClause(IVecInt literals) {
        return new LearntWLClause(literals, this.getVocabulary());
    }

    @Override
    public Constr createCardinalityConstraint(IVecInt literals, int degree) throws ContradictionException {
        VecInt coefs = new VecInt(literals.size(), 1);
        return this.constraintFactory(literals, coefs, true, degree);
    }

    @Override
    public Constr createPseudoBooleanConstraint(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        return this.constraintFactory(literals, coefs, moreThan, degree);
    }

    protected abstract PBConstr constraintFactory(IVecInt var1, IVecInt var2, boolean var3, int var4) throws ContradictionException;

    protected abstract PBConstr constraintFactory(IVecInt var1, IVec<BigInteger> var2, boolean var3, BigInteger var4) throws ContradictionException;

    @Override
    public Constr createUnregisteredPseudoBooleanConstraint(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        return this.constraintFactory(literals, coefs, degree);
    }

    public IConstr createUnregisteredPseudoBooleanConstraint(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        return this.constraintFactory(literals, coefs, moreThan, degree);
    }

    protected abstract PBConstr constraintFactory(IVecInt var1, IVecInt var2, int var3);

    protected abstract PBConstr constraintFactory(IVecInt var1, IVec<BigInteger> var2, BigInteger var3);
}

