/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.card;

import java.io.Serializable;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public class AtLeast
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int maxUnsatisfied;
    private int counter;
    protected final int[] lits;
    protected final ILits voc;

    protected AtLeast(ILits voc, IVecInt ps, int degree) {
        this.maxUnsatisfied = ps.size() - degree;
        this.voc = voc;
        this.counter = 0;
        this.lits = new int[ps.size()];
        ps.moveTo(this.lits);
        int[] nArray = this.lits;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int q = nArray[n];
            voc.watch(q ^ 1, this);
            ++n;
        }
    }

    protected static int niceParameters(UnitPropagationListener s, ILits voc, IVecInt ps, int deg) throws ContradictionException {
        if (ps.size() < deg) {
            throw new ContradictionException();
        }
        int degree = deg;
        int i = 0;
        while (i < ps.size()) {
            if (voc.isUnassigned(ps.get(i))) {
                ++i;
                continue;
            }
            if (voc.isSatisfied(ps.get(i))) {
                --degree;
            }
            ps.delete(i);
        }
        ps.sortUnique();
        if (ps.size() == degree) {
            i = 0;
            while (i < ps.size()) {
                if (!s.enqueue(ps.get(i))) {
                    throw new ContradictionException();
                }
                ++i;
            }
            return 0;
        }
        if (ps.size() < degree) {
            throw new ContradictionException();
        }
        return degree;
    }

    public static AtLeast atLeastNew(UnitPropagationListener s, ILits voc, IVecInt ps, int n) throws ContradictionException {
        int degree = AtLeast.niceParameters(s, voc, ps, n);
        if (degree == 0) {
            return null;
        }
        return new AtLeast(voc, ps, degree);
    }

    public void remove() {
        int[] nArray = this.lits;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int q = nArray[n];
            this.voc.watches(q ^ 1).remove(this);
            ++n;
        }
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        this.voc.watch(p, this);
        if (this.counter == this.maxUnsatisfied) {
            return false;
        }
        ++this.counter;
        this.voc.undos(p).push(this);
        if (this.counter == this.maxUnsatisfied) {
            int[] nArray = this.lits;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int q = nArray[n];
                if (this.voc.isUnassigned(q) && !s.enqueue(q, this)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public boolean simplify() {
        return false;
    }

    public void undo(int p) {
        --this.counter;
    }

    public void calcReason(int p, IVecInt outReason) {
        int c = p == -1 ? -1 : 0;
        int[] nArray = this.lits;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int q = nArray[n];
            if (this.voc.isFalsified(q)) {
                outReason.push(q ^ 1);
                if (++c == this.maxUnsatisfied) {
                    return;
                }
            }
            ++n;
        }
    }

    public boolean learnt() {
        return false;
    }

    public double getActivity() {
        return 0.0;
    }

    public void incActivity(double claInc) {
    }

    public boolean locked() {
        return true;
    }

    public void setLearnt() {
        throw new UnsupportedOperationException();
    }

    public void register() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int i) {
        return this.lits[i];
    }

    public void rescaleBy(double d) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener s) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        stb.append("Card (" + this.lits.length + ") : ");
        int i = 0;
        while (i < this.lits.length) {
            stb.append(" + ");
            stb.append(Lits.toString(this.lits[i]));
            stb.append("[");
            stb.append(this.voc.valueToString(this.lits[i]));
            stb.append("@");
            stb.append(this.voc.getLevel(this.lits[i]));
            stb.append("]");
            stb.append(" ");
            stb.append(" ");
            ++i;
        }
        stb.append(">= ");
        stb.append(this.size() - this.maxUnsatisfied);
        return stb.toString();
    }
}

