/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.card;

import java.io.Serializable;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public class MinWatchCard
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean ATLEAST = true;
    public static final boolean ATMOST = false;
    protected int degree;
    private int[] lits;
    private boolean moreThan;
    protected int watchCumul;
    private final ILits voc;

    public MinWatchCard(ILits voc, IVecInt ps, boolean moreThan, int degree) {
        this.voc = voc;
        this.degree = degree;
        this.moreThan = moreThan;
        int[] index = new int[voc.nVars() * 2 + 2];
        int i = 0;
        while (i < index.length) {
            index[i] = 0;
            ++i;
        }
        i = 0;
        while (i < ps.size()) {
            if (index[ps.get(i) ^ 1] == 0) {
                int n = ps.get(i);
                index[n] = index[n] + 1;
            } else {
                int n = ps.get(i) ^ 1;
                index[n] = index[n] - 1;
            }
            ++i;
        }
        int ind = 0;
        while (ind < ps.size()) {
            if (index[ps.get(ind)] > 0) {
                int n = ps.get(ind);
                index[n] = index[n] - 1;
                ++ind;
                continue;
            }
            if ((ps.get(ind) & 1) != 0) {
                --this.degree;
            }
            ps.set(ind, ps.last());
            ps.pop();
        }
        this.lits = new int[ps.size()];
        ps.moveTo(this.lits);
        this.normalize();
    }

    protected MinWatchCard(ILits voc, IVecInt ps, int degree) {
        this.voc = voc;
        this.degree = degree;
        this.moreThan = true;
        this.lits = new int[ps.size()];
        ps.moveTo(this.lits);
    }

    public void calcReason(int p, IVecInt outReason) {
        int i = 0;
        while (i < this.lits.length) {
            if (this.voc.isFalsified(this.lits[i])) {
                outReason.push(this.lits[i] ^ 1);
            }
            ++i;
        }
    }

    public double getActivity() {
        return 0.0;
    }

    public void incActivity(double claInc) {
    }

    public boolean learnt() {
        return false;
    }

    protected static int linearisation(ILits voc, IVecInt ps) {
        int modif = 0;
        int i = 0;
        while (i < ps.size()) {
            if (voc.isUnassigned(ps.get(i))) {
                ++i;
                continue;
            }
            if (voc.isSatisfied(ps.get(i))) {
                --modif;
            }
            ps.set(i, ps.last());
            ps.pop();
        }
        assert (modif <= 0);
        return modif;
    }

    public boolean locked() {
        return true;
    }

    public static MinWatchCard minWatchCardNew(UnitPropagationListener s, ILits voc, IVecInt ps, boolean moreThan, int degree) throws ContradictionException {
        int mydegree = degree + MinWatchCard.linearisation(voc, ps);
        if (ps.size() == 0 && mydegree > 0) {
            throw new ContradictionException();
        }
        if (ps.size() == mydegree || ps.size() <= 0) {
            int i = 0;
            while (i < ps.size()) {
                if (!s.enqueue(ps.get(i))) {
                    throw new ContradictionException();
                }
                ++i;
            }
            return null;
        }
        MinWatchCard retour = new MinWatchCard(voc, ps, moreThan, mydegree);
        if (retour.degree <= 0) {
            return null;
        }
        retour.computeWatches();
        retour.computePropagation(s);
        return retour;
    }

    public final void normalize() {
        if (!this.moreThan) {
            this.degree = 0 - this.degree;
            int indLit = 0;
            while (indLit < this.lits.length) {
                this.lits[indLit] = this.lits[indLit] ^ 1;
                ++this.degree;
                ++indLit;
            }
            this.moreThan = true;
        }
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        if (this.watchCumul == this.degree) {
            this.voc.watch(p, this);
            return false;
        }
        int indFalsified = 0;
        while ((this.lits[indFalsified] ^ 1) != p) {
            ++indFalsified;
        }
        assert (this.watchCumul > this.degree);
        int indSwap = this.degree + 1;
        while (indSwap < this.lits.length && this.voc.isFalsified(this.lits[indSwap])) {
            ++indSwap;
        }
        if (indSwap == this.lits.length) {
            this.voc.watch(p, this);
            --this.watchCumul;
            assert (this.watchCumul == this.degree);
            this.voc.undos(p).push(this);
            int i = 0;
            while (i <= this.degree) {
                if (p != (this.lits[i] ^ 1) && !s.enqueue(this.lits[i], this)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int tmpInt = this.lits[indSwap];
        this.lits[indSwap] = this.lits[indFalsified];
        this.lits[indFalsified] = tmpInt;
        this.voc.watch(tmpInt ^ 1, this);
        return true;
    }

    public void remove() {
        int i = 0;
        while (i <= this.degree) {
            this.voc.watches(this.lits[i] ^ 1).remove(this);
            ++i;
        }
    }

    public void rescaleBy(double d) {
    }

    public boolean simplify() {
        int i = 0;
        int count = 0;
        while (i < this.lits.length) {
            if (this.voc.isSatisfied(this.lits[i]) && ++count == this.degree) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        stb.append("Card (" + this.lits.length + ") : ");
        if (this.lits.length > 0) {
            stb.append(Lits.toString(this.lits[0]));
            stb.append("[");
            stb.append(this.voc.valueToString(this.lits[0]));
            stb.append("@");
            stb.append(this.voc.getLevel(this.lits[0]));
            stb.append("]");
            stb.append(" ");
            int i = 1;
            while (i < this.lits.length) {
                stb.append(" + ");
                stb.append(Lits.toString(this.lits[i]));
                stb.append("[");
                stb.append(this.voc.valueToString(this.lits[i]));
                stb.append("@");
                stb.append(this.voc.getLevel(this.lits[i]));
                stb.append("]");
                stb.append(" ");
                ++i;
            }
            stb.append(">= ");
            stb.append(this.degree);
        }
        return stb.toString();
    }

    public void undo(int p) {
        ++this.watchCumul;
    }

    public void setLearnt() {
        throw new UnsupportedOperationException();
    }

    public void register() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int i) {
        return this.lits[i];
    }

    public void assertConstraint(UnitPropagationListener s) {
        throw new UnsupportedOperationException();
    }

    /*
     * Unable to fully structure code
     */
    protected void computeWatches() {
        indSwap = this.lits.length;
        i = 0;
        ** GOTO lbl13
        {
            tmpInt = this.lits[i];
            this.lits[i] = this.lits[indSwap];
            this.lits[indSwap] = tmpInt;
            do {
                if (this.voc.isFalsified(this.lits[i]) && --indSwap > i) continue block0;
                if (!this.voc.isFalsified(this.lits[i])) {
                    ++this.watchCumul;
                    this.voc.watch(this.lits[i] ^ 1, this);
                }
                ++i;
lbl13:
                // 2 sources

            } while (i <= this.degree && i < indSwap);
        }
        if (this.learnt()) {
            free = 1;
            while (this.watchCumul <= this.degree && free > 0) {
                free = 0;
                maxlevel = -1;
                maxi = -1;
                i = this.watchCumul;
                while (i < this.lits.length) {
                    if (this.voc.isFalsified(this.lits[i])) {
                        ++free;
                        level = this.voc.getLevel(this.lits[i]);
                        if (level > maxlevel) {
                            maxi = i;
                            maxlevel = level;
                        }
                    }
                    ++i;
                }
                if (free <= 0) continue;
                if (!MinWatchCard.$assertionsDisabled && maxi < 0) {
                    throw new AssertionError();
                }
                this.voc.watch(this.lits[maxi] ^ 1, this);
                tmpInt = this.lits[maxi];
                this.lits[maxi] = this.lits[this.watchCumul];
                this.lits[this.watchCumul] = tmpInt;
                ++this.watchCumul;
                if (!MinWatchCard.$assertionsDisabled && --free < 0) {
                    throw new AssertionError();
                }
            }
            if (!MinWatchCard.$assertionsDisabled && this.lits.length != 1 && this.watchCumul <= 1) {
                throw new AssertionError();
            }
        }
    }

    protected MinWatchCard computePropagation(UnitPropagationListener s) throws ContradictionException {
        if (this.watchCumul == this.degree) {
            int i = 0;
            while (i < this.lits.length) {
                if (!s.enqueue(this.lits[i])) {
                    throw new ContradictionException();
                }
                ++i;
            }
            return null;
        }
        if (this.watchCumul < this.degree) {
            throw new ContradictionException();
        }
        return this;
    }

    public int[] getLits() {
        int[] tmp = new int[this.size()];
        System.arraycopy(this.lits, 0, tmp, 0, this.size());
        return tmp;
    }

    public ILits getVocabulary() {
        return this.voc;
    }
}

