/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public class BinaryClauses
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ILits voc;
    private final IVecInt clauses = new VecInt();
    private final int reason;
    private int conflictindex = -1;

    public BinaryClauses(ILits voc, int p) {
        this.voc = voc;
        this.reason = p;
    }

    public void addBinaryClause(int p) {
        this.clauses.push(p);
    }

    public void remove() {
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        assert (this.voc.isFalsified(this.reason));
        this.voc.watch(p, this);
        int i = 0;
        while (i < this.clauses.size()) {
            int q = this.clauses.get(i);
            if (!s.enqueue(q, this)) {
                this.conflictindex = i;
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean simplify() {
        int i = 0;
        while (i < this.clauses.size()) {
            if (this.voc.isSatisfied(this.clauses.get(i))) {
                return true;
            }
            if (this.voc.isFalsified(this.clauses.get(i))) {
                this.clauses.delete(i);
            }
            ++i;
        }
        return false;
    }

    public void undo(int p) {
    }

    public void calcReason(int p, IVecInt outReason) {
        outReason.push(this.reason ^ 1);
        if (p == -1) {
            assert (this.conflictindex > -1);
            outReason.push(this.clauses.get(this.conflictindex) ^ 1);
        }
    }

    public boolean learnt() {
        return false;
    }

    public void incActivity(double claInc) {
    }

    public double getActivity() {
        return 0.0;
    }

    public boolean locked() {
        return false;
    }

    public void setLearnt() {
    }

    public void register() {
    }

    public void rescaleBy(double d) {
    }

    public int size() {
        return this.clauses.size();
    }

    public int get(int i) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener s) {
        throw new UnsupportedOperationException();
    }
}

