/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public class CBClause
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int falsified;
    private boolean learnt;
    protected final int[] lits;
    protected final ILits voc;
    private double activity;

    public static CBClause brandNewClause(UnitPropagationListener s, ILits voc, IVecInt literals) {
        CBClause c = new CBClause(literals, voc);
        c.register();
        return c;
    }

    public CBClause(IVecInt ps, ILits voc, boolean learnt) {
        this.learnt = learnt;
        this.lits = new int[ps.size()];
        this.voc = voc;
        ps.moveTo(this.lits);
    }

    public CBClause(IVecInt ps, ILits voc) {
        this(ps, voc, false);
    }

    public void remove() {
        int i = 0;
        while (i < this.lits.length) {
            this.voc.watches(this.lits[i] ^ 1).remove(this);
            ++i;
        }
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        this.voc.undos(p).push(this);
        ++this.falsified;
        assert (this.falsified != this.lits.length);
        if (this.falsified == this.lits.length - 1) {
            int i = 0;
            while (i < this.lits.length) {
                if (!this.voc.isFalsified(this.lits[i])) {
                    return s.enqueue(this.lits[i], this);
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public boolean simplify() {
        int[] nArray = this.lits;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int p = nArray[n];
            if (this.voc.isSatisfied(p)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void undo(int p) {
        --this.falsified;
    }

    public void calcReason(int p, IVecInt outReason) {
        assert (outReason.size() == 0);
        int[] nArray = this.lits;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int q = nArray[n];
            assert (this.voc.isFalsified(q) || q == p);
            if (this.voc.isFalsified(q)) {
                outReason.push(q ^ 1);
            }
            ++n;
        }
        assert (p == -1 || outReason.size() == this.lits.length - 1);
    }

    public boolean learnt() {
        return this.learnt;
    }

    public void incActivity(double claInc) {
        this.activity += claInc;
    }

    public double getActivity() {
        return this.activity;
    }

    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this;
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public void register() {
        int p;
        int[] nArray = this.lits;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            p = nArray[n];
            this.voc.watch(p ^ 1, this);
            ++n;
        }
        if (this.learnt) {
            nArray = this.lits;
            n = 0;
            n2 = nArray.length;
            while (n < n2) {
                p = nArray[n];
                if (this.voc.isFalsified(p)) {
                    this.voc.undos(p ^ 1).push(this);
                    ++this.falsified;
                }
                ++n;
            }
            assert (this.falsified == this.lits.length - 1);
        }
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int i) {
        return this.lits[i];
    }

    public void assertConstraint(UnitPropagationListener s) {
        assert (this.voc.isUnassigned(this.lits[0]));
        boolean ret = s.enqueue(this.lits[0], this);
        assert (ret);
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.lits.length) {
            stb.append(this.lits[i]);
            stb.append("[");
            stb.append(this.voc.valueToString(this.lits[i]));
            stb.append("]");
            stb.append(" ");
            ++i;
        }
        return stb.toString();
    }
}

