/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public class TernaryClauses
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IVecInt stubs = new VecInt();
    private final ILits voc;
    private final int phead;

    public TernaryClauses(ILits voc, int p) {
        this.voc = voc;
        this.phead = p;
    }

    public void addTernaryClause(int a, int b) {
        this.stubs.push(a);
        this.stubs.push(b);
    }

    public void remove() {
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        assert (this.voc.isSatisfied(p));
        assert (this.voc.isFalsified(this.phead));
        this.voc.watch(p, this);
        int i = 0;
        while (i < this.stubs.size()) {
            int a = this.stubs.get(i);
            int b = this.stubs.get(i + 1);
            if (!this.voc.isSatisfied(a) && !this.voc.isSatisfied(b)) {
                if (this.voc.isFalsified(a) && !s.enqueue(b, this)) {
                    return false;
                }
                if (this.voc.isFalsified(b) && !s.enqueue(a, this)) {
                    return false;
                }
            }
            i += 2;
        }
        return true;
    }

    public boolean simplify() {
        return false;
    }

    public void undo(int p) {
    }

    public void calcReason(int p, IVecInt outReason) {
        assert (this.voc.isFalsified(this.phead));
        if (p == -1) {
            int i = 0;
            while (!this.voc.isFalsified(this.stubs.get(i)) || !this.voc.isFalsified(this.stubs.get(i + 1))) {
                i += 2;
            }
            outReason.push(this.phead ^ 1);
            outReason.push(this.stubs.get(i) ^ 1);
            outReason.push(this.stubs.get(i + 1) ^ 1);
        } else {
            outReason.push(this.phead ^ 1);
            int i = 0;
            while (this.stubs.get(i) != p || !this.voc.isFalsified(this.stubs.get(i ^ 1))) {
                ++i;
            }
            assert (!this.voc.isFalsified(this.stubs.get(i)));
            outReason.push(this.stubs.get(i ^ 1) ^ 1);
            assert (this.voc.isFalsified(this.stubs.get(i ^ 1)));
        }
    }

    public boolean learnt() {
        return false;
    }

    public void incActivity(double claInc) {
    }

    public double getActivity() {
        return 0.0;
    }

    public boolean locked() {
        return false;
    }

    public void setLearnt() {
    }

    public void register() {
    }

    public void rescaleBy(double d) {
    }

    public int size() {
        return this.stubs.size();
    }

    public int get(int i) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener s) {
        throw new UnsupportedOperationException();
    }
}

