/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayPbInitial
implements IDataStructurePB {
    protected final ILits voc;
    protected BigInteger[] coefs;
    protected BigInteger degree;
    protected SortedMap<Integer, List<Integer>> byLevel = new TreeMap<Integer, List<Integer>>();

    ArrayPbInitial(int[] lits, BigInteger[] coefLits, BigInteger degree, ILits voc, int level) {
        this.coefs = new BigInteger[2 * voc.nVars() + 2];
        int i = 0;
        while (i < lits.length) {
            this.coefs[lits[i]] = coefLits[i];
            ++i;
        }
        this.degree = degree;
        this.voc = voc;
    }

    ArrayPbInitial(ILits voc) {
        this.coefs = new BigInteger[2 * voc.nVars() + 2];
        this.degree = BigInteger.ZERO;
        this.voc = voc;
    }

    @Override
    public BigInteger saturation() {
        assert (this.degree.signum() > 0);
        BigInteger minimum = this.degree;
        int i = 2;
        while (i < this.coefs.length) {
            if (this.coefs[i] != null) {
                assert (this.coefs[i].signum() > 0);
                if (this.degree.compareTo(this.coefs[i]) < 0) {
                    this.setCoef(i, this.degree);
                }
                assert (this.coefs[i].signum() > 0);
                minimum = minimum.min(this.coefs[i]);
            }
            ++i;
        }
        if (minimum.equals(this.degree) && minimum.compareTo(BigInteger.ONE) > 0) {
            this.degree = BigInteger.ONE;
            i = 2;
            while (i < this.coefs.length) {
                if (this.coefs[i] != null) {
                    this.setCoef(i, BigInteger.ONE);
                }
                ++i;
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(PBConstr cpb, BigInteger deg, BigInteger[] reducedCoefs, VarActivityListener val) {
        return this.cuttingPlane(cpb, deg, reducedCoefs, BigInteger.ONE, val);
    }

    @Override
    public BigInteger cuttingPlane(PBConstr cpb, BigInteger degreeCons, BigInteger[] reducedCoefs, BigInteger coefMult, VarActivityListener val) {
        this.degree = this.degree.add(degreeCons);
        assert (this.degree.signum() > 0);
        if (reducedCoefs == null) {
            int i = 0;
            while (i < cpb.size()) {
                this.cuttingPlane(cpb.get(i), this.multiplyCoefficient(cpb.getCoef(i), coefMult));
                ++i;
            }
        } else {
            int i = 0;
            while (i < cpb.size()) {
                this.cuttingPlane(cpb.get(i), this.multiplyCoefficient(reducedCoefs[i], coefMult));
                ++i;
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(int[] lits, BigInteger[] reducedCoefs, BigInteger deg) {
        return this.cuttingPlane(lits, reducedCoefs, deg, BigInteger.ONE);
    }

    @Override
    public BigInteger cuttingPlane(int[] lits, BigInteger[] reducedCoefs, BigInteger degreeCons, BigInteger coefMult) {
        this.degree = this.degree.add(degreeCons);
        assert (this.degree.signum() > 0);
        int i = 0;
        while (i < lits.length) {
            this.cuttingPlane(lits[i], reducedCoefs[i].multiply(coefMult));
            ++i;
        }
        return this.degree;
    }

    private void cuttingPlane(int lit, BigInteger coef) {
        assert (coef.signum() >= 0);
        if (coef.signum() > 0) {
            if (this.coefs[lit ^ 1] == null) {
                assert (this.coefs[lit] == null || this.coefs[lit].signum() > 0);
                if (this.coefs[lit] == null) {
                    this.setCoef(lit, coef);
                } else {
                    this.increaseCoef(lit, coef);
                }
                assert (this.coefs[lit].signum() > 0);
            } else {
                assert (this.coefs[lit] == null);
                if (this.coefs[lit ^ 1].compareTo(coef) < 0) {
                    this.setCoef(lit, coef.subtract(this.coefs[lit ^ 1]));
                    assert (this.coefs[lit].signum() > 0);
                    this.degree = this.degree.subtract(this.coefs[lit ^ 1]);
                    this.nullCoef(lit ^ 1);
                } else if (this.coefs[lit ^ 1].equals(coef)) {
                    this.degree = this.degree.subtract(coef);
                    this.nullCoef(lit ^ 1);
                } else {
                    this.decreaseCoef(lit ^ 1, coef);
                    assert (this.coefs[lit ^ 1].signum() > 0);
                    this.degree = this.degree.subtract(coef);
                }
            }
        }
        assert (this.coefs[lit ^ 1] == null || this.coefs[lit] == null);
    }

    @Override
    public void buildConstraintFromConflict(IVecInt resLits, IVec<BigInteger> resCoefs) {
        resLits.clear();
        resCoefs.clear();
        int i = 2;
        while (i < this.coefs.length) {
            if (this.coefs[i] != null) {
                resLits.push(i);
                assert (this.coefs[i].signum() > 0);
                resCoefs.push(this.coefs[i]);
            }
            ++i;
        }
    }

    @Override
    public void buildConstraintFromMapPb(int[] resLits, BigInteger[] resCoefs) {
        assert (resLits.length == resCoefs.length);
        assert (resLits.length == this.size());
        int ind = 0;
        int i = 2;
        while (i < this.coefs.length) {
            if (this.coefs[i] != null) {
                resLits[ind] = i;
                assert (this.coefs[i].signum() > 0);
                resCoefs[ind] = this.coefs[i];
                ++ind;
            }
            ++i;
        }
    }

    @Override
    public BigInteger getDegree() {
        return this.degree;
    }

    @Override
    public int size() {
        int cpt = 0;
        int i = 2;
        while (i < this.coefs.length) {
            if (this.coefs[i] != null) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        int i = 2;
        while (i < this.coefs.length) {
            if (this.coefs[i] != null) {
                stb.append(this.coefs[i]);
                stb.append(".");
                stb.append(Lits.toString(i));
                stb.append(" ");
                stb.append("[");
                stb.append(this.voc.valueToString(i));
                stb.append("@");
                stb.append(this.voc.getLevel(i));
                stb.append("]");
            }
            ++i;
        }
        return String.valueOf(stb.toString()) + " >= " + this.degree;
    }

    private BigInteger multiplyCoefficient(BigInteger coef, BigInteger mult) {
        if (mult.equals(BigInteger.ONE)) {
            return coef;
        }
        if (coef.equals(BigInteger.ONE)) {
            return mult;
        }
        return coef.multiply(mult);
    }

    private void increaseCoef(int lit, BigInteger incCoef) {
        this.coefs[lit] = this.coefs[lit].add(incCoef);
    }

    private void decreaseCoef(int lit, BigInteger decCoef) {
        this.coefs[lit] = this.coefs[lit].subtract(decCoef);
    }

    protected void setCoef(int lit, BigInteger newValue) {
        this.coefs[lit] = newValue;
    }

    private void nullCoef(int lit) {
        this.coefs[lit] = null;
    }
}

