/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sat4j.minisat.constraints.pb.ArrayPb;
import org.sat4j.minisat.constraints.pb.IConflict;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;

class ConflictArray
extends ArrayPb
implements IConflict {
    protected BigInteger coefMult = BigInteger.ZERO;
    protected BigInteger coefMultCons = BigInteger.ZERO;

    public static IConflict createConflict(PBConstr cpb, int level) {
        return new ConflictArray(cpb.getLits(), cpb.getCoefs(), cpb.getDegree(), cpb.getVocabulary(), level);
    }

    ConflictArray(int[] lits, BigInteger[] coefs, BigInteger d, ILits voc, int level) {
        super(lits, coefs, d, voc, level);
    }

    public BigInteger resolve(PBConstr cpb, int litImplied, VarActivityListener val) {
        assert (litImplied > 1);
        if (this.coefs[litImplied ^ 1] == null) {
            return this.degree;
        }
        assert (this.slackConflict().signum() <= 0);
        assert (this.degree.signum() >= 0);
        BigInteger[] coefsCons = null;
        BigInteger degreeCons = cpb.getDegree();
        int ind = 0;
        while (cpb.get(ind) != litImplied) {
            ++ind;
        }
        assert (cpb.get(ind) == litImplied);
        assert (cpb.getCoef(ind) != BigInteger.ZERO);
        if (cpb.getCoef(ind).equals(BigInteger.ONE)) {
            this.coefMultCons = this.coefs[litImplied ^ 1];
            this.coefMult = BigInteger.ONE;
            degreeCons = degreeCons.multiply(this.coefMultCons);
        } else {
            if (this.coefs[litImplied ^ 1].equals(BigInteger.ONE)) {
                this.coefMult = cpb.getCoef(ind);
                this.coefMultCons = BigInteger.ONE;
                this.degree = this.degree.multiply(this.coefMult);
            } else {
                WatchPb wpb = (WatchPb)cpb;
                coefsCons = wpb.getCoefs();
                assert (this.positiveCoefs(coefsCons));
                degreeCons = this.reduceUntilConflict(litImplied, ind, coefsCons, wpb);
                degreeCons = degreeCons.multiply(this.coefMultCons);
                this.degree = this.degree.multiply(this.coefMult);
            }
            if (!this.coefMult.equals(BigInteger.ONE)) {
                int i = 2;
                while (i < this.coefs.length) {
                    if (this.coefs[i] != null) {
                        this.setCoef(i, this.coefs[i].multiply(this.coefMult));
                    }
                    ++i;
                }
            }
        }
        this.degree = this.cuttingPlane(cpb, degreeCons, coefsCons, this.coefMultCons, val);
        assert (this.coefs[litImplied] == null);
        assert (this.coefs[litImplied ^ 1] == null);
        assert (this.degree.signum() > 0);
        this.degree = this.saturation();
        assert (this.slackConflict().signum() <= 0);
        return this.degree;
    }

    protected BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, WatchPb wpb) {
        BigInteger slackResolve = BigInteger.ONE.negate();
        BigInteger slackThis = BigInteger.ZERO;
        BigInteger slackIndex = BigInteger.ZERO;
        BigInteger reducedDegree = wpb.getDegree();
        do {
            if (slackResolve.signum() >= 0) {
                assert (slackThis.signum() > 0);
                BigInteger tmp = this.reduceInConstraint(wpb, reducedCoefs, ind, reducedDegree);
                assert (tmp.compareTo(reducedDegree) < 0 && tmp.compareTo(BigInteger.ONE) >= 0);
                reducedDegree = tmp;
            }
            assert (this.coefs[litImplied ^ 1].signum() > 0);
            assert (reducedCoefs[ind].signum() > 0);
            BigInteger ppcm = ConflictArray.ppcm(reducedCoefs[ind], this.coefs[litImplied ^ 1]);
            assert (ppcm.signum() > 0);
            this.coefMult = ppcm.divide(this.coefs[litImplied ^ 1]);
            this.coefMultCons = ppcm.divide(reducedCoefs[ind]);
            assert (this.coefMultCons.signum() > 0);
            assert (this.coefMult.signum() > 0);
            assert (this.coefMult.multiply(this.coefs[litImplied ^ 1]).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
            slackThis = wpb.slackConstraint(reducedCoefs, reducedDegree).multiply(this.coefMultCons);
            slackIndex = this.slackConflict().multiply(this.coefMult);
            assert (slackIndex.signum() <= 0);
        } while ((slackResolve = slackThis.add(slackIndex)).signum() >= 0);
        assert (this.coefMult.multiply(this.coefs[litImplied ^ 1]).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
        return reducedDegree;
    }

    public BigInteger slackConflict() {
        BigInteger poss = BigInteger.ZERO;
        int i = 2;
        while (i < this.coefs.length) {
            if (this.coefs[i] != null && this.coefs[i].signum() != 0 && !this.voc.isFalsified(i)) {
                poss = poss.add(this.coefs[i]);
            }
            ++i;
        }
        return poss.subtract(this.degree);
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    public BigInteger reduceInConstraint(WatchPb wpb, BigInteger[] coefsBis, int indLitImplied, BigInteger degreeBis) {
        assert (degreeBis.compareTo(BigInteger.ONE) > 0);
        int lit = -1;
        int ind = 0;
        while (ind < wpb.size() && lit == -1) {
            if (coefsBis[ind].signum() != 0 && this.voc.isUnassigned(wpb.get(ind))) {
                assert (coefsBis[ind].compareTo(degreeBis) < 0);
                lit = ind;
            }
            ++ind;
        }
        if (lit == -1) {
            ind = 0;
            while (ind < wpb.size() && lit == -1) {
                if (coefsBis[ind].signum() != 0 && this.voc.isSatisfied(wpb.get(ind)) && ind != indLitImplied) {
                    lit = ind;
                }
                ++ind;
            }
        }
        assert (lit != -1);
        assert (lit != indLitImplied);
        BigInteger degUpdate = degreeBis.subtract(coefsBis[lit]);
        coefsBis[lit] = BigInteger.ZERO;
        assert (degUpdate.signum() > 0);
        BigInteger minimum = degUpdate;
        int i = 0;
        while (i < coefsBis.length) {
            if (coefsBis[i].signum() > 0) {
                minimum = minimum.min(coefsBis[i]);
            }
            coefsBis[i] = degUpdate.min(coefsBis[i]);
            ++i;
        }
        if (minimum.equals(degUpdate) && !degUpdate.equals(BigInteger.ONE)) {
            degUpdate = BigInteger.ONE;
            i = 0;
            while (i < coefsBis.length) {
                if (coefsBis[i].signum() > 0) {
                    coefsBis[i] = degUpdate;
                }
                ++i;
            }
        }
        assert (coefsBis[indLitImplied].signum() > 0);
        assert (degreeBis.compareTo(degUpdate) > 0);
        return degUpdate;
    }

    private boolean positiveCoefs(BigInteger[] coefsCons) {
        int i = 0;
        while (i < coefsCons.length) {
            if (coefsCons[i].signum() <= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean oldIsAssertive(int dl) {
        BigInteger slack = this.computeSlack(dl);
        if ((slack = slack.subtract(this.degree)).signum() < 0) {
            return false;
        }
        int i = 2;
        while (i < this.coefs.length) {
            if (this.coefs[i] != null && this.coefs[i].signum() > 0 && (this.voc.isUnassigned(i) || this.voc.getLevel(i) >= dl) && slack.compareTo(this.coefs[i]) < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private BigInteger computeSlack(int dl) {
        BigInteger slack = BigInteger.ZERO;
        int i = 2;
        while (i < this.coefs.length) {
            if (!(this.coefs[i] == null || this.coefs[i].signum() <= 0 || this.voc.isFalsified(i) && this.voc.getLevel(i) < dl)) {
                slack = slack.add(this.coefs[i]);
            }
            ++i;
        }
        return slack;
    }

    public void updateSlack(int dl) {
        if (this.byLevel.containsKey(dl)) {
            Iterator iterator = ((List)this.byLevel.get(dl)).iterator();
            while (iterator.hasNext()) {
                int lit = (Integer)iterator.next();
                if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) != dl) continue;
                this.currentSlack = this.currentSlack.add(this.coefs[lit]);
            }
        }
    }

    public boolean isAssertive(int dl) {
        assert (dl <= this.currentLevel);
        this.currentLevel = dl;
        assert (this.currentSlack.equals(this.computeSlack(dl)));
        BigInteger slack = this.currentSlack.subtract(this.degree);
        if (slack.signum() < 0) {
            return false;
        }
        return this.isImplyingLiteral(dl, slack);
    }

    private boolean isImplyingLiteral(int dl, BigInteger slack) {
        Iterator<Object> iterator;
        if (this.byLevel.containsKey(-1)) {
            iterator = ((List)this.byLevel.get(-1)).iterator();
            while (iterator.hasNext()) {
                int lit = (Integer)iterator.next();
                if (slack.compareTo(this.coefs[lit]) >= 0) continue;
                return true;
            }
        }
        iterator = this.byLevel.tailMap(dl).keySet().iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            Iterator iterator2 = ((List)this.byLevel.get(level)).iterator();
            while (iterator2.hasNext()) {
                int lit = (Integer)iterator2.next();
                if (this.coefs[lit] == null || slack.compareTo(this.coefs[lit]) >= 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getBacktrackLevel(int maxLevel) {
        BigInteger slack = this.currentSlack.subtract(this.degree);
        int borneMax = 0;
        ArrayList tmp = new ArrayList(this.byLevel.headMap(maxLevel).keySet());
        int i = tmp.size() - 1;
        while (i >= 0) {
            int level = (Integer)tmp.get(i);
            if (level <= 0) {
                borneMax = 0;
                break;
            }
            for (Integer lit : (List)this.byLevel.get(level)) {
                if (!this.voc.isFalsified(lit)) continue;
                slack = slack.add(this.coefs[lit]);
            }
            assert (this.computeSlack(level).subtract(this.degree).equals(slack));
            if (!this.isImplyingLiteral(level, slack)) {
                borneMax = level;
                break;
            }
            --i;
        }
        assert (borneMax == this.oldGetBacktrackLevel(maxLevel));
        return borneMax;
    }

    public int oldGetBacktrackLevel(int maxLevel) {
        int litLevel;
        int borneMax = maxLevel;
        assert (this.oldIsAssertive(borneMax));
        int borneMin = -1;
        int lit = 2;
        while (lit < this.coefs.length) {
            if (this.coefs[lit] != null && (litLevel = this.voc.getLevel(lit)) < borneMax && litLevel > borneMin && this.oldIsAssertive(litLevel)) {
                borneMax = litLevel;
            }
            ++lit;
        }
        int retour = 0;
        int lit2 = 2;
        while (lit2 < this.coefs.length) {
            if (this.coefs[lit2] != null && (litLevel = this.voc.getLevel(lit2)) > retour && litLevel < borneMax) {
                retour = litLevel;
            }
            ++lit2;
        }
        return retour;
    }
}

