/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.IConflict;
import org.sat4j.minisat.constraints.pb.MapPb;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictMap
extends MapPb
implements IConflict {
    private final ILits voc;
    protected BigInteger currentSlack;
    protected int currentLevel;
    protected SortedMap<Integer, List<Integer>> byLevel = new TreeMap<Integer, List<Integer>>();
    private BigInteger coefMult = BigInteger.ZERO;
    private BigInteger coefMultCons = BigInteger.ZERO;

    public static IConflict createConflict(PBConstr cpb, int level) {
        HashMap<Integer, BigInteger> m = new HashMap<Integer, BigInteger>();
        int i = 0;
        while (i < cpb.size()) {
            int lit = cpb.get(i);
            BigInteger coefLit = cpb.getCoef(i);
            assert (cpb.get(i) != 0);
            assert (cpb.getCoef(i).signum() > 0);
            m.put(lit, coefLit);
            ++i;
        }
        return new ConflictMap(m, cpb.getDegree(), cpb.getVocabulary(), level);
    }

    ConflictMap(Map<Integer, BigInteger> m, BigInteger d, ILits voc, int level) {
        super(m, d);
        this.voc = voc;
        this.currentLevel = level;
        this.initStructures();
    }

    private void initStructures() {
        this.currentSlack = BigInteger.ZERO;
        for (Integer lit : this.coefs.keySet()) {
            int ilit = lit;
            int litLevel = this.voc.getLevel(ilit);
            BigInteger tmp = (BigInteger)this.coefs.get(lit);
            if (!(tmp.signum() <= 0 || this.voc.isFalsified(ilit) && litLevel != this.currentLevel)) {
                this.currentSlack = this.currentSlack.add(tmp);
            }
            if (this.byLevel.containsKey(litLevel)) {
                ((List)this.byLevel.get(litLevel)).add(lit);
                continue;
            }
            ArrayList<Integer> oneLevel = new ArrayList<Integer>();
            oneLevel.add(lit);
            this.byLevel.put(litLevel, oneLevel);
        }
    }

    @Override
    public BigInteger resolve(PBConstr cpb, int litImplied, VarActivityListener val) {
        assert (litImplied > 1);
        if (!this.coefs.containsKey(litImplied ^ 1)) {
            return this.degree;
        }
        assert (this.slackConflict().signum() <= 0);
        assert (this.degree.signum() >= 0);
        BigInteger[] coefsCons = null;
        BigInteger degreeCons = cpb.getDegree();
        int ind = 0;
        while (cpb.get(ind) != litImplied) {
            ++ind;
        }
        assert (cpb.get(ind) == litImplied);
        assert (cpb.getCoef(ind) != BigInteger.ZERO);
        if (cpb.getCoef(ind).equals(BigInteger.ONE)) {
            this.coefMultCons = (BigInteger)this.coefs.get(litImplied ^ 1);
            this.coefMult = BigInteger.ONE;
            degreeCons = degreeCons.multiply(this.coefMultCons);
        } else {
            if (((BigInteger)this.coefs.get(litImplied ^ 1)).equals(BigInteger.ONE)) {
                this.coefMult = cpb.getCoef(ind);
                this.coefMultCons = BigInteger.ONE;
                this.degree = this.degree.multiply(this.coefMult);
            } else {
                WatchPb wpb = (WatchPb)cpb;
                coefsCons = wpb.getCoefs();
                assert (this.positiveCoefs(coefsCons));
                degreeCons = this.reduceUntilConflict(litImplied, ind, coefsCons, wpb);
                degreeCons = degreeCons.multiply(this.coefMultCons);
                this.degree = this.degree.multiply(this.coefMult);
            }
            for (Integer i : this.coefs.keySet()) {
                this.setCoef(i, ((BigInteger)this.coefs.get(i)).multiply(this.coefMult));
            }
        }
        this.degree = this.cuttingPlane(cpb, degreeCons, coefsCons, this.coefMultCons, val);
        assert (!this.coefs.containsKey(litImplied));
        assert (!this.coefs.containsKey(litImplied ^ 1));
        assert (this.degree.signum() > 0);
        this.degree = this.saturation();
        assert (this.slackConflict().signum() <= 0);
        return this.degree;
    }

    private BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, WatchPb wpb) {
        BigInteger slackResolve = BigInteger.ONE.negate();
        BigInteger slackThis = BigInteger.ZERO;
        BigInteger slackIndex = BigInteger.ZERO;
        BigInteger reducedDegree = wpb.getDegree();
        do {
            if (slackResolve.signum() >= 0) {
                assert (slackThis.signum() > 0);
                BigInteger tmp = this.reduceInConstraint(wpb, reducedCoefs, ind, reducedDegree);
                assert (tmp.compareTo(reducedDegree) < 0 && tmp.compareTo(BigInteger.ONE) >= 0);
                reducedDegree = tmp;
            }
            assert (((BigInteger)this.coefs.get(litImplied ^ 1)).signum() > 0);
            assert (reducedCoefs[ind].signum() > 0);
            BigInteger coefLitImplied = (BigInteger)this.coefs.get(litImplied ^ 1);
            BigInteger ppcm = ConflictMap.ppcm(reducedCoefs[ind], coefLitImplied);
            assert (ppcm.signum() > 0);
            this.coefMult = ppcm.divide(coefLitImplied);
            this.coefMultCons = ppcm.divide(reducedCoefs[ind]);
            assert (this.coefMultCons.signum() > 0);
            assert (this.coefMult.signum() > 0);
            assert (this.coefMult.multiply(coefLitImplied).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
            slackThis = wpb.slackConstraint(reducedCoefs, reducedDegree).multiply(this.coefMultCons);
            slackIndex = this.slackConflict().multiply(this.coefMult);
            assert (slackIndex.signum() <= 0);
        } while ((slackResolve = slackThis.add(slackIndex)).signum() >= 0);
        assert (this.coefMult.multiply((BigInteger)this.coefs.get(litImplied ^ 1)).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
        return reducedDegree;
    }

    @Override
    public BigInteger slackConflict() {
        BigInteger poss = BigInteger.ZERO;
        for (Integer i : this.coefs.keySet()) {
            BigInteger tmp = (BigInteger)this.coefs.get(i);
            if (tmp.signum() == 0 || this.voc.isFalsified(i)) continue;
            poss = poss.add(tmp);
        }
        return poss.subtract(this.degree);
    }

    public boolean oldIsAssertive(int dl) {
        BigInteger slack = this.computeSlack(dl).subtract(this.degree);
        if (slack.signum() < 0) {
            return false;
        }
        for (Integer i : this.coefs.keySet()) {
            BigInteger tmp = (BigInteger)this.coefs.get(i);
            if (tmp.signum() <= 0 || !this.voc.isUnassigned(i) && this.voc.getLevel(i) < dl || slack.compareTo(tmp) >= 0) continue;
            return true;
        }
        return false;
    }

    private BigInteger computeSlack(int dl) {
        BigInteger slack = BigInteger.ZERO;
        for (Integer i : this.coefs.keySet()) {
            BigInteger tmp = (BigInteger)this.coefs.get(i);
            if (tmp.signum() <= 0 || this.voc.isFalsified(i) && this.voc.getLevel(i) < dl) continue;
            slack = slack.add(tmp);
        }
        return slack;
    }

    @Override
    public boolean isAssertive(int dl) {
        assert (dl <= this.currentLevel);
        assert (dl <= this.currentLevel);
        this.currentLevel = dl;
        assert (this.currentSlack.equals(this.computeSlack(dl)));
        BigInteger slack = this.currentSlack.subtract(this.degree);
        if (slack.signum() < 0) {
            return false;
        }
        return this.isImplyingLiteral(dl, slack);
    }

    private boolean isImplyingLiteral(int dl, BigInteger slack) {
        Integer unassigned = -1;
        if (this.byLevel.containsKey(unassigned)) {
            for (Integer lit : (List)this.byLevel.get(unassigned)) {
                if (slack.compareTo((BigInteger)this.coefs.get(lit)) >= 0) continue;
                return true;
            }
        }
        for (Integer level : this.byLevel.tailMap(dl).keySet()) {
            for (Integer lit : (List)this.byLevel.get(level)) {
                BigInteger tmp = (BigInteger)this.coefs.get(lit);
                if (tmp == null || slack.compareTo(tmp) >= 0) continue;
                return true;
            }
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    @Override
    public BigInteger reduceInConstraint(WatchPb wpb, BigInteger[] coefsBis, int indLitImplied, BigInteger degreeBis) {
        assert (degreeBis.compareTo(BigInteger.ONE) > 0);
        int lit = -1;
        int ind = 0;
        while (ind < wpb.lits.length && lit == -1) {
            if (coefsBis[ind].signum() != 0 && this.voc.isUnassigned(wpb.lits[ind])) {
                assert (coefsBis[ind].compareTo(degreeBis) < 0);
                lit = ind;
            }
            ++ind;
        }
        if (lit == -1) {
            ind = 0;
            while (ind < wpb.lits.length && lit == -1) {
                if (coefsBis[ind].signum() != 0 && this.voc.isSatisfied(wpb.lits[ind]) && ind != indLitImplied) {
                    lit = ind;
                }
                ++ind;
            }
        }
        assert (lit != -1);
        assert (lit != indLitImplied);
        BigInteger degUpdate = degreeBis.subtract(coefsBis[lit]);
        coefsBis[lit] = BigInteger.ZERO;
        assert (degUpdate.signum() > 0);
        BigInteger minimum = degUpdate;
        int i = 0;
        while (i < coefsBis.length) {
            if (coefsBis[i].signum() > 0) {
                minimum = minimum.min(coefsBis[i]);
            }
            coefsBis[i] = degUpdate.min(coefsBis[i]);
            ++i;
        }
        if (minimum.equals(degUpdate) && !degUpdate.equals(BigInteger.ONE)) {
            degUpdate = BigInteger.ONE;
            i = 0;
            while (i < coefsBis.length) {
                if (coefsBis[i].signum() > 0) {
                    coefsBis[i] = degUpdate;
                }
                ++i;
            }
        }
        assert (coefsBis[indLitImplied].signum() > 0);
        assert (degreeBis.compareTo(degUpdate) > 0);
        return degUpdate;
    }

    private boolean positiveCoefs(BigInteger[] coefsCons) {
        int i = 0;
        while (i < coefsCons.length) {
            if (coefsCons[i].signum() <= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getBacktrackLevel(int maxLevel) {
        BigInteger slack = this.currentSlack.subtract(this.degree);
        ArrayList tmp = new ArrayList(this.byLevel.headMap(maxLevel).keySet());
        int borneMax = 0;
        int i = tmp.size() - 1;
        while (i >= 0) {
            int level = (Integer)tmp.get(i);
            if (level <= 0) {
                borneMax = 0;
                break;
            }
            List lits = (List)this.byLevel.get(level);
            if (!lits.isEmpty()) {
                for (Integer lit : lits) {
                    if (!this.voc.isFalsified(lit)) continue;
                    slack = slack.add((BigInteger)this.coefs.get(lit));
                }
                assert (this.computeSlack(level).subtract(this.degree).equals(slack));
                if (!this.isImplyingLiteral(level, slack)) {
                    borneMax = level;
                    break;
                }
            }
            --i;
        }
        int retour = this.oldGetBacktrackLevel(maxLevel);
        assert (borneMax == retour);
        return borneMax;
    }

    public int oldGetBacktrackLevel(int maxLevel) {
        int litLevel;
        int borneMax = maxLevel;
        assert (this.oldIsAssertive(borneMax));
        int borneMin = -1;
        Iterator iterator = this.coefs.keySet().iterator();
        while (iterator.hasNext()) {
            int lit = (Integer)iterator.next();
            litLevel = this.voc.getLevel(lit);
            if (litLevel >= borneMax || litLevel <= borneMin || !this.oldIsAssertive(litLevel)) continue;
            borneMax = litLevel;
        }
        int retour = 0;
        Iterator iterator2 = this.coefs.keySet().iterator();
        while (iterator2.hasNext()) {
            int lit = (Integer)iterator2.next();
            litLevel = this.voc.getLevel(lit);
            if (litLevel <= retour || litLevel >= borneMax) continue;
            retour = litLevel;
        }
        return retour;
    }

    @Override
    public void updateSlack(int level) {
        Integer dl = level;
        if (this.byLevel.containsKey(dl)) {
            Iterator iterator = ((List)this.byLevel.get(dl)).iterator();
            while (iterator.hasNext()) {
                int lit = (Integer)iterator.next();
                if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) != dl.intValue()) continue;
                this.currentSlack = this.currentSlack.add((BigInteger)this.coefs.get(lit));
            }
        }
    }

    @Override
    void increaseCoef(Integer lit, BigInteger incCoef) {
        int ilit = lit;
        if (!this.voc.isFalsified(ilit) || this.voc.getLevel(ilit) == this.currentLevel) {
            this.currentSlack = this.currentSlack.add(incCoef);
        }
        super.increaseCoef(lit, incCoef);
    }

    @Override
    void decreaseCoef(Integer lit, BigInteger decCoef) {
        int ilit = lit;
        if (!this.voc.isFalsified(ilit) || this.voc.getLevel(ilit) == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(decCoef);
        }
        super.decreaseCoef(lit, decCoef);
    }

    @Override
    void setCoef(Integer lit, BigInteger newValue) {
        int ilit = lit;
        int ilitLevel = this.voc.getLevel(ilit);
        if (!this.voc.isFalsified(ilit) || ilitLevel == this.currentLevel) {
            if (this.coefs.containsKey(lit)) {
                this.currentSlack = this.currentSlack.subtract((BigInteger)this.coefs.get(lit));
            }
            this.currentSlack = this.currentSlack.add(newValue);
        }
        if (!this.coefs.containsKey(lit)) {
            Integer litLevel = ilitLevel;
            if (this.byLevel.containsKey(litLevel)) {
                ((List)this.byLevel.get(litLevel)).add(lit);
            } else {
                ArrayList<Integer> oneLevel = new ArrayList<Integer>();
                oneLevel.add(lit);
                this.byLevel.put(litLevel, oneLevel);
            }
        }
        super.setCoef(lit, newValue);
    }

    @Override
    void removeCoef(Integer lit) {
        int ilit = lit;
        int litLevel = this.voc.getLevel(ilit);
        if (!this.voc.isFalsified(ilit) || litLevel == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract((BigInteger)this.coefs.get(lit));
        }
        if (this.byLevel.containsKey(litLevel)) {
            ((List)this.byLevel.get(litLevel)).remove(lit);
        }
        super.removeCoef(lit);
    }

    @Override
    public String toString() {
        StringBuilder stb = new StringBuilder();
        for (Map.Entry entry : this.coefs.entrySet()) {
            int lit = (Integer)entry.getKey();
            stb.append(entry.getValue());
            stb.append(".");
            stb.append(Lits.toString(lit));
            stb.append(" ");
            stb.append("[");
            stb.append(this.voc.valueToString(lit));
            stb.append("@");
            stb.append(this.voc.getLevel(lit));
            stb.append("]");
        }
        return String.valueOf(stb.toString()) + " >= " + this.degree;
    }
}

