/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sat4j.minisat.constraints.pb.IConflict;
import org.sat4j.minisat.constraints.pb.MapPb;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictMapInitial
extends MapPb
implements IConflict {
    private final ILits voc;
    private BigInteger coefMult = BigInteger.ZERO;
    private BigInteger coefMultCons = BigInteger.ZERO;

    public static IConflict createConflict(PBConstr cpb, int level) {
        HashMap<Integer, BigInteger> m = new HashMap<Integer, BigInteger>();
        int i = 0;
        while (i < cpb.size()) {
            assert (cpb.get(i) != 0);
            assert (cpb.getCoef(i).signum() > 0);
            m.put(cpb.get(i), cpb.getCoef(i));
            ++i;
        }
        return new ConflictMapInitial(m, cpb.getDegree(), cpb.getVocabulary(), level);
    }

    ConflictMapInitial(Map<Integer, BigInteger> m, BigInteger d, ILits voc, int level) {
        super(m, d);
        this.voc = voc;
    }

    @Override
    public BigInteger resolve(PBConstr cpb, int litImplied, VarActivityListener val) {
        assert (litImplied > 1);
        if (!this.coefs.containsKey(litImplied ^ 1)) {
            return this.degree;
        }
        assert (this.slackConflict().signum() <= 0);
        assert (this.degree.signum() >= 0);
        BigInteger[] coefsCons = null;
        BigInteger degreeCons = cpb.getDegree();
        int ind = 0;
        while (cpb.get(ind) != litImplied) {
            ++ind;
        }
        assert (cpb.get(ind) == litImplied);
        assert (cpb.getCoef(ind) != BigInteger.ZERO);
        if (cpb.getCoef(ind).equals(BigInteger.ONE)) {
            this.coefMultCons = (BigInteger)this.coefs.get(litImplied ^ 1);
            this.coefMult = BigInteger.ONE;
            degreeCons = degreeCons.multiply(this.coefMultCons);
        } else {
            if (((BigInteger)this.coefs.get(litImplied ^ 1)).equals(BigInteger.ONE)) {
                this.coefMult = cpb.getCoef(ind);
                this.coefMultCons = BigInteger.ONE;
                this.degree = this.degree.multiply(this.coefMult);
            } else {
                WatchPb wpb = (WatchPb)cpb;
                coefsCons = wpb.getCoefs();
                assert (this.positiveCoefs(coefsCons));
                degreeCons = this.reduceUntilConflict(litImplied, ind, coefsCons, wpb);
                degreeCons = degreeCons.multiply(this.coefMultCons);
                this.degree = this.degree.multiply(this.coefMult);
            }
            for (Integer i : this.coefs.keySet()) {
                this.coefs.put(i, ((BigInteger)this.coefs.get(i)).multiply(this.coefMult));
            }
        }
        this.degree = this.cuttingPlane(cpb, degreeCons, coefsCons, this.coefMultCons, val);
        assert (!this.coefs.containsKey(litImplied));
        assert (!this.coefs.containsKey(litImplied ^ 1));
        assert (this.degree.signum() > 0);
        this.degree = this.saturation();
        assert (this.slackConflict().signum() <= 0);
        return this.degree;
    }

    private BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, WatchPb wpb) {
        BigInteger slackResolve = BigInteger.ONE.negate();
        BigInteger slackThis = BigInteger.ZERO;
        BigInteger slackIndex = BigInteger.ZERO;
        BigInteger reducedDegree = wpb.getDegree();
        do {
            if (slackResolve.signum() >= 0) {
                assert (slackThis.signum() > 0);
                BigInteger tmp = this.reduceInConstraint(wpb, reducedCoefs, ind, reducedDegree);
                assert (tmp.compareTo(reducedDegree) < 0 && tmp.compareTo(BigInteger.ONE) >= 0);
                reducedDegree = tmp;
            }
            assert (((BigInteger)this.coefs.get(litImplied ^ 1)).signum() > 0);
            assert (reducedCoefs[ind].signum() > 0);
            BigInteger coefLitImplied = (BigInteger)this.coefs.get(litImplied ^ 1);
            BigInteger ppcm = ConflictMapInitial.ppcm(reducedCoefs[ind], coefLitImplied);
            assert (ppcm.signum() > 0);
            this.coefMult = ppcm.divide(coefLitImplied);
            this.coefMultCons = ppcm.divide(reducedCoefs[ind]);
            assert (this.coefMultCons.signum() > 0);
            assert (this.coefMult.signum() > 0);
            assert (this.coefMult.multiply(coefLitImplied).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
            slackThis = wpb.slackConstraint(reducedCoefs, reducedDegree).multiply(this.coefMultCons);
            slackIndex = this.slackConflict().multiply(this.coefMult);
            assert (slackIndex.signum() <= 0);
        } while ((slackResolve = slackThis.add(slackIndex)).signum() >= 0);
        assert (this.coefMult.multiply((BigInteger)this.coefs.get(litImplied ^ 1)).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
        return reducedDegree;
    }

    @Override
    public BigInteger slackConflict() {
        BigInteger poss = BigInteger.ZERO;
        for (Integer i : this.coefs.keySet()) {
            BigInteger tmp = (BigInteger)this.coefs.get(i);
            if (tmp.signum() == 0 || this.voc.isFalsified(i)) continue;
            poss = poss.add(tmp);
        }
        return poss.subtract(this.degree);
    }

    @Override
    public boolean isAssertive(int dl) {
        BigInteger tmp;
        BigInteger slack = BigInteger.ZERO;
        for (Integer i : this.coefs.keySet()) {
            tmp = (BigInteger)this.coefs.get(i);
            if (tmp.signum() <= 0 || this.voc.isFalsified(i) && this.voc.getLevel(i) < dl) continue;
            slack = slack.add(tmp);
        }
        if ((slack = slack.subtract(this.degree)).signum() < 0) {
            return false;
        }
        for (Integer i : this.coefs.keySet()) {
            tmp = (BigInteger)this.coefs.get(i);
            if (tmp.signum() <= 0 || !this.voc.isUnassigned(i) && this.voc.getLevel(i) < dl || slack.subtract(tmp).signum() >= 0) continue;
            return true;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    @Override
    public BigInteger reduceInConstraint(WatchPb wpb, BigInteger[] coefsBis, int indLitImplied, BigInteger degreeBis) {
        assert (degreeBis.compareTo(BigInteger.ONE) > 0);
        int lit = -1;
        int ind = 0;
        while (ind < wpb.size() && lit == -1) {
            if (coefsBis[ind].signum() != 0 && this.voc.isUnassigned(wpb.get(ind))) {
                assert (coefsBis[ind].compareTo(degreeBis) < 0);
                lit = ind;
            }
            ++ind;
        }
        if (lit == -1) {
            ind = 0;
            while (ind < wpb.size() && lit == -1) {
                if (coefsBis[ind].signum() != 0 && this.voc.isSatisfied(wpb.get(ind)) && ind != indLitImplied) {
                    lit = ind;
                }
                ++ind;
            }
        }
        assert (lit != -1);
        assert (lit != indLitImplied);
        BigInteger degUpdate = degreeBis.subtract(coefsBis[lit]);
        coefsBis[lit] = BigInteger.ZERO;
        assert (degUpdate.signum() > 0);
        BigInteger minimum = degUpdate;
        int i = 0;
        while (i < coefsBis.length) {
            if (coefsBis[i].signum() > 0) {
                minimum = minimum.min(coefsBis[i]);
            }
            coefsBis[i] = degUpdate.min(coefsBis[i]);
            ++i;
        }
        if (minimum.equals(degUpdate) && !degUpdate.equals(BigInteger.ONE)) {
            degUpdate = BigInteger.ONE;
            i = 0;
            while (i < coefsBis.length) {
                if (coefsBis[i].signum() > 0) {
                    coefsBis[i] = degUpdate;
                }
                ++i;
            }
        }
        assert (coefsBis[indLitImplied].signum() > 0);
        assert (degreeBis.compareTo(degUpdate) > 0);
        return degUpdate;
    }

    private boolean positiveCoefs(BigInteger[] coefsCons) {
        int i = 0;
        while (i < coefsCons.length) {
            if (coefsCons[i].signum() <= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getBacktrackLevel(int maxLevel) {
        int litLevel;
        int borneMax = maxLevel;
        assert (this.isAssertive(borneMax));
        int borneMin = -1;
        Iterator iterator = this.coefs.keySet().iterator();
        while (iterator.hasNext()) {
            int lit = (Integer)iterator.next();
            litLevel = this.voc.getLevel(lit);
            if (litLevel >= borneMax || litLevel <= borneMin || !this.isAssertive(litLevel)) continue;
            borneMax = litLevel;
        }
        int retour = 0;
        Iterator iterator2 = this.coefs.keySet().iterator();
        while (iterator2.hasNext()) {
            int lit = (Integer)iterator2.next();
            litLevel = this.voc.getLevel(lit);
            if (litLevel <= retour || litLevel >= borneMax) continue;
            retour = litLevel;
        }
        return retour;
    }

    @Override
    public void updateSlack(int level) {
    }
}

