/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPb
implements IDataStructurePB {
    protected Map<Integer, BigInteger> coefs;
    protected BigInteger degree;

    MapPb(Map<Integer, BigInteger> m, BigInteger d) {
        this.coefs = m;
        this.degree = d;
    }

    MapPb(ILits lits) {
        this();
    }

    MapPb() {
        this(new HashMap<Integer, BigInteger>(), BigInteger.ZERO);
    }

    @Override
    public BigInteger saturation() {
        assert (this.degree.signum() > 0);
        BigInteger minimum = this.degree;
        for (Map.Entry<Integer, BigInteger> e : this.coefs.entrySet()) {
            assert (e.getValue().signum() > 0);
            if (this.degree.compareTo(e.getValue()) < 0) {
                this.setCoef(e.getKey(), this.degree);
            }
            assert (e.getValue().signum() > 0);
            minimum = minimum.min(e.getValue());
        }
        if (minimum.equals(this.degree) && minimum.compareTo(BigInteger.ONE) > 0) {
            this.degree = BigInteger.ONE;
            for (Integer i : this.coefs.keySet()) {
                this.setCoef(i, BigInteger.ONE);
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(PBConstr cpb, BigInteger deg, BigInteger[] reducedCoefs, VarActivityListener val) {
        return this.cuttingPlane(cpb, deg, reducedCoefs, BigInteger.ONE, val);
    }

    @Override
    public BigInteger cuttingPlane(PBConstr cpb, BigInteger degreeCons, BigInteger[] reducedCoefs, BigInteger coefMult, VarActivityListener val) {
        this.degree = this.degree.add(degreeCons);
        assert (this.degree.signum() > 0);
        if (reducedCoefs == null) {
            int i = 0;
            while (i < cpb.size()) {
                val.varBumpActivity(cpb.get(i));
                this.cuttingPlaneStep(cpb.get(i), this.multiplyCoefficient(cpb.getCoef(i), coefMult));
                ++i;
            }
        } else {
            int i = 0;
            while (i < cpb.size()) {
                val.varBumpActivity(cpb.get(i));
                this.cuttingPlaneStep(cpb.get(i), this.multiplyCoefficient(reducedCoefs[i], coefMult));
                ++i;
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(int[] lits, BigInteger[] reducedCoefs, BigInteger deg) {
        return this.cuttingPlane(lits, reducedCoefs, deg, BigInteger.ONE);
    }

    @Override
    public BigInteger cuttingPlane(int[] lits, BigInteger[] reducedCoefs, BigInteger degreeCons, BigInteger coefMult) {
        this.degree = this.degree.add(degreeCons);
        assert (this.degree.signum() > 0);
        int i = 0;
        while (i < lits.length) {
            this.cuttingPlaneStep(lits[i], reducedCoefs[i].multiply(coefMult));
            ++i;
        }
        return this.degree;
    }

    private void cuttingPlaneStep(int lit, BigInteger coef) {
        assert (coef.signum() >= 0);
        Integer blit = lit;
        Integer bnlit = lit ^ 1;
        if (coef.signum() > 0) {
            if (this.coefs.containsKey(bnlit)) {
                assert (!this.coefs.containsKey(blit));
                if (this.coefs.get(bnlit).compareTo(coef) < 0) {
                    BigInteger tmp = this.coefs.get(bnlit);
                    this.setCoef(blit, coef.subtract(tmp));
                    assert (this.coefs.get(blit).signum() > 0);
                    this.degree = this.degree.subtract(tmp);
                    this.removeCoef(bnlit);
                } else if (this.coefs.get(bnlit).equals(coef)) {
                    this.degree = this.degree.subtract(coef);
                    this.removeCoef(bnlit);
                } else {
                    this.decreaseCoef(bnlit, coef);
                    assert (this.coefs.get(bnlit).signum() > 0);
                    this.degree = this.degree.subtract(coef);
                }
            } else {
                assert (!this.coefs.containsKey(blit) || this.coefs.get(blit).signum() > 0);
                if (this.coefs.containsKey(blit)) {
                    this.increaseCoef(blit, coef);
                } else {
                    this.setCoef(blit, coef);
                }
                assert (this.coefs.get(blit).signum() > 0);
            }
        }
        assert (!this.coefs.containsKey(bnlit) || !this.coefs.containsKey(blit));
    }

    @Override
    public void buildConstraintFromConflict(IVecInt resLits, IVec<BigInteger> resCoefs) {
        resLits.clear();
        resCoefs.clear();
        for (Map.Entry<Integer, BigInteger> e : this.coefs.entrySet()) {
            resLits.push(e.getKey());
            assert (e.getValue().signum() > 0);
            resCoefs.push(e.getValue());
        }
    }

    @Override
    public void buildConstraintFromMapPb(int[] resLits, BigInteger[] resCoefs) {
        assert (resLits.length == resCoefs.length);
        assert (resLits.length == this.coefs.keySet().size());
        int i = 0;
        for (Map.Entry<Integer, BigInteger> e : this.coefs.entrySet()) {
            resLits[i] = e.getKey();
            assert (e.getValue().signum() > 0);
            resCoefs[i] = e.getValue();
            ++i;
        }
    }

    @Override
    public BigInteger getDegree() {
        return this.degree;
    }

    @Override
    public int size() {
        return this.coefs.keySet().size();
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        for (Map.Entry<Integer, BigInteger> entry : this.coefs.entrySet()) {
            stb.append(entry.getValue());
            stb.append(".");
            stb.append(Lits.toString(entry.getKey()));
            stb.append(" ");
        }
        return String.valueOf(stb.toString()) + " >= " + this.degree;
    }

    private BigInteger multiplyCoefficient(BigInteger coef, BigInteger mult) {
        if (coef.equals(BigInteger.ONE)) {
            return mult;
        }
        return coef.multiply(mult);
    }

    void increaseCoef(Integer lit, BigInteger incCoef) {
        this.coefs.put(lit, this.coefs.get(lit).add(incCoef));
    }

    void decreaseCoef(Integer lit, BigInteger decCoef) {
        this.coefs.put(lit, this.coefs.get(lit).subtract(decCoef));
    }

    void setCoef(Integer lit, BigInteger newValue) {
        this.coefs.put(lit, newValue);
    }

    void removeCoef(Integer lit) {
        this.coefs.remove(lit);
    }
}

