/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxWatchPb
extends WatchPb
implements Serializable {
    private static final long serialVersionUID = 1L;

    private MaxWatchPb(ILits voc, IDataStructurePB mpb) {
        super(mpb);
        this.voc = voc;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.locked = false;
    }

    @Override
    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul.equals(BigInteger.ZERO));
        int i = 0;
        while (i < this.lits.length) {
            if (this.voc.isFalsified(this.lits[i])) {
                if (this.learnt) {
                    this.voc.undos(this.lits[i] ^ 1).push(this);
                }
            } else {
                this.voc.watch(this.lits[i] ^ 1, this);
                this.watchCumul = this.watchCumul.add(this.coefs[i]);
            }
            ++i;
        }
        assert (this.watchCumul.compareTo(this.recalcLeftSide()) >= 0);
        if (!this.learnt && this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    @Override
    protected void computePropagation(UnitPropagationListener s) throws ContradictionException {
        int ind = 0;
        while (ind < this.coefs.length && this.watchCumul.subtract(this.coefs[ind]).compareTo(this.degree) < 0) {
            if (this.voc.isUnassigned(this.lits[ind]) && !s.enqueue(this.lits[ind], this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++ind;
        }
        assert (this.watchCumul.compareTo(this.recalcLeftSide()) >= 0);
    }

    public static MaxWatchPb maxWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVecInt coefs, boolean moreThan, int degree) throws ContradictionException {
        return MaxWatchPb.maxWatchPbNew(s, voc, ps, MaxWatchPb.toVecBigInt(coefs), moreThan, MaxWatchPb.toBigInt(degree));
    }

    public static MaxWatchPb maxWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        VecInt litsVec = new VecInt();
        Vec<BigInteger> coefsVec = new Vec<BigInteger>();
        ps.copyTo(litsVec);
        coefs.copyTo(coefsVec);
        IDataStructurePB mpb = MaxWatchPb.niceParameters(litsVec, coefsVec, moreThan, degree, voc);
        if (mpb == null) {
            return null;
        }
        MaxWatchPb outclause = new MaxWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    @Override
    public boolean propagate(UnitPropagationListener s, int p) {
        this.voc.watch(p, this);
        assert (this.watchCumul.compareTo(this.recalcLeftSide()) >= 0) : this.watchCumul + "/" + this.recalcLeftSide() + ":" + this.learnt;
        int indiceP = 0;
        while ((this.lits[indiceP] ^ 1) != p) {
            ++indiceP;
        }
        BigInteger coefP = this.coefs[indiceP];
        BigInteger newcumul = this.watchCumul.subtract(coefP);
        if (newcumul.compareTo(this.degree) < 0) {
            assert (!this.isSatisfiable());
            return false;
        }
        this.voc.undos(p).push(this);
        this.watchCumul = newcumul;
        int ind = 0;
        BigInteger limit = this.watchCumul.subtract(this.degree);
        while (ind < this.coefs.length && limit.compareTo(this.coefs[ind]) < 0) {
            if (this.voc.isUnassigned(this.lits[ind]) && !s.enqueue(this.lits[ind], this)) {
                assert (!this.isSatisfiable());
                return false;
            }
            ++ind;
        }
        assert (this.learnt || this.watchCumul.compareTo(this.recalcLeftSide()) >= 0);
        assert (this.watchCumul.compareTo(this.recalcLeftSide()) >= 0);
        return true;
    }

    @Override
    public void remove() {
        int i = 0;
        while (i < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[i])) {
                this.voc.watches(this.lits[i] ^ 1).remove(this);
            }
            ++i;
        }
    }

    @Override
    public void undo(int p) {
        int indiceP = 0;
        while ((this.lits[indiceP] ^ 1) != p) {
            ++indiceP;
        }
        assert (this.coefs[indiceP].signum() > 0);
        this.watchCumul = this.watchCumul.add(this.coefs[indiceP]);
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVecInt coefs, boolean moreThan, int degree) {
        return MaxWatchPb.watchPbNew(voc, lits, MaxWatchPb.toVecBigInt(coefs), moreThan, MaxWatchPb.toBigInt(degree));
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) {
        IDataStructurePB mpb = null;
        mpb = MaxWatchPb.niceCheckedParameters(lits, coefs, moreThan, degree, voc);
        return new MaxWatchPb(voc, mpb);
    }

    public static MaxWatchPb normalizedMaxWatchPbNew(UnitPropagationListener s, ILits voc, IDataStructurePB mpb) throws ContradictionException {
        MaxWatchPb outclause = new MaxWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }
}

