/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.card.MinWatchCard;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public class MinWatchCardPB
extends MinWatchCard
implements PBConstr {
    private static final long serialVersionUID = 1L;
    private final BigInteger degree;
    private boolean learnt = false;

    public MinWatchCardPB(ILits voc, IVecInt ps, boolean moreThan, int degree) {
        super(voc, ps, moreThan, degree);
        this.degree = BigInteger.valueOf(degree);
    }

    public MinWatchCardPB(ILits voc, IVecInt ps, int degree) {
        super(voc, ps, degree);
        this.degree = BigInteger.valueOf(degree);
    }

    public BigInteger getCoef(int literal) {
        return BigInteger.ONE;
    }

    public BigInteger getDegree() {
        return this.degree;
    }

    public BigInteger[] getCoefs() {
        BigInteger[] tmp = new BigInteger[this.size()];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = BigInteger.ONE;
            ++i;
        }
        return tmp;
    }

    public static MinWatchCardPB normalizedMinWatchCardPBNew(UnitPropagationListener s, ILits voc, IVecInt ps, int degree) throws ContradictionException {
        return MinWatchCardPB.minWatchCardPBNew(s, voc, ps, true, degree, true);
    }

    public static MinWatchCardPB minWatchCardPBNew(UnitPropagationListener s, ILits voc, IVecInt ps, boolean moreThan, int degree) throws ContradictionException {
        return MinWatchCardPB.minWatchCardPBNew(s, voc, ps, moreThan, degree, false);
    }

    private static MinWatchCardPB minWatchCardPBNew(UnitPropagationListener s, ILits voc, IVecInt ps, boolean moreThan, int degree, boolean normalized) throws ContradictionException {
        int mydegree = degree + MinWatchCardPB.linearisation(voc, ps);
        if (ps.size() == 0 && mydegree > 0) {
            throw new ContradictionException();
        }
        if (ps.size() == mydegree || ps.size() <= 0) {
            int i = 0;
            while (i < ps.size()) {
                if (!s.enqueue(ps.get(i))) {
                    throw new ContradictionException();
                }
                ++i;
            }
            return null;
        }
        MinWatchCardPB retour = null;
        retour = normalized ? new MinWatchCardPB(voc, ps, mydegree) : new MinWatchCardPB(voc, ps, moreThan, mydegree);
        if (retour.degree.signum() <= 0) {
            return null;
        }
        retour.computeWatches();
        return (MinWatchCardPB)retour.computePropagation(s);
    }

    public boolean learnt() {
        return this.learnt;
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public void register() {
        assert (this.learnt);
        this.computeWatches();
    }

    public void assertConstraint(UnitPropagationListener s) {
        int i = 0;
        while (i < this.size()) {
            if (this.getVocabulary().isUnassigned(this.get(i))) {
                boolean ret = s.enqueue(this.get(i), this);
                assert (ret);
            }
            ++i;
        }
    }

    public IVecInt computeAnImpliedClause() {
        return null;
    }
}

