/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinWatchPb
extends WatchPb
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;

    protected MinWatchPb(ILits voc, IDataStructurePB mpb) {
        super(mpb);
        this.voc = voc;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.locked = false;
        this.watchingCount = 0;
    }

    @Override
    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul.signum() == 0);
        assert (this.watchingCount == 0);
        int i = 0;
        while (i < this.lits.length && this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0) {
            if (!this.voc.isFalsified(this.lits[i])) {
                this.voc.watch(this.lits[i] ^ 1, this);
                this.watching[this.watchingCount++] = i;
                this.watched[i] = true;
                this.watchCumul = this.watchCumul.add(this.coefs[i]);
            }
            ++i;
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.nbOfWatched() == this.watchingCount);
    }

    private void watchMoreForLearntConstraint() {
        int free = 1;
        while (this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0 && free > 0) {
            free = 0;
            int maxlevel = -1;
            int maxi = -1;
            int i = 0;
            while (i < this.lits.length) {
                if (this.voc.isFalsified(this.lits[i]) && !this.watched[i]) {
                    ++free;
                    int level = this.voc.getLevel(this.lits[i]);
                    if (level > maxlevel) {
                        maxi = i;
                        maxlevel = level;
                    }
                }
                ++i;
            }
            if (free <= 0) continue;
            assert (maxi >= 0);
            this.voc.watch(this.lits[maxi] ^ 1, this);
            this.watching[this.watchingCount++] = maxi;
            this.watched[maxi] = true;
            this.watchCumul = this.watchCumul.add(this.coefs[maxi]);
            assert (--free >= 0);
        }
        assert (this.lits.length == 1 || this.watchingCount > 1);
    }

    @Override
    protected void computePropagation(UnitPropagationListener s) throws ContradictionException {
        int ind = 0;
        while (ind < this.lits.length && this.watchCumul.subtract(this.coefs[this.watching[ind]]).compareTo(this.degree) < 0) {
            if (this.voc.isUnassigned(this.lits[ind]) && !s.enqueue(this.lits[ind], this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++ind;
        }
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVecInt coefs, boolean moreThan, int degree) throws ContradictionException {
        return MinWatchPb.minWatchPbNew(s, voc, ps, MinWatchPb.toVecBigInt(coefs), moreThan, MinWatchPb.toBigInt(degree));
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        VecInt litsVec = new VecInt(ps.size());
        Vec<BigInteger> coefsVec = new Vec<BigInteger>(coefs.size());
        ps.copyTo(litsVec);
        coefs.copyTo(coefsVec);
        IDataStructurePB mpb = MinWatchPb.niceParameters(litsVec, coefsVec, moreThan, degree, voc);
        if (mpb == null) {
            return null;
        }
        MinWatchPb outclause = new MinWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public static MinWatchPb normalizedMinWatchPbNew(UnitPropagationListener s, ILits voc, IDataStructurePB mpb) throws ContradictionException {
        MinWatchPb outclause = new MinWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    protected int nbOfWatched() {
        int retour = 0;
        int ind = 0;
        while (ind < this.watched.length) {
            int i = 0;
            while (i < this.watchingCount) {
                if (this.watching[i] == ind) assert (this.watched[ind]);
                ++i;
            }
            retour += this.watched[ind] ? 1 : 0;
            ++ind;
        }
        return retour;
    }

    @Override
    public boolean propagate(UnitPropagationListener s, int p) {
        assert (this.nbOfWatched() == this.watchingCount);
        assert (this.watchingCount > 1);
        int pIndiceWatching = 0;
        while (pIndiceWatching < this.watchingCount && (this.lits[this.watching[pIndiceWatching]] ^ 1) != p) {
            ++pIndiceWatching;
        }
        int pIndice = this.watching[pIndiceWatching];
        assert (p == (this.lits[pIndice] ^ 1));
        assert (this.watched[pIndice]);
        BigInteger maxCoef = this.maximalCoefficient(pIndice);
        maxCoef = this.updateWatched(maxCoef, pIndice);
        BigInteger upWatchCumul = this.watchCumul.subtract(this.coefs[pIndice]);
        assert (this.nbOfWatched() == this.watchingCount);
        if (upWatchCumul.compareTo(this.degree) < 0) {
            this.voc.watch(p, this);
            assert (this.watched[pIndice]);
            assert (!this.isSatisfiable());
            return false;
        }
        if (upWatchCumul.compareTo(this.degree.add(maxCoef)) < 0) {
            assert (this.watchingCount != 0);
            BigInteger limit = upWatchCumul.subtract(this.degree);
            int i = 0;
            while (i < this.watchingCount) {
                if (limit.compareTo(this.coefs[this.watching[i]]) < 0 && i != pIndiceWatching && !this.voc.isSatisfied(this.lits[this.watching[i]]) && !s.enqueue(this.lits[this.watching[i]], this)) {
                    this.voc.watch(p, this);
                    assert (!this.isSatisfiable());
                    return false;
                }
                ++i;
            }
            this.voc.undos(p).push(this);
        }
        this.watched[pIndice] = false;
        this.watchCumul = upWatchCumul;
        this.watching[pIndiceWatching] = this.watching[--this.watchingCount];
        assert (this.watchingCount != 0);
        assert (this.nbOfWatched() == this.watchingCount);
        return true;
    }

    @Override
    public void remove() {
        int i = 0;
        while (i < this.watchingCount) {
            this.voc.watches(this.lits[this.watching[i]] ^ 1).remove(this);
            this.watched[this.watching[i]] = false;
            ++i;
        }
        this.watchingCount = 0;
        assert (this.nbOfWatched() == this.watchingCount);
    }

    @Override
    public void undo(int p) {
        this.voc.watch(p, this);
        int pIndice = 0;
        while ((this.lits[pIndice] ^ 1) != p) {
            ++pIndice;
        }
        assert (pIndice < this.lits.length);
        this.watchCumul = this.watchCumul.add(this.coefs[pIndice]);
        assert (this.watchingCount == this.nbOfWatched());
        this.watched[pIndice] = true;
        this.watching[this.watchingCount++] = pIndice;
        assert (this.watchingCount == this.nbOfWatched());
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVecInt coefs, boolean moreThan, int degree) {
        return MinWatchPb.watchPbNew(voc, lits, MinWatchPb.toVecBigInt(coefs), moreThan, MinWatchPb.toBigInt(degree));
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) {
        IDataStructurePB mpb = null;
        mpb = MinWatchPb.niceCheckedParameters(lits, coefs, moreThan, degree, voc);
        return new MinWatchPb(voc, mpb);
    }

    public static WatchPb normalizedWatchPbNew(ILits voc, IDataStructurePB mpb) throws ContradictionException {
        return new MinWatchPb(voc, mpb);
    }

    protected BigInteger maximalCoefficient(int pIndice) {
        BigInteger maxCoef = BigInteger.ZERO;
        int i = 0;
        while (i < this.watchingCount) {
            if (this.coefs[this.watching[i]].compareTo(maxCoef) > 0 && this.watching[i] != pIndice) {
                maxCoef = this.coefs[this.watching[i]];
            }
            ++i;
        }
        assert (this.learnt || maxCoef.signum() != 0);
        return maxCoef;
    }

    protected BigInteger updateWatched(BigInteger mc, int pIndice) {
        BigInteger maxCoef = mc;
        if (this.watchingCount < this.size()) {
            BigInteger upWatchCumul = this.watchCumul.subtract(this.coefs[pIndice]);
            BigInteger degreePlusMaxCoef = this.degree.add(maxCoef);
            int ind = 0;
            while (ind < this.lits.length) {
                if (upWatchCumul.compareTo(degreePlusMaxCoef) >= 0) break;
                if (!this.voc.isFalsified(this.lits[ind]) && !this.watched[ind]) {
                    upWatchCumul = upWatchCumul.add(this.coefs[ind]);
                    this.watched[ind] = true;
                    assert (this.watchingCount < this.size());
                    this.watching[this.watchingCount++] = ind;
                    this.voc.watch(this.lits[ind] ^ 1, this);
                    if (this.coefs[ind].compareTo(maxCoef) > 0) {
                        maxCoef = this.coefs[ind];
                        degreePlusMaxCoef = this.degree.add(maxCoef);
                    }
                }
                ++ind;
            }
            this.watchCumul = upWatchCumul.add(this.coefs[pIndice]);
        }
        return maxCoef;
    }
}

