/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.constraints.pb.PBSolver;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSolverWithImpliedClause
extends PBSolver {
    private static final long serialVersionUID = 1L;

    public PBSolverWithImpliedClause(AssertingClauseGenerator acg, LearningStrategy learner, DataStructureFactory dsf, IOrder order) {
        super(acg, learner, dsf, order);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt literals, IVec<BigInteger> coeffs, boolean moreThan, BigInteger degree) throws ContradictionException {
        IVecInt clits;
        IVecInt vlits = this.dimacs2internal(literals);
        assert (vlits.size() == literals.size());
        assert (literals.size() == coeffs.size());
        PBConstr result = (PBConstr)this.dsfactory.createPseudoBooleanConstraint(vlits, coeffs, moreThan, degree);
        if (result != null && (clits = result.computeAnImpliedClause()) != null) {
            this.addConstr(this.dsfactory.createClause(clits));
        }
        return this.addConstr(result);
    }

    @Override
    public String toString(String prefix) {
        return String.valueOf(super.toString(prefix)) + "\n" + prefix + "Add implied clauses in preprocessing";
    }
}

