/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.MinWatchPb;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuebloMinWatchPb
extends MinWatchPb
implements Serializable {
    private static final long serialVersionUID = 1L;

    private PuebloMinWatchPb(ILits voc, IDataStructurePB mpb) {
        super(voc, mpb);
    }

    public static PuebloMinWatchPb minWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVecInt coefs, boolean moreThan, int degree) throws ContradictionException {
        return PuebloMinWatchPb.minWatchPbNew(s, voc, ps, PuebloMinWatchPb.toVecBigInt(coefs), moreThan, PuebloMinWatchPb.toBigInt(degree));
    }

    public static PuebloMinWatchPb minWatchPbNew(UnitPropagationListener s, ILits voc, IVecInt ps, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        VecInt litsVec = new VecInt(ps.size());
        Vec<BigInteger> coefsVec = new Vec<BigInteger>(coefs.size());
        ps.copyTo(litsVec);
        coefs.copyTo(coefsVec);
        IDataStructurePB mpb = PuebloMinWatchPb.niceParameters(litsVec, coefsVec, moreThan, degree, voc);
        PuebloMinWatchPb outclause = new PuebloMinWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public static PuebloMinWatchPb minWatchPbNew(UnitPropagationListener s, ILits voc, IDataStructurePB mpb) throws ContradictionException {
        PuebloMinWatchPb outclause = new PuebloMinWatchPb(voc, mpb);
        if (outclause.degree.signum() <= 0) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVecInt coefs, boolean moreThan, int degree) {
        return PuebloMinWatchPb.watchPbNew(voc, lits, PuebloMinWatchPb.toVecBigInt(coefs), moreThan, PuebloMinWatchPb.toBigInt(degree));
    }

    public static WatchPb watchPbNew(ILits voc, IVecInt lits, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) {
        IDataStructurePB mpb = null;
        mpb = PuebloMinWatchPb.niceCheckedParameters(lits, coefs, moreThan, degree, voc);
        return new PuebloMinWatchPb(voc, mpb);
    }

    public static WatchPb normalizedWatchPbNew(ILits voc, IDataStructurePB mpb) {
        return new PuebloMinWatchPb(voc, mpb);
    }

    @Override
    protected BigInteger maximalCoefficient(int pIndice) {
        return this.coefs[0];
    }

    @Override
    protected BigInteger updateWatched(BigInteger mc, int pIndice) {
        BigInteger maxCoef = mc;
        if (this.watchingCount < this.size()) {
            BigInteger upWatchCumul = this.watchCumul.subtract(this.coefs[pIndice]);
            BigInteger borneSup = this.degree.add(maxCoef);
            int ind = 0;
            while (ind < this.lits.length && upWatchCumul.compareTo(borneSup) < 0) {
                if (!this.voc.isFalsified(this.lits[ind]) && !this.watched[ind]) {
                    upWatchCumul = upWatchCumul.add(this.coefs[ind]);
                    this.watched[ind] = true;
                    assert (this.watchingCount < this.size());
                    this.watching[this.watchingCount++] = ind;
                    this.voc.watch(this.lits[ind] ^ 1, this);
                }
                ++ind;
            }
            this.watchCumul = upWatchCumul.add(this.coefs[pIndice]);
        }
        return maxCoef;
    }

    public static /* bridge */ /* synthetic */ MinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) throws ContradictionException {
        return PuebloMinWatchPb.minWatchPbNew(unitPropagationListener, iLits, iVecInt, iVecInt2, bl, n);
    }
}

