/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.MapPb;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WatchPb
implements PBConstr,
Undoable,
Serializable {
    public static final boolean ATMOST = false;
    public static final boolean ATLEAST = true;
    private static final Random rand = new Random(91648253L);
    protected double activity;
    protected BigInteger[] coefs;
    protected BigInteger degree;
    protected int[] lits;
    protected boolean learnt = false;
    protected boolean locked;
    protected BigInteger watchCumul = BigInteger.ZERO;
    protected ILits voc;

    WatchPb() {
    }

    WatchPb(IDataStructurePB mpb) {
        int size = mpb.size();
        this.lits = new int[size];
        this.coefs = new BigInteger[size];
        mpb.buildConstraintFromMapPb(this.lits, this.coefs);
        this.degree = mpb.getDegree();
        this.sort();
    }

    public boolean isAssertive(int dl) {
        BigInteger slack = BigInteger.ZERO;
        int i = 0;
        while (i < this.lits.length) {
            if (!(this.coefs[i].signum() <= 0 || this.voc.isFalsified(this.lits[i]) && this.voc.getLevel(this.lits[i]) < dl)) {
                slack = slack.add(this.coefs[i]);
            }
            ++i;
        }
        if ((slack = slack.subtract(this.degree)).signum() < 0) {
            return false;
        }
        i = 0;
        while (i < this.lits.length) {
            if (this.coefs[i].signum() > 0 && (this.voc.isUnassigned(this.lits[i]) || this.voc.getLevel(this.lits[i]) >= dl) && slack.compareTo(this.coefs[i]) < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void calcReason(int p, IVecInt outReason) {
        int[] nArray = this.lits;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int q = nArray[n];
            if (this.voc.isFalsified(q)) {
                outReason.push(q ^ 1);
            }
            ++n;
        }
    }

    protected abstract void computeWatches() throws ContradictionException;

    protected abstract void computePropagation(UnitPropagationListener var1) throws ContradictionException;

    @Override
    public int get(int i) {
        return this.lits[i];
    }

    @Override
    public BigInteger getCoef(int i) {
        return this.coefs[i];
    }

    @Override
    public double getActivity() {
        return this.activity;
    }

    public static IDataStructurePB niceParameters(IVecInt ps, IVec<BigInteger> bigCoefs, boolean moreThan, BigInteger bigDeg, ILits voc) throws ContradictionException {
        if (ps.size() == 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (ps.size() != bigCoefs.size()) {
            throw new IllegalArgumentException("Contradiction dans la taille des tableaux ps=" + ps.size() + " coefs=" + bigCoefs.size() + ".");
        }
        return WatchPb.niceCheckedParameters(ps, bigCoefs, moreThan, bigDeg, voc);
    }

    public static IDataStructurePB niceCheckedParameters(IVecInt ps, IVec<BigInteger> bigCoefs, boolean moreThan, BigInteger bigDeg, ILits voc) {
        int i;
        assert (ps.size() != 0 && ps.size() == bigCoefs.size());
        int[] lits = new int[ps.size()];
        ps.copyTo(lits);
        BigInteger[] bc = new BigInteger[bigCoefs.size()];
        bigCoefs.copyTo(bc);
        BigInteger bigDegree = bigDeg;
        if (!moreThan) {
            i = 0;
            while (i < lits.length) {
                bc[i] = bc[i].negate();
                ++i;
            }
            bigDegree = bigDegree.negate();
        }
        i = 0;
        while (i < bc.length) {
            if (bc[i].signum() < 0) {
                lits[i] = lits[i] ^ 1;
                bc[i] = bc[i].negate();
                bigDegree = bigDegree.add(bc[i]);
            }
            ++i;
        }
        MapPb mpb = new MapPb(voc);
        if (bigDegree.signum() > 0) {
            bigDegree = mpb.cuttingPlane(lits, bc, bigDegree);
        }
        if (bigDegree.signum() > 0) {
            bigDegree = mpb.saturation();
        }
        if (bigDegree.signum() <= 0) {
            return null;
        }
        return mpb;
    }

    @Override
    public void incActivity(double claInc) {
        this.activity += claInc;
    }

    public BigInteger slackConstraint() {
        return this.recalcLeftSide().subtract(this.degree);
    }

    public BigInteger slackConstraint(BigInteger[] coefs, BigInteger degree) {
        return this.recalcLeftSide(coefs).subtract(degree);
    }

    public BigInteger recalcLeftSide(BigInteger[] coefs) {
        BigInteger poss = BigInteger.ZERO;
        int i = 0;
        while (i < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[i])) {
                assert (coefs[i].signum() >= 0);
                poss = poss.add(coefs[i]);
            }
            ++i;
        }
        return poss;
    }

    public BigInteger recalcLeftSide() {
        return this.recalcLeftSide(this.coefs);
    }

    protected boolean isSatisfiable() {
        return this.recalcLeftSide().compareTo(this.degree) >= 0;
    }

    @Override
    public boolean learnt() {
        return this.learnt;
    }

    @Override
    public boolean locked() {
        return true;
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    @Override
    public void rescaleBy(double d) {
        this.activity *= d;
    }

    void selectionSort(int from, int to) {
        int i = from;
        while (i < to - 1) {
            int best_i = i;
            int j = i + 1;
            while (j < to) {
                if (this.coefs[j].compareTo(this.coefs[best_i]) > 0) {
                    best_i = j;
                }
                ++j;
            }
            BigInteger tmp = this.coefs[i];
            this.coefs[i] = this.coefs[best_i];
            this.coefs[best_i] = tmp;
            int tmp2 = this.lits[i];
            this.lits[i] = this.lits[best_i];
            this.lits[best_i] = tmp2;
            ++i;
        }
    }

    @Override
    public void setLearnt() {
        this.learnt = true;
    }

    @Override
    public boolean simplify() {
        BigInteger cumul = BigInteger.ZERO;
        int i = 0;
        while (i < this.lits.length && cumul.compareTo(this.degree) < 0) {
            if (this.voc.isSatisfied(this.lits[i])) {
                cumul = cumul.add(this.coefs[i]);
            }
            ++i;
        }
        return cumul.compareTo(this.degree) >= 0;
    }

    @Override
    public int size() {
        return this.lits.length;
    }

    protected final void sort() {
        assert (this.lits != null);
        if (this.coefs.length > 0) {
            this.sort(0, this.size());
            BigInteger buffInt = this.coefs[0];
            int i = 1;
            while (i < this.coefs.length) {
                assert (buffInt.compareTo(this.coefs[i]) >= 0);
                buffInt = this.coefs[i];
                ++i;
            }
        }
    }

    protected final void sort(int from, int to) {
        int width = to - from;
        if (to - from <= 15) {
            this.selectionSort(from, to);
        } else {
            BigInteger pivot = this.coefs[rand.nextInt(width) + from];
            int i = from - 1;
            int j = to;
            while (true) {
                if (this.coefs[++i].compareTo(pivot) > 0) {
                    continue;
                }
                while (pivot.compareTo(this.coefs[--j]) > 0) {
                }
                if (i >= j) break;
                BigInteger tmp = this.coefs[i];
                this.coefs[i] = this.coefs[j];
                this.coefs[j] = tmp;
                int tmp2 = this.lits[i];
                this.lits[i] = this.lits[j];
                this.lits[j] = tmp2;
            }
            this.sort(from, i);
            this.sort(i, to);
        }
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        if (this.lits.length > 0) {
            int i = 0;
            while (i < this.lits.length) {
                stb.append(" + ");
                stb.append(this.coefs[i]);
                stb.append(".");
                stb.append(Lits.toString(this.lits[i]));
                stb.append("[");
                stb.append(this.voc.valueToString(this.lits[i]));
                stb.append("@");
                stb.append(this.voc.getLevel(this.lits[i]));
                stb.append("]");
                stb.append(" ");
                ++i;
            }
            stb.append(">= ");
            stb.append(this.degree);
        }
        return stb.toString();
    }

    @Override
    public void assertConstraint(UnitPropagationListener s) {
        BigInteger tmp = this.slackConstraint();
        int i = 0;
        while (i < this.lits.length) {
            if (this.voc.isUnassigned(this.lits[i]) && tmp.compareTo(this.coefs[i]) < 0) {
                boolean ret = s.enqueue(this.lits[i], this);
                assert (ret);
            }
            ++i;
        }
    }

    @Override
    public BigInteger getDegree() {
        return this.degree;
    }

    @Override
    public void register() {
        block3: {
            assert (this.learnt);
            try {
                this.computeWatches();
            }
            catch (ContradictionException e) {
                System.out.println(this);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public static IVec<BigInteger> toVecBigInt(IVecInt vec) {
        Vec<BigInteger> bigVec = new Vec<BigInteger>(vec.size());
        int i = 0;
        while (i < vec.size()) {
            bigVec.push(BigInteger.valueOf(vec.get(i)));
            ++i;
        }
        return bigVec;
    }

    public static BigInteger toBigInt(int i) {
        return BigInteger.valueOf(i);
    }

    @Override
    public BigInteger[] getCoefs() {
        BigInteger[] coefsBis = new BigInteger[this.coefs.length];
        System.arraycopy(this.coefs, 0, coefsBis, 0, this.coefs.length);
        return coefsBis;
    }

    @Override
    public int[] getLits() {
        int[] litsBis = new int[this.lits.length];
        System.arraycopy(this.lits, 0, litsBis, 0, this.lits.length);
        return litsBis;
    }

    @Override
    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public IVecInt computeAnImpliedClause() {
        BigInteger cptCoefs = BigInteger.ZERO;
        int index = this.coefs.length;
        while (cptCoefs.compareTo(this.degree) > 0 && index > 0) {
            cptCoefs = cptCoefs.add(this.coefs[--index]);
        }
        if (index > 0 && index < this.size() / 2) {
            VecInt literals = new VecInt(index);
            int j = 0;
            while (j <= index) {
                literals.push(this.lits[j]);
                ++j;
            }
            return literals;
        }
        return null;
    }

    public boolean coefficientsEqualToOne() {
        return false;
    }
}

