/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.SearchListener;

public class DotSearchListener
implements SearchListener {
    private final transient Stack<String> pile = new Stack();
    private transient String currentNodeName = null;
    private transient Writer out;
    private transient boolean estOrange = false;

    public DotSearchListener(String fileNameToSave) {
        try {
            this.out = new FileWriter(fileNameToSave);
        }
        catch (IOException e) {
            System.err.println("Problem when created file.");
        }
    }

    public final void assuming(int p) {
        String newName;
        Integer absP = new Integer(Math.abs(p));
        if (this.currentNodeName == null) {
            newName = absP.toString();
            this.pile.push(newName);
            this.saveLine(this.lineTab("\"" + newName + "\"" + "[label=\"" + newName + "\", shape=circle, color=blue, style=filled]"));
        } else {
            newName = this.currentNodeName;
            this.pile.push(newName);
            this.saveLine(this.lineTab("\"" + newName + "\"" + "[label=\"" + absP.toString() + "\", shape=circle, color=blue, style=filled]"));
        }
        this.currentNodeName = newName;
    }

    public final void propagating(int p) {
        String newName = String.valueOf(this.currentNodeName) + "." + p;
        if (this.currentNodeName == null) {
            this.saveLine(this.lineTab("\"null\" [label=\"\", shape=point]"));
        }
        String couleur = this.estOrange ? "orange" : "green";
        this.saveLine(this.lineTab("\"" + newName + "\"" + "[label=\"" + new Integer(p).toString() + "\",shape=point, color=black]"));
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\"" + " -- " + "\"" + newName + "\"" + "[label=" + "\" " + new Integer(p).toString() + "\", fontcolor =" + couleur + ", color = " + couleur + ", style = bold]"));
        this.currentNodeName = newName;
        this.estOrange = false;
    }

    public final void backtracking(int p) {
        String temp = this.pile.pop();
        this.saveLine("\"" + temp + "\"" + "--" + "\"" + this.currentNodeName + "\"" + "[label=\"\", color=red, style=dotted]");
        this.currentNodeName = temp;
    }

    public final void adding(int p) {
        this.estOrange = true;
    }

    public final void learn(Constr clause) {
    }

    public final void delete(int[] clause) {
    }

    public final void conflictFound() {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"red\", style=filled]"));
    }

    public final void solutionFound() {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"green\", style=filled]"));
    }

    public final void beginLoop() {
    }

    public final void start() {
        this.saveLine("graph G {");
    }

    public final void end(Lbool result) {
        this.saveLine("}");
    }

    private final String lineTab(String line) {
        return "\t" + line;
    }

    private final void saveLine(String line) {
        try {
            this.out.write(String.valueOf(line) + '\n');
            if ("}".equals(line)) {
                this.out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

