/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ActivityComparator;
import org.sat4j.minisat.core.ActivityListener;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.Learner;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.LiteralsUtils;
import org.sat4j.minisat.core.NullSearchListener;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.SearchListener;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver
implements ISolver,
UnitPropagationListener,
ActivityListener,
Learner,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    private final IVec<Constr> constrs = new Vec<Constr>();
    private final IVec<Constr> learnts = new Vec<Constr>();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private int qhead = 0;
    protected final IVecInt trail = new VecInt();
    protected final IVecInt trailLim = new VecInt();
    protected int rootLevel;
    private int[] model = null;
    protected ILits voc;
    private IOrder order;
    private final Comparator<Constr> comparator = new ActivityComparator();
    private final SolverStats stats = new SolverStats();
    private final LearningStrategy learner;
    protected final AssertingClauseGenerator analyzer;
    private boolean undertimeout;
    private int timeout = Integer.MAX_VALUE;
    protected DataStructureFactory dsfactory;
    private final SearchParams params;
    private final IVecInt __dimacs_out = new VecInt();
    private SearchListener slistener = new NullSearchListener();
    private boolean[] mseen = new boolean[0];
    private final IVecInt preason = new VecInt();
    private final IVecInt outLearnt = new VecInt();
    public static final ISimplifier NO_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt outLearnt) {
        }

        public String toString() {
            return "No reason simplification";
        }
    };
    public final ISimplifier SIMPLE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt outLearnt) {
            Solver.this.simpleSimplification(outLearnt);
        }

        public String toString() {
            return "Simple reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt outLearnt) {
            Solver.this.expensiveSimplification(outLearnt);
        }

        public String toString() {
            return "Expensive reason simplification";
        }
    };
    private ISimplifier simplifier = NO_SIMPLIFICATION;
    private final IVecInt analyzetoclear = new VecInt();
    private final IVecInt analyzestack = new VecInt();
    private final Handle<Constr> learntConstraint = new Handle();
    private boolean[] fullmodel;
    private double timebegin = 0.0;
    private boolean needToReduceDB;

    protected IVecInt dimacs2internal(IVecInt in) {
        if (this.voc.nVars() == 0) {
            throw new RuntimeException("Please set the number of variables (solver.newVar() or solver.newVar(maxvar)) before adding constraints!");
        }
        this.__dimacs_out.clear();
        this.__dimacs_out.ensure(in.size());
        int i = 0;
        while (i < in.size()) {
            assert (in.get(i) != 0 && Math.abs(in.get(i)) <= this.voc.nVars());
            this.__dimacs_out.unsafePush(this.voc.getFromPool(in.get(i)));
            ++i;
        }
        return this.__dimacs_out;
    }

    public Solver(AssertingClauseGenerator acg, LearningStrategy learner, DataStructureFactory dsf, IOrder order) {
        this(acg, learner, dsf, new SearchParams(), order);
    }

    public Solver(AssertingClauseGenerator acg, LearningStrategy learner, DataStructureFactory dsf, SearchParams params, IOrder order) {
        this.analyzer = acg;
        this.learner = learner;
        this.order = order;
        this.params = params;
        this.setDataStructureFactory(dsf);
    }

    public final void setDataStructureFactory(DataStructureFactory dsf) {
        this.dsfactory = dsf;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.voc = dsf.getVocabulary();
        this.order.setLits(this.voc);
    }

    public void setSearchListener(SearchListener sl) {
        this.slistener = sl;
    }

    @Override
    public void setTimeout(int t) {
        this.timeout = t;
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    @Override
    public int nConstraints() {
        return this.constrs.size();
    }

    @Override
    public void learn(Constr c) {
        this.learnts.push(c);
        c.setLearnt();
        c.register();
        ++this.stats.learnedclauses;
        switch (c.size()) {
            case 2: {
                ++this.stats.learnedbinaryclauses;
                break;
            }
            case 3: {
                ++this.stats.learnedternaryclauses;
            }
        }
    }

    public int decisionLevel() {
        return this.trailLim.size();
    }

    @Override
    public int newVar() {
        int index = this.voc.nVars() + 1;
        this.voc.ensurePool(index);
        this.mseen = new boolean[index + 1];
        this.trail.ensure(index);
        this.trailLim.ensure(index);
        this.order.newVar();
        return index;
    }

    @Override
    public int newVar(int howmany) {
        this.voc.ensurePool(howmany);
        this.order.newVar(howmany);
        this.mseen = new boolean[howmany + 1];
        this.trail.ensure(howmany);
        this.trailLim.ensure(howmany);
        return this.voc.nVars();
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        return this.addConstr(this.dsfactory.createClause(vlits));
    }

    @Override
    public boolean removeConstr(IConstr co) {
        if (co == null) {
            throw new UnsupportedOperationException("Reference to the constraint to remove needed!");
        }
        Constr c = (Constr)co;
        c.remove();
        this.constrs.remove(c);
        this.clearLearntClauses();
        this.cancelLearntLiterals();
        return true;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt literals, IVec<BigInteger> coeffs, boolean moreThan, BigInteger degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        assert (vlits.size() == literals.size());
        assert (literals.size() == coeffs.size());
        return this.addConstr(this.dsfactory.createPseudoBooleanConstraint(vlits, coeffs, moreThan, degree));
    }

    @Override
    public void addAllClauses(IVec<IVecInt> clauses) throws ContradictionException {
        for (IVecInt clause : clauses) {
            this.addClause(clause);
        }
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        int n = literals.size();
        VecInt opliterals = new VecInt(n);
        Iterator iterator = literals.iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            opliterals.push(-p);
        }
        return this.addAtLeast(opliterals, n - degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        return this.addConstr(this.dsfactory.createCardinalityConstraint(vlits, degree));
    }

    public boolean simplifyDB() {
        IVec[] cs = new IVec[]{this.constrs, this.learnts};
        int type = 0;
        while (type < 2) {
            int j = 0;
            int i = 0;
            while (i < cs[type].size()) {
                if (((Constr)cs[type].get(i)).simplify()) {
                    ((Constr)cs[type].get(i)).remove();
                } else {
                    cs[type].moveTo(j++, i);
                }
                ++i;
            }
            cs[type].shrinkTo(j);
            ++type;
        }
        return true;
    }

    @Override
    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nmodel = new int[this.model.length];
        System.arraycopy(this.model, 0, nmodel, 0, this.model.length);
        return nmodel;
    }

    @Override
    public boolean enqueue(int p) {
        return this.enqueue(p, null);
    }

    @Override
    public boolean enqueue(int p, Constr from) {
        assert (p > 1);
        if (this.voc.isSatisfied(p)) {
            return true;
        }
        if (this.voc.isFalsified(p)) {
            return false;
        }
        this.voc.satisfies(p);
        this.voc.setLevel(p, this.decisionLevel());
        this.voc.setReason(p, from);
        this.trail.push(p);
        return true;
    }

    public int analyze(Constr confl, Handle<Constr> outLearntRef) {
        assert (confl != null);
        this.outLearnt.clear();
        boolean[] seen = this.mseen;
        assert (this.outLearnt.size() == 0);
        int i = 0;
        while (i < seen.length) {
            seen[i] = false;
            ++i;
        }
        this.analyzer.initAnalyze();
        int p = -1;
        this.outLearnt.push(-1);
        int outBtlevel = 0;
        do {
            this.preason.clear();
            assert (confl != null);
            confl.calcReason(p, this.preason);
            if (confl.learnt()) {
                this.claBumpActivity(confl);
            }
            int j = 0;
            while (j < this.preason.size()) {
                int q = this.preason.get(j);
                this.order.updateVar(q);
                if (!seen[q >> 1]) {
                    seen[q >> 1] = true;
                    if (this.voc.getLevel(q) == this.decisionLevel()) {
                        this.analyzer.onCurrentDecisionLevelLiteral(q);
                    } else if (this.voc.getLevel(q) > 0) {
                        this.outLearnt.push(q ^ 1);
                        outBtlevel = Math.max(outBtlevel, this.voc.getLevel(q));
                    }
                }
                ++j;
            }
            do {
                p = this.trail.last();
                confl = this.voc.getReason(p);
                this.undoOne();
            } while (!seen[p >> 1]);
        } while (this.analyzer.clauseNonAssertive(confl));
        this.outLearnt.set(0, p ^ 1);
        this.simplifier.simplify(this.outLearnt);
        Constr c = this.dsfactory.createUnregisteredClause(this.outLearnt);
        this.slistener.learn(c);
        outLearntRef.obj = c;
        assert (outBtlevel > -1);
        return outBtlevel;
    }

    public void setSimplifier(ISimplifier simp) {
        this.simplifier = simp;
    }

    private void simpleSimplification(IVecInt outLearnt) {
        boolean[] seen = this.mseen;
        int j = 1;
        int i = 1;
        while (i < outLearnt.size()) {
            Constr r = this.voc.getReason(outLearnt.get(i));
            if (r == null) {
                outLearnt.moveTo(j++, i);
            } else {
                assert (r.get(0) == LiteralsUtils.neg(outLearnt.get(i)));
                int k = 1;
                while (k < r.size()) {
                    if (!seen[r.get(k) >> 1] && this.voc.getLevel(r.get(k)) != 0) {
                        outLearnt.moveTo(j++, i);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        outLearnt.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private void expensiveSimplification(IVecInt outLearnt) {
        this.analyzetoclear.clear();
        outLearnt.copyTo(this.analyzetoclear);
        int i = 1;
        int j = 1;
        while (i < outLearnt.size()) {
            if (this.voc.getReason(outLearnt.get(i)) == null || !this.analyzeRemovable(outLearnt.get(i))) {
                outLearnt.moveTo(j++, i);
            }
            ++i;
        }
        outLearnt.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private boolean analyzeRemovable(int p) {
        assert (this.voc.getReason(p) != null);
        this.analyzestack.clear();
        this.analyzestack.push(p);
        boolean[] seen = this.mseen;
        int top = this.analyzetoclear.size();
        while (this.analyzestack.size() > 0) {
            int q = this.analyzestack.last();
            assert (this.voc.getReason(q) != null);
            Constr c = this.voc.getReason(q);
            this.analyzestack.pop();
            assert (c.get(0) == LiteralsUtils.neg(q));
            int i = 1;
            while (i < c.size()) {
                int l = c.get(i);
                if (!seen[LiteralsUtils.var(l)] && this.voc.getLevel(l) != 0) {
                    if (this.voc.getReason(l) == null) {
                        int j = top;
                        while (j < this.analyzetoclear.size()) {
                            seen[this.analyzetoclear.get((int)j) >> 1] = false;
                            ++j;
                        }
                        this.analyzetoclear.shrink(this.analyzetoclear.size() - top);
                        return false;
                    }
                    seen[l >> 1] = true;
                    this.analyzestack.push(l);
                    this.analyzetoclear.push(l);
                }
                ++i;
            }
        }
        return true;
    }

    public static int decode2dimacs(int p) {
        return ((p & 1) == 0 ? 1 : -1) * (p >> 1);
    }

    /*
     * Unable to fully structure code
     */
    protected void undoOne() {
        p = this.trail.last();
        if (!Solver.$assertionsDisabled && p <= 1) {
            throw new AssertionError();
        }
        if (!Solver.$assertionsDisabled && this.voc.getLevel(p) < 0) {
            throw new AssertionError();
        }
        x = p >> 1;
        this.voc.unassign(p);
        this.voc.setReason(p, null);
        this.voc.setLevel(p, -1);
        this.order.undo(x);
        this.trail.pop();
        undos = this.voc.undos(p);
        if (Solver.$assertionsDisabled || undos != null) ** GOTO lbl18
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            undos.last().undo(p);
            undos.pop();
lbl18:
            // 2 sources

            ** while (undos.size() > 0)
        }
lbl19:
        // 1 sources

    }

    @Override
    public void claBumpActivity(Constr confl) {
        confl.incActivity(this.claInc);
        if (confl.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
    }

    @Override
    public void varBumpActivity(int p) {
        this.order.updateVar(p);
    }

    private void claRescalActivity() {
        int i = 0;
        while (i < this.learnts.size()) {
            this.learnts.get(i).rescaleBy(1.0E-20);
            ++i;
        }
        this.claInc *= 1.0E-20;
    }

    public Constr propagate() {
        while (this.qhead < this.trail.size()) {
            ++this.stats.propagations;
            int p = this.trail.get(this.qhead++);
            this.slistener.propagating(Solver.decode2dimacs(p));
            assert (p > 1);
            IVec<Propagatable> constrs = this.dsfactory.getWatchesFor(p);
            int size = constrs.size();
            int i = 0;
            while (i < size) {
                ++this.stats.inspects;
                if (!constrs.get(i).propagate(this, p)) {
                    this.dsfactory.conflictDetectedInWatchesFor(p, i);
                    this.qhead = this.trail.size();
                    return (Constr)constrs.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    void record(Constr constr) {
        constr.assertConstraint(this);
        this.slistener.adding(Solver.decode2dimacs(constr.get(0)));
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int p) {
        assert (this.trail.size() == this.qhead);
        this.trailLim.push(this.trail.size());
        return this.enqueue(p);
    }

    private void cancel() {
        int decisionvar = this.trail.unsafeGet(this.trailLim.last());
        this.slistener.backtracking(Solver.decode2dimacs(decisionvar));
        int c = this.trail.size() - this.trailLim.last();
        while (c > 0) {
            this.undoOne();
            --c;
        }
        this.trailLim.pop();
    }

    private void cancelLearntLiterals() {
        int c = this.trail.size() - this.rootLevel;
        while (c > 0) {
            this.undoOne();
            --c;
        }
        this.qhead = this.trail.size();
    }

    protected void cancelUntil(int level) {
        while (this.decisionLevel() > level) {
            this.cancel();
        }
        this.qhead = this.trail.size();
    }

    Lbool search(long nofConflicts, Handle<Long> nofLearnts) {
        assert (this.rootLevel == this.decisionLevel());
        ++this.stats.starts;
        int conflictC = 0;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            this.slistener.beginLoop();
            Constr confl = this.propagate();
            assert (this.trail.size() == this.qhead);
            if (confl == null) {
                assert (this.nAssigns() <= this.voc.realnVars());
                if (this.nAssigns() == this.voc.realnVars()) {
                    this.slistener.solutionFound();
                    this.modelFound();
                    return Lbool.TRUE;
                }
                if ((long)conflictC >= nofConflicts) {
                    this.cancelUntil(this.rootLevel);
                    return Lbool.UNDEFINED;
                }
                if (this.needToReduceDB) {
                    this.reduceDB();
                    this.needToReduceDB = false;
                    Runtime.getRuntime().gc();
                }
                ++this.stats.decisions;
                int p = this.order.select();
                assert (p > 1);
                this.slistener.assuming(Solver.decode2dimacs(p));
                boolean ret = this.assume(p);
                assert (ret);
                continue;
            }
            ++this.stats.conflicts;
            ++conflictC;
            this.slistener.conflictFound();
            if (this.decisionLevel() == this.rootLevel) {
                return Lbool.FALSE;
            }
            assert (confl != null);
            int backtrackLevel = this.analyze(confl, this.learntConstraint);
            assert (backtrackLevel < this.decisionLevel());
            this.cancelUntil(Math.max(backtrackLevel, this.rootLevel));
            assert (this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= backtrackLevel);
            if (this.learntConstraint.obj == null) {
                return Lbool.FALSE;
            }
            this.record((Constr)this.learntConstraint.obj);
            this.learntConstraint.obj = null;
            this.decayActivities();
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    void modelFound() {
        this.model = new int[this.trail.size()];
        this.fullmodel = new boolean[this.nVars()];
        int index = 0;
        int i = 1;
        while (i <= this.voc.nVars()) {
            int p;
            if (this.voc.belongsToPool(i) && !this.voc.isUnassigned(p = this.voc.getFromPool(i))) {
                this.model[index++] = this.voc.isSatisfied(p) ? i : -i;
                this.fullmodel[i - 1] = this.voc.isSatisfied(p);
            }
            ++i;
        }
        assert (index == this.model.length);
        this.cancelUntil(this.rootLevel);
    }

    @Override
    public boolean model(int var) {
        if (var <= 0 || var > this.nVars()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.fullmodel == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        return this.fullmodel[var - 1];
    }

    protected void reduceDB() {
        this.reduceDB(this.claInc / (double)this.learnts.size());
    }

    @Override
    public void clearLearntClauses() {
        for (Constr c : this.learnts) {
            c.remove();
        }
        this.learnts.clear();
    }

    protected void reduceDB(double lim) {
        this.sortOnActivity();
        ++this.stats.reduceddb;
        int j = 0;
        int i = 0;
        while (i < this.learnts.size() / 2) {
            Constr c = this.learnts.get(i);
            if (c.locked()) {
                this.learnts.set(j++, this.learnts.get(i));
            } else {
                c.remove();
            }
            ++i;
        }
        while (i < this.learnts.size()) {
            this.learnts.set(j++, this.learnts.get(i));
            ++i;
        }
        System.out.println("c cleaning " + (this.learnts.size() - j) + " clauses out of " + this.learnts.size() + " for limit " + lim);
        this.learnts.shrinkTo(j);
    }

    private void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        Lbool status = Lbool.UNDEFINED;
        double nofConflicts = this.params.initConflictBound;
        double nofLearnts = (double)this.nConstraints() * this.params.initLearntBoundConstraintFactor;
        this.order.init();
        this.learner.init();
        this.timebegin = System.currentTimeMillis();
        this.slistener.start();
        this.model = null;
        this.fullmodel = null;
        if (this.propagate() != null) {
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            return false;
        }
        Iterator iterator = assumps.iterator();
        while (iterator.hasNext()) {
            int q = (Integer)iterator.next();
            if (this.assume(this.voc.getFromPool(q)) && this.propagate() == null) continue;
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        TimerTask stopMe = new TimerTask(){

            public void run() {
                Solver.this.undertimeout = false;
            }
        };
        this.undertimeout = true;
        Timer timer = new Timer(true);
        timer.schedule(stopMe, (long)this.timeout * 1000L);
        this.needToReduceDB = false;
        final long memorybound = Runtime.getRuntime().freeMemory() / 10L;
        TimerTask freeMem = new TimerTask(){

            public void run() {
                long freemem = Runtime.getRuntime().freeMemory();
                if (freemem < memorybound) {
                    Solver.this.needToReduceDB = true;
                }
            }
        };
        timer.schedule(freeMem, 30000L, 5000L);
        Handle<Long> hnofLearnts = new Handle<Long>();
        hnofLearnts.obj = Math.round(nofLearnts);
        while (status == Lbool.UNDEFINED && this.undertimeout) {
            status = this.search(Math.round(nofConflicts), hnofLearnts);
            nofConflicts *= this.params.conflictBoundIncFactor;
        }
        this.cancelUntil(0);
        timer.cancel();
        if (!this.undertimeout) {
            throw new TimeoutException(" Timeout (" + this.timeout + "s) exceeded");
        }
        this.slistener.end(status);
        return status == Lbool.TRUE;
    }

    public SolverStats getStats() {
        return this.stats;
    }

    public IOrder getOrder() {
        return this.order;
    }

    public void setOrder(IOrder h) {
        this.order = h;
        this.order.setLits(this.voc);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public void reset() {
        this.voc.resetPool();
        this.dsfactory.reset();
        this.constrs.clear();
        this.learnts.clear();
        this.stats.reset();
    }

    @Override
    public int nVars() {
        return this.voc.nVars();
    }

    protected IConstr addConstr(Constr constr) {
        if (constr != null) {
            this.constrs.push(constr);
        }
        return constr;
    }

    public DataStructureFactory getDSFactory() {
        return this.dsfactory;
    }

    public IVecInt getOutLearnt() {
        return this.outLearnt;
    }

    public IConstr getIthConstr(int i) {
        return this.constrs.get(i);
    }

    @Override
    public void printStat(PrintStream out, String prefix) {
        this.printStat(new PrintWriter(out), prefix);
    }

    @Override
    public void printStat(PrintWriter out, String prefix) {
        this.stats.printStat(out, prefix);
        double cputime = ((double)System.currentTimeMillis() - this.timebegin) / 1000.0;
        out.println(String.valueOf(prefix) + "speed (decisions/second)\t: " + (double)this.stats.decisions / cputime);
        this.order.printStat(out, prefix);
    }

    @Override
    public String toString(String prefix) {
        StringBuilder stb = new StringBuilder();
        Object[] objs = new Object[]{this.analyzer, this.dsfactory, this.learner, this.params, this.order, this.simplifier};
        stb.append(prefix);
        stb.append("--- Begin Solver configuration ---");
        stb.append("\n");
        Object[] objectArray = objs;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object o = objectArray[n];
            stb.append(prefix);
            stb.append(o.toString());
            stb.append("\n");
            ++n;
        }
        stb.append(prefix);
        stb.append("--- End Solver configuration ---");
        return stb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setExpectedNumberOfClauses(int nb) {
        this.constrs.ensure(nb);
    }

    @Override
    public Map<String, Number> getStat() {
        return this.stats.toMap();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        if (this.isSatisfiable(assumps)) {
            return this.model();
        }
        return null;
    }

    static interface ISimplifier
    extends Serializable {
        public void simplify(IVecInt var1);
    }
}

