/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.learning.LimitedLearning;

public class ActiveLearning
extends LimitedLearning {
    private static final long serialVersionUID = 1L;
    private final double percent;
    private IOrder order;

    public ActiveLearning() {
        this(0.95);
    }

    public ActiveLearning(double d) {
        this.percent = d;
    }

    public void setOrder(IOrder order) {
        this.order = order;
    }

    protected boolean learningCondition(Constr clause) {
        int nbactivevars = 0;
        int i = 0;
        while (i < clause.size()) {
            if (this.order.varActivity(clause.get(i)) > 1.0) {
                ++nbactivevars;
            }
            ++i;
        }
        return (double)nbactivevars > (double)clause.size() * this.percent;
    }

    public String toString() {
        return "Limit learning to clauses containing active literals";
    }
}

