/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;

public class LimitedLearning
implements LearningStrategy {
    private static final long serialVersionUID = 1L;
    private final NoLearningButHeuristics none;
    private final MiniSATLearning all;
    private final int maxpercent;
    private ILits lits;
    private int bound;

    public LimitedLearning() {
        this(10);
    }

    public LimitedLearning(int percent) {
        this.maxpercent = percent;
        this.none = new NoLearningButHeuristics();
        this.all = new MiniSATLearning();
    }

    public void setSolver(Solver s) {
        this.lits = s.getVocabulary();
        this.setVarActivityListener(s);
        this.all.setDataStructureFactory(s.getDSFactory());
    }

    public void learns(Constr constr) {
        if (this.learningCondition(constr)) {
            this.all.learns(constr);
        } else {
            this.none.learns(constr);
        }
    }

    protected boolean learningCondition(Constr constr) {
        return constr.size() <= this.bound;
    }

    public void init() {
        this.setBound(this.lits.realnVars() * this.maxpercent / 100);
        this.all.init();
        this.none.init();
    }

    protected void setBound(int newbound) {
        this.bound = newbound;
    }

    public String toString() {
        return "Limit learning to clauses of size smaller or equal to " + this.maxpercent + "% of the number of variables";
    }

    public void setVarActivityListener(VarActivityListener s) {
        this.none.setVarActivityListener(s);
        this.all.setVarActivityListener(s);
    }
}

