/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.util.ArrayList;
import java.util.Collections;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.minisat.orders.VarOrder;

public class JWOrder
extends VarOrder {
    private static final long serialVersionUID = 1L;
    private ILits23 lits;

    private int computeWeight(int var) {
        int p = var << 1;
        int pos2 = this.lits.nBinaryClauses(p);
        int neg2 = this.lits.nBinaryClauses(p ^ 1);
        int pos3 = this.lits.nTernaryClauses(p);
        int neg3 = this.lits.nTernaryClauses(p ^ 1);
        long weight = (pos2 * neg2 * 100 + pos2 + neg2) * 5 + pos3 * neg3 * 10 + pos3 + neg3;
        assert (weight <= Integer.MAX_VALUE);
        return (int)weight;
    }

    public void setLits(ILits lits) {
        super.setLits(lits);
        this.lits = (ILits23)lits;
    }

    public void init() {
        Temp t;
        super.init();
        ArrayList<Temp> v = new ArrayList<Temp>(this.order.length);
        int i = 1;
        while (i < this.order.length) {
            t = new Temp(this.order[i]);
            v.add(t);
            ++i;
        }
        Collections.sort(v);
        i = 0;
        while (i < v.size()) {
            t = (Temp)v.get(i);
            this.order[i + 1] = t.id;
            int index = t.id >> 1;
            this.varpos[index] = i + 1;
            this.activity[((Temp)t).id >> 1] = t.count;
            ++i;
        }
        this.lastVar = 1;
    }

    protected void updateActivity(int var) {
        this.activity[var] = this.computeWeight(var);
    }

    public String toString() {
        return "Jeroslow-Wang static like heuristics updated when new clauses are learnt";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Temp
    implements Comparable<Temp> {
        private final int id;
        private final int count;

        Temp(int id) {
            this.id = id;
            this.count = JWOrder.this.computeWeight(id >> 1);
        }

        @Override
        public int compareTo(Temp t) {
            if (this.count == 0) {
                return Integer.MAX_VALUE;
            }
            if (t.count == 0) {
                return -1;
            }
            return t.count - this.count;
        }

        public String toString() {
            return this.id + "(" + this.count + ")";
        }
    }
}

