/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.util.ArrayList;
import java.util.Collections;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits2;
import org.sat4j.minisat.orders.VarOrder;

public class MyOrder
extends VarOrder {
    private static final long serialVersionUID = 1L;
    private ILits2 lits;

    public void setLits(ILits lits) {
        super.setLits(lits);
        this.lits = (ILits2)lits;
    }

    public void init() {
        Temp t;
        super.init();
        ArrayList<Temp> v = new ArrayList<Temp>(this.order.length);
        int i = 1;
        while (i < this.order.length) {
            t = new Temp(this.order[i]);
            v.add(t);
            ++i;
        }
        Collections.sort(v);
        i = 0;
        while (i < v.size()) {
            t = (Temp)v.get(i);
            this.order[i + 1] = t.id;
            int index = t.id >> 1;
            this.varpos[index] = i + 1;
            ++i;
        }
        this.lastVar = 1;
    }

    public String toString() {
        return "Init VSIDS order using a POSIT-like static order on 2 and 3 clauses.";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Temp
    implements Comparable<Temp> {
        private final int id;
        private final int count;

        Temp(int id) {
            this.id = id;
            this.count = MyOrder.this.lits.nBinaryClauses(id) + MyOrder.this.lits.nBinaryClauses(id ^ 1);
        }

        @Override
        public int compareTo(Temp t) {
            if (this.count == 0) {
                return Integer.MAX_VALUE;
            }
            if (t.count == 0) {
                return -1;
            }
            return this.count - t.count;
        }

        public String toString() {
            return this.id + "(" + this.count + ")";
        }
    }
}

