/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.math.BigInteger;
import org.sat4j.minisat.core.LiteralsUtils;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.ObjectiveFunction;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class VarOrderHeapObjective
extends VarOrderHeap {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction obj;

    public void setObjectiveFunction(ObjectiveFunction obj) {
        this.obj = obj;
    }

    public void init() {
        super.init();
        if (this.obj != null) {
            IVecInt vars = this.obj.getVars();
            IVec<BigInteger> coefs = this.obj.getCoeffs();
            int i = 0;
            while (i < vars.size()) {
                int p = this.lits.getFromPool(vars.get(i));
                BigInteger c = coefs.get(i);
                if (c.signum() < 0) {
                    p = LiteralsUtils.neg(p);
                }
                int var = LiteralsUtils.var(p);
                this.activity[var] = c.abs().doubleValue();
                if (this.heap.inHeap(var)) {
                    this.heap.increase(var);
                }
                this.phase[var] = LiteralsUtils.neg(p);
                ++i;
            }
        }
    }
}

