/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class MinOneDecorator
extends SolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] prevmodel;
    private int counter;
    private final IVecInt literals = new VecInt();

    public MinOneDecorator(ISolver solver) {
        super(solver);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean result = this.isSatisfiable();
        if (result) {
            this.prevmodel = super.model();
        }
        return result;
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        this.counter = 0;
        int[] nArray = this.prevmodel;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int p = nArray[n];
            if (p > 0) {
                ++this.counter;
            }
            ++n;
        }
        return this.counter;
    }

    public void discard() throws ContradictionException {
        if (this.literals.isEmpty()) {
            int i = 1;
            while (i <= this.nVars()) {
                this.literals.push(i);
                ++i;
            }
        }
        this.addAtMost(this.literals, this.counter - 1);
    }

    public int[] model() {
        return this.prevmodel;
    }

    public void reset() {
        this.literals.clear();
        super.reset();
    }
}

