/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import java.math.BigInteger;
import org.sat4j.reader.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class PseudoOptDecorator
extends SolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction objfct;
    private int[] prevmodel;

    public PseudoOptDecorator(ISolver solver) {
        super(solver);
    }

    public void setObjectTiveFunction(ObjectiveFunction objf) {
        this.objfct = objf;
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean result = super.isSatisfiable();
        if (result) {
            this.prevmodel = super.model();
        }
        return result;
    }

    public boolean hasNoObjectiveFunction() {
        return this.objfct == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        return this.objfct.calculateDegree(this.prevmodel);
    }

    public void discard() throws ContradictionException {
        super.addPseudoBoolean(this.objfct.getVars(), this.objfct.getCoeffs(), false, this.objfct.calculateDegree(this.prevmodel).subtract(BigInteger.ONE));
    }

    public int[] model() {
        return this.prevmodel;
    }
}

