/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.opt.AbstractSelectorVariablesDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class WeightedMaxSatDecorator
extends AbstractSelectorVariablesDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private final IVec<BigInteger> coefs = new Vec<BigInteger>();
    private BigInteger counter;
    private final IVecInt vec = new VecInt();

    public WeightedMaxSatDecorator(ISolver solver) {
        super(solver);
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        this.coefs.push(BigInteger.valueOf(literals.get(0)));
        literals.set(0, this.nborigvars + ++this.nbnewvar);
        return super.addClause(literals);
    }

    public void reset() {
        this.coefs.clear();
        this.vec.clear();
        super.reset();
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    public Number calculateObjective() {
        this.counter = BigInteger.ZERO;
        int[] nArray = this.prevfullmodel;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int q = nArray[n];
            if (q > this.nborigvars) {
                this.counter = this.counter.add(this.coefs.get(q - this.nborigvars - 1));
            }
            ++n;
        }
        return this.counter;
    }

    public void discard() throws ContradictionException {
        if (this.vec.isEmpty()) {
            int i = this.nborigvars + 1;
            while (i <= this.nVars()) {
                this.vec.push(i);
                ++i;
            }
        }
        super.addPseudoBoolean(this.vec, this.coefs, false, this.counter.subtract(BigInteger.ONE));
    }
}

