/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.sat4j.core.VecInt;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class ExtendedDimacsReader
extends DimacsReader {
    public static final int FALSE = 1;
    public static final int TRUE = 2;
    public static final int NOT = 3;
    public static final int AND = 4;
    public static final int NAND = 5;
    public static final int OR = 6;
    public static final int NOR = 7;
    public static final int XOR = 8;
    public static final int XNOR = 9;
    public static final int IMPLIES = 10;
    public static final int IFF = 11;
    public static final int IFTHENELSE = 12;
    public static final int ATLEAST = 13;
    public static final int ATMOST = 14;
    public static final int COUNT = 15;
    private static final long serialVersionUID = 1L;

    public ExtendedDimacsReader(ISolver solver) {
        super(solver);
    }

    protected void readProblemLine(LineNumberReader in) throws IOException, ParseFormatException {
        String line = in.readLine();
        if (line == null) {
            throw new ParseFormatException("premature end of file: <p noncnf ...> expected  on line " + in.getLineNumber());
        }
        StringTokenizer stk = new StringTokenizer(line);
        if (!(stk.hasMoreTokens() && stk.nextToken().equals("p") && stk.hasMoreTokens() && stk.nextToken().equals("noncnf"))) {
            throw new ParseFormatException("problem line expected (p noncnf ...) on line " + in.getLineNumber());
        }
        int vars = Integer.parseInt(stk.nextToken());
        assert (vars > 0);
        this.solver.newVar(vars);
        try {
            this.processClause(new VecInt().push(vars));
        }
        catch (ContradictionException e) {
            assert (false);
            System.err.println("Contradiction when asserting root variable?");
        }
        this.disableNumberOfConstraintCheck();
    }

    protected boolean handleConstr(String line, IVecInt literals) throws ContradictionException {
        boolean added = true;
        assert (literals.size() == 0);
        Scanner scan = new Scanner(line);
        while (scan.hasNext()) {
            int x;
            int gateType = scan.nextInt();
            assert (gateType > 0);
            int nbparam = scan.nextInt();
            assert (nbparam != 0);
            assert (nbparam == -1 || gateType >= 13);
            int k = -1;
            int i = 0;
            while (i < nbparam) {
                k = scan.nextInt();
                ++i;
            }
            int y = scan.nextInt();
            while ((x = scan.nextInt()) != 0) {
                literals.push(x);
            }
            assert (literals.size() == k);
            switch (gateType) {
                case 1: {
                    this.gateFalse(y, literals);
                    break;
                }
                case 2: {
                    this.gateTrue(y, literals);
                    break;
                }
                case 6: {
                    this.or(y, literals);
                    break;
                }
                case 3: {
                    this.not(y, literals);
                    break;
                }
                case 4: {
                    this.and(y, literals);
                    break;
                }
                case 8: {
                    this.xor(y, literals);
                    break;
                }
                case 11: {
                    this.iff(y, literals);
                    break;
                }
                case 12: {
                    this.ite(y, literals);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Gate type " + gateType + " not handled yet");
                }
            }
        }
        literals.clear();
        return added;
    }

    private void gateFalse(int y, IVecInt literals) throws ContradictionException {
        assert (literals.size() == 0);
        VecInt clause = new VecInt(1);
        clause.push(-y);
        this.processClause(clause);
    }

    private void gateTrue(int y, IVecInt literals) throws ContradictionException {
        assert (literals.size() == 0);
        VecInt clause = new VecInt(1);
        clause.push(y);
        this.processClause(clause);
    }

    private void ite(int y, IVecInt literals) throws ContradictionException {
        assert (literals.size() == 3);
        VecInt clause = new VecInt(2);
        clause.push(-y).push(-literals.get(0)).push(literals.get(1));
        this.processClause(clause);
        clause.clear();
        clause.push(-y).push(literals.get(0)).push(literals.get(2));
        this.processClause(clause);
        clause.clear();
        clause.push(-literals.get(0)).push(-literals.get(1)).push(y);
        this.processClause(clause);
        clause.clear();
        clause.push(literals.get(0)).push(-literals.get(2)).push(y);
        this.processClause(clause);
        clause.clear();
        clause.push(-literals.get(1)).push(-literals.get(2)).push(y);
        this.processClause(clause);
    }

    private void and(int y, IVecInt literals) throws ContradictionException {
        VecInt clause = new VecInt(literals.size() + 1);
        clause.push(y);
        int i = 0;
        while (i < literals.size()) {
            clause.push(-literals.get(i));
            ++i;
        }
        this.processClause(clause);
        clause.clear();
        i = 0;
        while (i < literals.size()) {
            clause.clear();
            clause.push(-y);
            clause.push(literals.get(i));
            this.processClause(clause);
            ++i;
        }
    }

    private void or(int y, IVecInt literals) throws ContradictionException {
        VecInt clause = new VecInt(literals.size() + 1);
        literals.copyTo(clause);
        clause.push(-y);
        this.processClause(clause);
        clause.clear();
        int i = 0;
        while (i < literals.size()) {
            clause.clear();
            clause.push(y);
            clause.push(-literals.get(i));
            this.processClause(clause);
            ++i;
        }
    }

    private void processClause(IVecInt clause) throws ContradictionException {
        this.solver.addClause(clause);
    }

    private void not(int y, IVecInt literals) throws ContradictionException {
        assert (literals.size() == 1);
        VecInt clause = new VecInt(2);
        clause.push(-y).push(-literals.get(0));
        this.processClause(clause);
        clause.clear();
        clause.push(y).push(literals.get(0));
        this.processClause(clause);
    }

    void xor(int y, IVecInt literals) throws ContradictionException {
        literals.push(-y);
        int[] f = new int[literals.size()];
        literals.copyTo(f);
        this.xor2Clause(f, 0, false);
    }

    void iff(int y, IVecInt literals) throws ContradictionException {
        literals.push(y);
        int[] f = new int[literals.size()];
        literals.copyTo(f);
        this.iff2Clause(f, 0, false);
    }

    void xor2Clause(int[] f, int prefix, boolean negation) throws ContradictionException {
        if (prefix == f.length - 1) {
            VecInt clause = new VecInt(f.length);
            int i = 0;
            while (i < f.length - 1) {
                clause.push(f[i]);
                ++i;
            }
            clause.push(f[f.length - 1] * (negation ? -1 : 1));
            this.processClause(clause);
            return;
        }
        if (negation) {
            f[prefix] = -f[prefix];
            this.xor2Clause(f, prefix + 1, false);
            f[prefix] = -f[prefix];
            this.xor2Clause(f, prefix + 1, true);
        } else {
            this.xor2Clause(f, prefix + 1, false);
            f[prefix] = -f[prefix];
            this.xor2Clause(f, prefix + 1, true);
            f[prefix] = -f[prefix];
        }
    }

    void iff2Clause(int[] f, int prefix, boolean negation) throws ContradictionException {
        if (prefix == f.length - 1) {
            VecInt clause = new VecInt(f.length);
            int i = 0;
            while (i < f.length - 1) {
                clause.push(f[i]);
                ++i;
            }
            clause.push(f[f.length - 1] * (negation ? -1 : 1));
            this.processClause(clause);
            return;
        }
        if (negation) {
            this.iff2Clause(f, prefix + 1, false);
            f[prefix] = -f[prefix];
            this.iff2Clause(f, prefix + 1, true);
            f[prefix] = -f[prefix];
        } else {
            f[prefix] = -f[prefix];
            this.iff2Clause(f, prefix + 1, false);
            f[prefix] = -f[prefix];
            this.iff2Clause(f, prefix + 1, true);
        }
    }
}

