/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

public class GoodOPBReader
extends Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String COMMENT_SYMBOL = "*";
    private final ISolver solver;
    private final Map<String, Integer> map = new HashMap<String, Integer>();
    private final IVec<String> decode = new Vec<String>();

    public GoodOPBReader(ISolver solver) {
        this.solver = solver;
    }

    public final IProblem parseInstance(java.io.Reader in) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new LineNumberReader(in));
    }

    private IProblem parseInstance(LineNumberReader in) throws ContradictionException, IOException {
        String line;
        this.solver.reset();
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).endsWith(";")) {
                line = line.substring(0, line.length() - 1);
            }
            this.parseLine(line);
        }
        return this.solver;
    }

    void parseLine(String line) throws ContradictionException {
        if (line.startsWith(COMMENT_SYMBOL)) {
            return;
        }
        if (line.startsWith("p")) {
            return;
        }
        if (line.startsWith("min:") || line.startsWith("min :")) {
            return;
        }
        if (line.startsWith("max:") || line.startsWith("max :")) {
            return;
        }
        int index = line.indexOf(":");
        if (index != -1) {
            line = line.substring(index + 1);
        }
        VecInt lits = new VecInt();
        Vec<BigInteger> coeffs = new Vec<BigInteger>();
        Scanner stk = new Scanner(line).useDelimiter("\\s*\\*\\s*|\\s*\\+\\s*|\\s+");
        while (stk.hasNext()) {
            BigInteger coef;
            String token = stk.next();
            if (token.equals(">=") || token.equals("<=") || token.equals("=")) {
                assert (stk.hasNext());
                String tok = stk.next();
                if (tok.startsWith("+")) {
                    tok = tok.substring(1);
                }
                BigInteger d = new BigInteger(tok);
                try {
                    if (token.equals(">=") || token.equals("=")) {
                        this.solver.addPseudoBoolean(lits, coeffs, true, d);
                    }
                    if (!token.equals("<=") && !token.equals("=")) continue;
                    this.solver.addPseudoBoolean(lits, coeffs, false, d);
                    continue;
                }
                catch (ContradictionException ce) {
                    System.out.println("c inconsistent constraint: " + line);
                    System.out.println("c lits: " + lits);
                    System.out.println("c coeffs: " + coeffs);
                    throw ce;
                }
            }
            if (token.equals("+")) {
                assert (stk.hasNext());
                token = stk.next();
            } else if (token.equals("-")) {
                assert (stk.hasNext());
                token = String.valueOf(token) + stk.next();
            }
            try {
                if (token.startsWith("+")) {
                    token = token.substring(1);
                }
                coef = new BigInteger(token);
                assert (stk.hasNext());
                token = stk.next();
            }
            catch (NumberFormatException nfe) {
                coef = BigInteger.ONE;
            }
            if (token.equals("-") || token.equals("~")) {
                assert (stk.hasNext());
                token = String.valueOf(token) + stk.next();
            }
            boolean negative = false;
            if (token.startsWith("+")) {
                token = token.substring(1);
            } else if (token.startsWith("-")) {
                token = token.substring(1);
                assert (coef.equals(BigInteger.ONE));
                coef = BigInteger.ONE.negate();
            } else if (token.startsWith("~")) {
                token = token.substring(1);
                negative = true;
            }
            Integer id = this.map.get(token);
            if (id == null) {
                id = this.solver.newVar();
                this.map.put(token, id);
                this.decode.push(token);
                assert (this.decode.size() == id.intValue());
            }
            coeffs.push(coef);
            int lid = (negative ? -1 : 1) * id;
            lits.push(lid);
            assert (coeffs.size() == lits.size());
        }
    }

    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < model.length) {
            if (model[i] < 0) {
                stb.append("-");
                stb.append(this.decode.get(-model[i] - 1));
            } else {
                stb.append(this.decode.get(model[i] - 1));
            }
            stb.append(" ");
            ++i;
        }
        return stb.toString();
    }

    public void decode(int[] model, PrintWriter out) {
        int i = 0;
        while (i < model.length) {
            if (model[i] < 0) {
                out.print("-");
                out.print(this.decode.get(-model[i] - 1));
            } else {
                out.print(this.decode.get(model[i] - 1));
            }
            out.print(" ");
            ++i;
        }
    }
}

