/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class LecteurDimacs
extends Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TAILLE_BUF = 16384;
    private final ISolver s;
    private transient BufferedInputStream in;
    private int nbLit = 0;
    private int nbClauses = 0;
    private static final char EOF = '\uffff';

    public LecteurDimacs(ISolver s) {
        this.s = s;
    }

    public final IProblem parseInstance(InputStream in) throws ParseFormatException, ContradictionException, IOException {
        this.in = new BufferedInputStream(in, 16384);
        this.s.reset();
        char car = this.passerCommentaire();
        if (this.nbLit == 0) {
            throw new IOException("DIMACS non valide (nombre de Literaux non valide)");
        }
        this.s.newVar(this.nbLit);
        this.s.setExpectedNumberOfClauses(this.nbClauses);
        car = this.passerEspaces();
        if (car == '\uffff') {
            throw new IOException("DIMACS non valide (o? sont les clauses ?)");
        }
        this.ajouterClauses(car);
        in.close();
        return this.s;
    }

    public IProblem parseInstance(java.io.Reader in) throws IOException, ContradictionException {
        throw new UnsupportedOperationException();
    }

    private char passerCommentaire() throws IOException {
        char car;
        do {
            if ((car = this.passerEspaces()) != 'p') continue;
            car = this.lectureNombreLiteraux();
        } while ((car == 'c' || car == 'p') && (car = this.nextLine()) != '\uffff');
        return car;
    }

    private char lectureNombreLiteraux() throws IOException {
        char car = this.nextChiffre();
        if (car != '\uffff') {
            this.nbLit = car - 48;
            while ((car = (char)this.in.read()) >= '0' && car <= '9') {
                this.nbLit = 10 * this.nbLit + (car - 48);
            }
            car = this.nextChiffre();
            this.nbClauses = car - 48;
            while ((car = (char)this.in.read()) >= '0' && car <= '9') {
                this.nbClauses = 10 * this.nbClauses + (car - 48);
            }
            if (car != '\n' && car != '\uffff') {
                this.nextLine();
            }
        }
        return car;
    }

    private void ajouterClauses(char car) throws IOException, ContradictionException {
        VecInt lit = new VecInt();
        int val = 0;
        boolean neg = false;
        do {
            if (car == '-') {
                neg = true;
                car = (char)this.in.read();
            } else if (car == '+') {
                car = (char)this.in.read();
            } else {
                if (car < '0' || car > '9') break;
                val = car - 48;
                car = (char)this.in.read();
            }
            while (car >= '0' && car <= '9') {
                val = val * 10 + car - 48;
                car = (char)this.in.read();
            }
            if (val == 0) {
                this.s.addClause(lit);
                lit.clear();
            } else {
                lit.push(neg ? -val : val);
                neg = false;
                val = 0;
            }
            if (car == '\uffff') continue;
            car = this.passerEspaces();
        } while (car != '\uffff');
    }

    private char passerEspaces() throws IOException {
        char car;
        while ((car = (char)this.in.read()) == ' ' || car == '\n') {
        }
        return car;
    }

    private char nextLine() throws IOException {
        char car;
        while ((car = (char)this.in.read()) != '\n' && car != '\uffff') {
        }
        return car;
    }

    private char nextChiffre() throws IOException {
        char car;
        while ((car = (char)this.in.read()) < '0' || car > '9' && car != '\uffff') {
        }
        return car;
    }

    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < model.length) {
            stb.append(model[i]);
            stb.append(" ");
            ++i;
        }
        stb.append("0");
        return stb.toString();
    }

    public void decode(int[] model, PrintWriter out) {
        int i = 0;
        while (i < model.length) {
            out.print(model[i]);
            out.print(" ");
            ++i;
        }
        out.print("0");
    }
}

