/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ObjectiveFunction;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBReader2005
extends Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ISolver solver;
    private final IVecInt lits;
    private final IVec<BigInteger> coeffs;
    private BigInteger d;
    private String operator;
    private final IVecInt objectiveVars = new VecInt();
    private final IVec<BigInteger> objectiveCoeffs = new Vec<BigInteger>();
    private boolean hasObjFunc = false;
    private int nbVars;
    private int nbConstr;
    transient BufferedReader in;
    char savedChar;
    boolean charAvailable = false;
    boolean eofReached = false;

    protected void metaData(int nbvar, int nbconstr) {
        this.solver.newVar(nbvar);
    }

    protected void beginObjective() {
    }

    protected void endObjective() {
        assert (this.lits.size() == this.coeffs.size());
        assert (this.lits.size() == this.coeffs.size());
        int i = 0;
        while (i < this.lits.size()) {
            this.objectiveVars.push(this.lits.get(i));
            this.objectiveCoeffs.push(this.coeffs.get(i));
            ++i;
        }
    }

    protected void beginConstraint() {
        this.lits.clear();
        this.coeffs.clear();
        assert (this.lits.size() == 0);
        assert (this.coeffs.size() == 0);
    }

    protected void endConstraint() throws ContradictionException {
        assert (this.lits.size() != 0);
        assert (this.coeffs.size() != 0);
        assert (this.lits.size() == this.coeffs.size());
        if ("<=".equals(this.operator) || "=".equals(this.operator)) {
            this.solver.addPseudoBoolean(this.lits, this.coeffs, false, this.d);
        }
        if (">=".equals(this.operator) || "=".equals(this.operator)) {
            this.solver.addPseudoBoolean(this.lits, this.coeffs, true, this.d);
        }
    }

    protected void constraintTerm(BigInteger coeff, String var) {
        this.coeffs.push(coeff);
        int id = Integer.parseInt(var.substring(1));
        int lid = (this.savedChar == '-' ? -1 : 1) * id;
        this.lits.push(lid);
    }

    protected void constraintRelOp(String relop) {
        this.operator = relop;
    }

    protected void constraintRightTerm(BigInteger val) {
        this.d = val;
    }

    private char get() throws IOException {
        if (this.charAvailable) {
            this.charAvailable = false;
            return this.savedChar;
        }
        int c = this.in.read();
        if (c == -1) {
            this.eofReached = true;
        }
        return (char)c;
    }

    public IVecInt getVars() {
        return this.objectiveVars;
    }

    public IVec<BigInteger> getCoeffs() {
        return this.objectiveCoeffs;
    }

    private void putback(char c) {
        this.savedChar = c;
        this.charAvailable = true;
    }

    private boolean eof() {
        return this.eofReached;
    }

    protected void skipSpaces() throws IOException {
        char c;
        while (Character.isWhitespace(c = this.get())) {
        }
        this.putback(c);
    }

    public String readWord() throws IOException {
        char c;
        StringBuffer s = new StringBuffer();
        this.skipSpaces();
        while (!Character.isWhitespace(c = this.get()) && !this.eof()) {
            s.append(c);
        }
        return s.toString();
    }

    public void readInteger(StringBuffer s) throws IOException {
        this.skipSpaces();
        s.setLength(0);
        char c = this.get();
        if (c == '-' || Character.isDigit(c)) {
            s.append(c);
        }
        while (Character.isDigit(c = this.get()) && !this.eof()) {
            s.append(c);
        }
        this.putback(c);
    }

    protected boolean readIdentifier(StringBuffer s) throws IOException, ParseFormatException {
        int varID;
        block4: {
            s.setLength(0);
            this.skipSpaces();
            char c = this.get();
            if (this.eof()) {
                return false;
            }
            if (!Character.isLetter(c) && c != '_') {
                this.putback(c);
                return false;
            }
            s.append(c);
            while (true) {
                c = this.get();
                if (this.eof()) break block4;
                if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') break;
                s.append(c);
            }
            this.putback(c);
        }
        if ((varID = Integer.parseInt(s.substring(1))) > this.nbVars) {
            throw new ParseFormatException("Variable identifier larger than #variables in metadata.");
        }
        return true;
    }

    private String readRelOp() throws IOException {
        this.skipSpaces();
        char c = this.get();
        if (this.eof()) {
            return null;
        }
        if (c == '=') {
            return "=";
        }
        if (c == '>' && this.get() == '=') {
            return ">=";
        }
        return null;
    }

    private void readMetaData() throws IOException, ParseFormatException {
        char c = this.get();
        if (c != '*') {
            throw new ParseFormatException("First line of input file should be a comment");
        }
        String s = this.readWord();
        if (this.eof() || !"#variable=".equals(s)) {
            throw new ParseFormatException("First line should contain #variable= as first keyword");
        }
        this.nbVars = Integer.parseInt(this.readWord());
        s = this.readWord();
        if (this.eof() || !"#constraint=".equals(s)) {
            throw new ParseFormatException("First line should contain #constraint= as second keyword");
        }
        this.nbConstr = Integer.parseInt(this.readWord());
        this.in.readLine();
        this.metaData(this.nbVars, this.nbConstr);
    }

    private void skipComments() throws IOException {
        char c = ' ';
        while (!this.eof() && (c = this.get()) == '*') {
            this.in.readLine();
        }
        this.putback(c);
    }

    protected void readTerm(StringBuffer coeff, StringBuffer var) throws IOException, ParseFormatException {
        this.readInteger(coeff);
        this.skipSpaces();
        char c = this.get();
        if (c != '*') {
            throw new ParseFormatException("'*' expected between a coefficient and a variable");
        }
        if (!this.readIdentifier(var)) {
            throw new ParseFormatException("identifier expected");
        }
    }

    private void readObjective() throws IOException, ParseFormatException {
        StringBuffer var = new StringBuffer();
        StringBuffer coeff = new StringBuffer();
        this.skipSpaces();
        char c = this.get();
        if (c != 'm') {
            this.putback(c);
            return;
        }
        this.hasObjFunc = true;
        if (this.get() == 'i' && this.get() == 'n' && this.get() == ':') {
            this.beginObjective();
            while (!this.eof()) {
                this.readTerm(coeff, var);
                this.constraintTerm(new BigInteger(coeff.toString()), var.toString());
                this.skipSpaces();
                c = this.get();
                if (c == ';') break;
                if (c == '-' || c == '+' || Character.isDigit(c)) {
                    this.putback(c);
                    continue;
                }
                throw new ParseFormatException("unexpected character in objective function");
            }
        } else {
            throw new ParseFormatException("input format error: 'min:' expected");
        }
        this.endObjective();
    }

    private void readConstraint() throws IOException, ParseFormatException, ContradictionException {
        char c;
        StringBuffer var = new StringBuffer();
        StringBuffer coeff = new StringBuffer();
        this.beginConstraint();
        while (!this.eof()) {
            this.readTerm(coeff, var);
            this.constraintTerm(new BigInteger(coeff.toString()), var.toString());
            this.skipSpaces();
            c = this.get();
            if (c == '>' || c == '=') {
                this.putback(c);
                break;
            }
            if (c == '-' || c == '+' || Character.isDigit(c)) {
                this.putback(c);
                continue;
            }
            throw new ParseFormatException("unexpected character in constraint");
        }
        if (this.eof()) {
            throw new ParseFormatException("unexpected EOF before end of constraint");
        }
        String relop = this.readRelOp();
        if (relop == null) {
            throw new ParseFormatException("unexpected relational operator in constraint");
        }
        this.constraintRelOp(relop);
        this.readInteger(coeff);
        this.constraintRightTerm(new BigInteger(coeff.toString()));
        this.skipSpaces();
        c = this.get();
        if (this.eof() || c != ';') {
            throw new ParseFormatException("semicolon expected at end of constraint");
        }
        this.endConstraint();
    }

    public OPBReader2005(ISolver solver) {
        this.solver = solver;
        this.lits = new VecInt();
        this.coeffs = new Vec<BigInteger>();
    }

    public void parse() throws IOException, ParseFormatException, ContradictionException {
        this.readMetaData();
        this.skipComments();
        this.readObjective();
        int nbConstraintsRead = 0;
        while (!this.eof()) {
            this.skipSpaces();
            if (this.eof()) break;
            char c = this.get();
            this.putback(c);
            if (c == '*') {
                this.skipComments();
            }
            if (this.eof()) break;
            this.readConstraint();
            ++nbConstraintsRead;
        }
        if (nbConstraintsRead != this.nbConstr) {
            throw new ParseFormatException("Number of constraints read is different from metadata.");
        }
    }

    @Override
    public final IProblem parseInstance(java.io.Reader in) throws ParseFormatException, ContradictionException {
        return this.parseInstance(new LineNumberReader(in));
    }

    private IProblem parseInstance(LineNumberReader in) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        this.in = in;
        try {
            this.parse();
            return this.solver;
        }
        catch (IOException e) {
            throw new ParseFormatException(e);
        }
    }

    @Override
    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < model.length) {
            if (model[i] < 0) {
                stb.append("-x");
                stb.append(-model[i]);
            } else {
                stb.append("x");
                stb.append(model[i]);
            }
            stb.append(" ");
            ++i;
        }
        return stb.toString();
    }

    @Override
    public void decode(int[] model, PrintWriter out) {
        int i = 0;
        while (i < model.length) {
            if (model[i] < 0) {
                out.print("-x");
                out.print(-model[i]);
            } else {
                out.print("x");
                out.print(model[i]);
            }
            out.print(" ");
            ++i;
        }
    }

    public ObjectiveFunction getObjectiveFunction() {
        if (this.hasObjFunc) {
            return new ObjectiveFunction(this.getVars(), this.getCoeffs());
        }
        return null;
    }
}

